/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUPESDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class EBUDataField
implements TreeNode {
    protected int dataUnitId;
    protected int dataUnitLength;
    protected int reserved_future_use;
    protected int field_parity;
    protected int line_offset;
    protected byte[] data_block;
    protected int offset;
    protected int len;
    protected long pts;
    protected int count = 1;

    public EBUDataField(byte[] data, int offset, int len, long pts) {
        this.dataUnitId = Utils.getInt(data, offset, 1, 255);
        this.dataUnitLength = Utils.getInt(data, offset + 1, 1, 255);
        this.reserved_future_use = Utils.getInt(data, offset + 2, 1, 192) >> 6;
        this.field_parity = Utils.getInt(data, offset + 2, 1, 32) >> 5;
        this.line_offset = Utils.getInt(data, offset + 2, 1, 31);
        this.data_block = data;
        this.offset = offset;
        this.len = len;
        this.pts = pts;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = new KVP(EBUPESDataField.getDataUnitIdString(this.dataUnitId));
        this.addDetailsToJTree(s);
        return s;
    }

    protected void addDetailsToJTree(KVP s) {
        s.add(new KVP("data_unit_id", this.dataUnitId, EBUPESDataField.getDataUnitIdString(this.dataUnitId)));
        s.add(new KVP("data_unit_length", this.dataUnitLength));
        s.add(new KVP("reserved_future_use", this.reserved_future_use));
        s.add(new KVP("field_parity", this.field_parity));
        s.add(new KVP("line_offset", this.line_offset));
        s.add(new KVP("pts", this.pts, Utils.printTimebase90kHz(this.pts)));
        s.add(new KVP("count", this.count));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.dataUnitId;
        result = 31 * result + this.dataUnitLength;
        result = 31 * result + Arrays.hashCode(this.data_block);
        result = 31 * result + this.field_parity;
        result = 31 * result + this.line_offset;
        result = 31 * result + this.reserved_future_use;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EBUDataField other = (EBUDataField)obj;
        if (this.dataUnitId != other.dataUnitId) {
            return false;
        }
        if (this.dataUnitLength != other.dataUnitLength) {
            return false;
        }
        if (!Utils.equals(this.data_block, this.offset, this.len, other.data_block, other.offset, other.len)) {
            return false;
        }
        if (this.field_parity != other.field_parity) {
            return false;
        }
        if (this.line_offset != other.line_offset) {
            return false;
        }
        return this.reserved_future_use == other.reserved_future_use;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void incCount(int t) {
        this.count += t;
    }

    public int getDataUnitId() {
        return this.dataUnitId;
    }

    public int getDataUnitLength() {
        return this.dataUnitLength;
    }

    public int getField_parity() {
        return this.field_parity;
    }

    public int getLine_offset() {
        return this.line_offset;
    }

    public long getPts() {
        return this.pts;
    }

    protected byte[] getData_block() {
        return this.data_block;
    }

    protected int getLen() {
        return this.len;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected int getReserved_future_use() {
        return this.reserved_future_use;
    }
}

