/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.VPSDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.WSSDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class EBUPESDataField
extends PesPacketData {
    private final int data_identifier;
    private final List<EBUDataField> fieldList = new ArrayList<EBUDataField>();

    public static String getDataUnitIdString(int dataUnitId) {
        if (0 <= dataUnitId && dataUnitId <= 1) {
            return "Reserved";
        }
        if (4 <= dataUnitId && dataUnitId <= 127) {
            return "Reserved";
        }
        if (128 <= dataUnitId && dataUnitId <= 190) {
            return "user defined";
        }
        if (193 <= dataUnitId && dataUnitId <= 194) {
            return "Reserved";
        }
        if (199 <= dataUnitId && dataUnitId <= 254) {
            return "Reserved";
        }
        return switch (dataUnitId) {
            case 2 -> "EBU Teletext non-subtitle data";
            case 3 -> "EBU Teletext subtitle data";
            case 192 -> "inverted teletext";
            case 195 -> "VPS (Video Programming System)";
            case 196 -> "WSS (Wide Screen Signalling)";
            case 197 -> "CC (Closed Caption)";
            case 198 -> "monochrome 4:2:2 samples";
            case 255 -> "data_unit for stuffing";
            default -> "illegal value";
        };
    }

    public EBUPESDataField(PesPacketData pesData) {
        super(pesData);
        int dataUnitLen;
        int offset = pesData.getPesDataStart();
        int dataUnitId = -1;
        this.data_identifier = Utils.getInt(this.data, offset, 1, 255);
        for (int t = 1; t < pesData.getPesDataLen() && dataUnitId != 0; t += dataUnitLen + 2) {
            dataUnitId = Utils.getInt(this.data, offset + t, 1, 255);
            dataUnitLen = Utils.getInt(this.data, offset + t + 1, 1, 255);
            if (offset + t + 2 + 44 <= this.data.length) {
                switch (dataUnitId) {
                    case 2: 
                    case 3: 
                    case 192: 
                    case 193: {
                        this.fieldList.add(new TxtDataField(this.data, offset + t, dataUnitLen, this.getPesHeader().getPts()));
                        break;
                    }
                    case 196: {
                        this.fieldList.add(new WSSDataField(this.data, offset + t, dataUnitLen, this.getPesHeader().getPts()));
                        break;
                    }
                    case 195: {
                        this.fieldList.add(new VPSDataField(this.data, offset + t, dataUnitLen, this.getPesHeader().getPts()));
                        break;
                    }
                    default: {
                        this.fieldList.add(new EBUDataField(this.data, offset + t, dataUnitLen, this.getPesHeader().getPts()));
                        break;
                    }
                }
                continue;
            }
            dataUnitId = 0;
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = (KVP)this.getJTreeNode(modus, new KVP("EBU PES Packet"));
        s.add(new KVP("data_identifier", this.data_identifier, Utils.getDataIDString(this.data_identifier)));
        Utils.addListJTree(s, this.fieldList, modus, "fields");
        return s;
    }

    public List<EBUDataField> getFieldList() {
        return this.fieldList;
    }
}

