/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class ObjectLink
implements TreeNode {
    private final byte[] data_block;
    protected int offset;

    public ObjectLink(byte[] data, int offset) {
        this.data_block = data;
        this.offset = offset;
    }

    public KVP getJTreeNode(String name) {
        if (this.getPageTens() == 255 && this.getPageUnits() == 15) {
            return new KVP("Object Link not used");
        }
        KVP s = new KVP(name + " " + TxtDataField.formatPageNo(this.getMagazine(), this.getPageTens() * 16 + this.getPageUnits(), 16255));
        s.add(new KVP("Magazine ", this.getMagazine()));
        s.add(new KVP("pageTens ", this.getPageTens()));
        s.add(new KVP("pageUnits ", this.getPageUnits()));
        s.add(new KVP("numberOfSubpages", this.getNumberOfSubpages()));
        s.add(new KVP("fallbackProtocol", this.getFallbackProtocol()));
        s.add(new KVP("defaultSidePanel", this.getDefaultSidePanel()));
        s.add(new KVP("defaultBackgroundColour", this.getDefaultBackgroundColour()));
        s.add(new KVP("defaultObject1Type", this.getDefaultObject1Type(), EBUTeletextHandler.getObjectTypeString(this.getDefaultObject1Type())));
        s.add(new KVP("defaultObject2Type", this.getDefaultObject2Type(), EBUTeletextHandler.getObjectTypeString(this.getDefaultObject2Type())));
        s.add(new KVP("defaultObject1", this.getDefaultObject1(), "subPage S1:" + this.getDefaultObject1SubPageS1() + ", Pointer location:" + this.getDefaultObject1PointerLocation()));
        s.add(new KVP("defaultObject2", this.getDefaultObject2(), "subPage S1:" + this.getDefaultObject2SubPageS1() + ", Pointer location:" + this.getDefaultObject2PointerLocation()));
        return s;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        return this.getJTreeNode("Object Link");
    }

    public byte[] getData_block() {
        return this.data_block;
    }

    public int getMagazine() {
        return Utils.getHammingReverseByte(this.data_block[this.offset]) & 7;
    }

    public int getPageTens() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 1]);
    }

    public int getPageUnits() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 2]);
    }

    public int getNumberOfSubpages() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 3]);
    }

    public int getFallbackProtocol() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 4]) & 1;
    }

    public int getDefaultSidePanel() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 4]) & 6) >> 1;
    }

    public int getDefaultBackgroundColour() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 4]) & 8) >> 3;
    }

    public int getDefaultObject1Type() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 5]) & 3;
    }

    public int getDefaultObject2Type() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 5]) & 0xC) >> 2;
    }

    public int getDefaultObject1() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 6]) + 16 * Utils.getHammingReverseByte(this.data_block[this.offset + 7]);
    }

    public int getDefaultObject1SubPageS1() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 6]);
    }

    public int getDefaultObject1TripletNoOffset() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 7]) & 6) >> 1;
    }

    public int getDefaultObject1PointerLocation() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 7]) & 8) >> 3;
    }

    public int getDefaultObject1PointerPosition() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 7]) & 1;
    }

    public int getDefaultObject2() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 8]) + 16 * Utils.getHammingReverseByte(this.data_block[this.offset + 9]);
    }

    public int getDefaultObject2SubPageS1() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 8]);
    }

    public int getDefaultObject2TripletNoOffset() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 9]) & 6) >> 1;
    }

    public int getDefaultObject2PointerLocation() {
        return (Utils.getHammingReverseByte(this.data_block[this.offset + 9]) & 8) >> 3;
    }

    public int getDefaultObject2PointerPosition() {
        return Utils.getHammingReverseByte(this.data_block[this.offset + 9]) & 1;
    }

    public int getPageNo() {
        return this.getPageTens() * 16 + this.getPageUnits();
    }

    public String toString() {
        return "mag:" + this.getMagazine() + ", page:" + this.getPageNo() + ", defaultObject1:" + this.getDefaultObject1() + ", getDefaultObject1Type:" + this.getDefaultObject1Type() + ", defaultObject2" + this.getDefaultObject2() + ", getDefaultObject2Type:" + this.getDefaultObject2Type();
    }
}

