/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.SubPage;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtTriplet;

public class PageLine
extends TxtDataField {
    private final SubPage pageHandler;

    public PageLine(SubPage page, TxtDataField l) {
        super(l.getData_block(), l.getOffset(), l.getLen(), l.getPts());
        this.pageHandler = page;
    }

    @Override
    protected String getTeletextHTML(byte[] b) {
        String bg = "black";
        String fg = "white";
        StringBuilder buf = new StringBuilder("<code><b><span style=\"background-color: black; color: white; \">");
        for (byte ch : b) {
            if (ch == 32) {
                buf.append("&nbsp;");
                continue;
            }
            if (ch == 60) {
                buf.append("&lt;");
                continue;
            }
            if (ch == 38) {
                buf.append("&amp;");
                continue;
            }
            if (ch > 32 && ch < 127) {
                int nocs = this.pageHandler.getNationalOptionCharSubset(false);
                buf.append(TxtTriplet.getNationalOptionChar(ch, nocs));
                continue;
            }
            if (ch >= 0 && ch <= 7) {
                fg = PageLine.getHTMLColorString(ch);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch >= 16 && ch <= 23) {
                fg = PageLine.getHTMLColorString(ch - 16);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch == 28) {
                bg = PageLine.getHTMLColorString(0);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch == 29) {
                bg = fg;
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            buf.append("&nbsp;");
        }
        buf.append("</span></b></code>");
        return buf.toString();
    }
}

