/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.DRCSCharacter;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.DRCSLink;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Magazine;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.ObjectLink;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Page;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.PageLine;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TextConstants;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Triplet;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtTriplet;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.SaveAble;
import nl.digitalekabeltelevisie.util.BitString;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;

public class SubPage
implements TreeNode,
ImageSource,
TextConstants,
SaveAble {
    public static final String BLACK_HTML_LINE = "<code><b><span style=\"background-color: black; color: white;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></b></code>";
    private final Page pageHandler;
    private final int subPageNo;
    protected PageLine[] linesList = new PageLine[26];
    protected TxtDataField[] packetx_26 = new TxtDataField[16];
    protected TxtDataField[] packetx_27 = new TxtDataField[16];
    protected TxtDataField[] packetx_28 = new TxtDataField[16];
    private static final int charWidth = 15;
    private static final int charHeight = 19;
    private static final int textColumns = 40;
    private static final int textRows = 25;
    private static final int width = 600;
    private static final int height = 475;
    public static final int NO_OBJECT_TYPE = 0;
    public static final int ACTIVE_OBJECT_TYPE = 1;
    public static final int ADAPTIVE_OBJECT_TYPE = 2;
    public static final int PASSIVE_OBJECT_TYPE = 3;
    private static final ClassLoader classLoader = SubPage.class.getClassLoader();
    private char[][] txt = new char[25][40];
    private int[][] bgColor = new int[25][40];
    private int[][] fgColor = new int[25][40];
    private int[][] effect = new int[25][40];
    private static final Logger logger = Logger.getLogger(SubPage.class.getName());
    private static BufferedImage g3CharsImage;

    public static String getMIPPageFunctionString(int pageCode) {
        if (2 <= pageCode && pageCode <= 79) {
            return "Normal page, #sub pages " + pageCode;
        }
        if (82 <= pageCode && pageCode <= 111) {
            return "Reserved";
        }
        if (112 <= pageCode && pageCode <= 119) {
            return "Subtitle page";
        }
        if (130 <= pageCode && pageCode <= 207) {
            return "TV schedule pages, multi-page set, #sub pages " + (pageCode - 128);
        }
        if (240 <= pageCode && pageCode <= 243) {
            return "Systems Pages for Broadcasters use (downstream processing)";
        }
        if (244 <= pageCode && pageCode <= 246) {
            return "Engineering Test pages";
        }
        return switch (pageCode) {
            case 0 -> "Page not in transmission";
            case 1 -> "Single normal page";
            case 80 -> "Normal page, multi-page set Sub-pages in the range 80 to 2^12-1";
            case 81 -> "Normal page, multi-page set Sub-pages in the range 2^12 to 2^13-2";
            case 120 -> "Subtitle Menu Page";
            case 121 -> "Page not following normal sub-code rules";
            case 122 -> "TV programme related warning page";
            case 123 -> "Current TV Programme information, multi-page set";
            case 124 -> "Current TV Programme information, single page";
            case 125 -> "\"Now and Next\" TV Programmes";
            case 126 -> "Index page to TV-related pages, multi-page set";
            case 127 -> "Index page to TV-related pages, single page";
            case 128 -> "Page transmitted but NOT part of the public service";
            case 129 -> "Single Page containing TV schedule information";
            case 208 -> "TV schedule pages, multi-page set, Sub-pages in the range 80 to 2^12-1";
            case 209 -> "TV schedule pages, multi-page set, Sub-pages in the range 2^12 to 2^13-2";
            case 224 -> "Page Format - CA - data broadcasting page, Sub-pages in the range 1 to 2^12-1";
            case 225 -> "Page Format - CA - data broadcasting page, Sub-pages in the range 2^12 to 2^13-2";
            case 226 -> "Page Format - CA - data broadcasting page, Number of sub-pages not defined in packets with Y = 15 to Y = 24";
            case 227 -> "Page Format - Clear data broadcasting page including EPG data";
            case 228 -> "Page Format - Clear data broadcasting page but not carrying EPG data";
            case 229 -> "DRCS page (use not defined)";
            case 230 -> "Object page (use not defined)";
            case 231 -> "Systems page without displayable element. Function defined by page number";
            case 232 -> "DRCS page referenced in the MOT for this magazine";
            case 233 -> "DRCS page referenced in the MOT for this magazine but not required by a page in this magazine";
            case 234 -> "DRCS page referenced in the MOT for a different magazine but not required by a page in this magazine";
            case 235 -> "DRCS page not referenced in the MOT for a different magazine and required by a page in another magazine";
            case 236 -> "Object page referenced in the MOT for this magazine";
            case 237 -> "Object page referenced in the MOT for this magazine but not required by a page in this magazine";
            case 238 -> "Object page referenced in the MOT for a different magazine but not required by a page in this magazine";
            case 239 -> "Object page not referenced in the MOT for a different magazine and required by a page in another magazine";
            case 247 -> "Systems page with displayable element. Function defined by page number";
            case 248 -> "Keyword Search list page, multi-page set";
            case 249 -> "Keyword Search list page, single page";
            case 252 -> "Trigger message page";
            case 253 -> "Automatic Channel Installation (ACI)";
            case 254 -> "TOP page (BTT, AIT, MPT or MPT-EX)";
            default -> "Reserved";
        };
    }

    public int getNationalOptionCharSubset(boolean useSecondaryG0set) {
        TxtDataField pageEnhancement;
        int r = 0;
        TxtDataField txtDataField = pageEnhancement = this.packetx_28[0] != null ? this.packetx_28[0] : this.getMagazine().getPageEnhanceMentDataPackes(0);
        if (pageEnhancement != null) {
            if (!useSecondaryG0set) {
                int tripletVal = pageEnhancement.getTripletList().getFirst().getVal();
                int g0CharacterSet = (tripletVal & 0x3C00) >>> 7;
                int nationalOptionSubset = Utils.invNationalOptionSet[(tripletVal & 0x380) >>> 7];
                r = g0CharacterSet | nationalOptionSubset;
            } else {
                int triplet1Val = pageEnhancement.getTripletList().get(0).getVal();
                int triplet2Val = pageEnhancement.getTripletList().get(1).getVal();
                int value = (triplet1Val & 0x3C000) >> 14 | (triplet2Val & 7) << 4;
                r = value & 0x78 | Utils.invNationalOptionSet[value & 7];
            }
        } else if (this.linesList[0] != null) {
            int defaultG0CharacterSet = PreferencesManager.getDefaultG0CharacterSet();
            r = defaultG0CharacterSet << 3 | this.linesList[0].getNationalOptionCharacterSubset();
        }
        return r;
    }

    public SubPage(Page page, int s) {
        this.pageHandler = page;
        this.subPageNo = s;
    }

    public void setHeader(TxtDataField txtDataField) {
        if (txtDataField.getSubPage() != this.subPageNo) {
            logger.log(Level.INFO, "txtDataField.getSubPage()!=subPageNo," + txtDataField.getSubPage() + "!=" + this.subPageNo);
        }
        if (txtDataField.isErasePage()) {
            this.linesList = new PageLine[26];
            this.packetx_26 = new TxtDataField[16];
            this.packetx_27 = new TxtDataField[16];
            this.packetx_28 = new TxtDataField[16];
        }
        this.linesList[0] = new PageLine(this, txtDataField);
    }

    public void addLine(TxtDataField txtDataField) {
        int packetNo = txtDataField.getPacketNo();
        switch (packetNo) {
            case 26: {
                this.packetx_26[txtDataField.getDesignationCode()] = txtDataField;
                break;
            }
            case 27: {
                this.packetx_27[txtDataField.getDesignationCode()] = txtDataField;
                break;
            }
            case 28: {
                this.packetx_28[txtDataField.getDesignationCode()] = txtDataField;
                break;
            }
            default: {
                this.linesList[packetNo] = new PageLine(this, txtDataField);
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = new KVP("SubPage " + Utils.toHexString(this.subPageNo, 4));
        s.addImageSource(this, "Sub Page");
        JMenuItem objectMenu = new JMenuItem("Save Page as .t42");
        objectMenu.setActionCommand("t42");
        s.setSubMenuAndOwner(objectMenu, this);
        for (int i = 0; i < 26; ++i) {
            PageLine pageLine = this.linesList[i];
            if (pageLine != null) {
                s.add(pageLine.getHTMLJTreeNode(modus));
                continue;
            }
            s.add(new KVP("").setHtmlLabel(BLACK_HTML_LINE));
        }
        for (TxtDataField txtDatafield : this.packetx_26) {
            if (txtDatafield == null) continue;
            s.add(txtDatafield.getJTreeNode(modus));
        }
        for (TxtDataField txtDatafield : this.packetx_27) {
            if (txtDatafield == null) continue;
            s.add(txtDatafield.getJTreeNode(modus));
        }
        for (TxtDataField txtDatafield : this.packetx_28) {
            if (txtDatafield == null) continue;
            s.add(txtDatafield.getJTreeNode(modus));
        }
        if (this.linesList[0] != null && this.linesList[0].getPageNumber() == 253) {
            this.addMIPPageDetailsToJTree(s);
        }
        if (this.isMOTpage()) {
            this.addMOTPageDetailsToJTree(modus, s);
        }
        if (this.isDRCSDownloadingpage()) {
            this.addDRCSDownloadPageDetailsToJTree(modus, s);
        }
        if (this.isObjectDefinitionpage()) {
            this.addObjectDefinitionPageDetailsToJTree(modus, s);
        }
        if (this.isBTTpage()) {
            this.addBTTPageDetailsToJTree(s);
        }
        if (this.isAITpage()) {
            this.addAITPageDetailsToJTree(s);
        }
        if (this.isMPTpage()) {
            this.addMPTPageDetailsToJTree(s);
        }
        return s;
    }

    private void addMPTPageDetailsToJTree(KVP s) {
        PageLine txtDataField;
        int i;
        KVP mptPage = new KVP("Multipage Table (MPT) Page");
        s.add(mptPage);
        for (i = 1; i <= 23; ++i) {
            txtDataField = this.linesList[i];
            if (txtDataField == null) continue;
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < 39; ++j) {
                int value = Utils.getHammingReverseByte(txtDataField.getRawByte(j));
                b.append(Integer.toHexString(value));
            }
            mptPage.add(new KVP("Row " + i, b.toString()));
        }
        for (i = 1; i <= 20; ++i) {
            txtDataField = this.linesList[i];
            if (txtDataField == null) continue;
            for (int j = 0; j < 39; ++j) {
                int value = Utils.getHammingReverseByte(txtDataField.getRawByte(j));
                int pageNo = 100 + (i - 1) * 40 + j;
                mptPage.add(new KVP("page " + pageNo, value));
            }
        }
    }

    private void addAITPageDetailsToJTree(KVP s) {
        KVP aitPage = new KVP("Additional Information Tables (AIT) Page");
        s.add(aitPage);
        for (int i = 1; i <= 22; ++i) {
            PageLine txtDataField = this.linesList[i];
            if (txtDataField == null) continue;
            for (int j = 0; j < 2; ++j) {
                StringBuilder b = new StringBuilder();
                for (int k = 0; k < 8; ++k) {
                    int v = Utils.getHammingReverseByte(txtDataField.getRawByte(j * 20 + k));
                    b.append(Integer.toHexString(v));
                }
                StringBuilder buf = new StringBuilder();
                for (int k = 8; k < 20; ++k) {
                    byte ch = txtDataField.getPageDataByte(j * 20 + k);
                    if (ch >= 32 && ch < 127) {
                        buf.append((char)ch);
                        continue;
                    }
                    buf.append(' ');
                }
                aitPage.add(new KVP("Title " + ((i - 1) * 2 + j), String.valueOf(b) + " " + String.valueOf(buf)));
            }
        }
    }

    private void addBTTPageDetailsToJTree(KVP s) {
        PageLine txtDataField;
        int i;
        KVP bttPage = new KVP("Basic Top Table (BTT) Page");
        s.add(bttPage);
        for (i = 1; i <= 20; ++i) {
            txtDataField = this.linesList[i];
            if (txtDataField == null) continue;
            for (int j = 0; j < 39; ++j) {
                int value = Utils.getHammingReverseByte(txtDataField.getRawByte(j));
                int pageNo = 100 + (i - 1) * 40 + j;
                bttPage.add(new KVP("page " + pageNo, value, SubPage.getPageDescription(value)));
            }
        }
        for (i = 21; i <= 23; ++i) {
            txtDataField = this.linesList[i];
            if (txtDataField == null) continue;
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < 39; ++j) {
                int value = Utils.getHammingReverseByte(txtDataField.getRawByte(j));
                b.append(Integer.toHexString(value));
            }
            bttPage.add(new KVP("Row " + i, b.toString()));
        }
    }

    private static String getPageDescription(int value) {
        return switch (value) {
            case 0 -> "Page not in transmission cycle";
            case 1 -> "Text Page, extra information";
            case 2 -> "Header Page, main group page of TV programs, extra information";
            case 3 -> "Header Page, main group page of TV programs, extra information, multiple page";
            case 4 -> "Main Group Page, extra information";
            case 5 -> "Main Group Page, extra information, multiple page";
            case 6 -> "Group Page, extra information";
            case 7 -> "Group Page, extra information, multiple page";
            case 8 -> "Normal Page";
            case 9 -> "Normal Page, extra information";
            case 10 -> "Normal Page, multiple page";
            case 11 -> "Normal Page, extra information, multiple page";
            default -> "Reserved";
        };
    }

    private void addObjectDefinitionPageDetailsToJTree(int modus, KVP s) {
        int functionByte;
        TxtDataField txtDataField;
        int i;
        KVP objPage = new KVP("Object Definition Page");
        s.add(objPage);
        for (i = 1; i <= 4; ++i) {
            txtDataField = this.linesList[i];
            if (txtDataField == null || ((functionByte = Utils.getHammingReverseByte(txtDataField.getRawByte(0))) & 1) == 0) continue;
            KVP pointerLineTreeNode = new KVP("Pointer Table line " + i);
            pointerLineTreeNode.add(new KVP("functionByte", functionByte));
            objPage.add(pointerLineTreeNode);
            List<Triplet> tripletList = txtDataField.getTripletList();
            for (int j = 0; j <= 3; ++j) {
                Triplet tr1 = tripletList.get(1 + j * 3);
                Triplet tr2 = tripletList.get(1 + j * 3 + 1);
                Triplet tr3 = tripletList.get(1 + j * 3 + 2);
                int activeObjectEven = tr1.getVal() & 0x1FF;
                int activeObjectOdd = (tr1.getVal() & 0x3FE00) >> 9;
                int adaptiveObjectEven = tr2.getVal() & 0x1FF;
                int adaptiveObjectOdd = (tr2.getVal() & 0x3FE00) >> 9;
                int pasiveObjectEven = tr3.getVal() & 0x1FF;
                int pasiveObjectOdd = (tr3.getVal() & 0x3FE00) >> 9;
                this.addObjectPointer((i - 1) * 8 + j * 2, pointerLineTreeNode, activeObjectEven, "Active Object", modus);
                this.addObjectPointer((i - 1) * 8 + j * 2, pointerLineTreeNode, adaptiveObjectEven, "Adaptive Object", modus);
                this.addObjectPointer((i - 1) * 8 + j * 2, pointerLineTreeNode, pasiveObjectEven, "Passive Object", modus);
                this.addObjectPointer((i - 1) * 8 + j * 2 + 1, pointerLineTreeNode, activeObjectOdd, "Active Object", modus);
                this.addObjectPointer((i - 1) * 8 + j * 2 + 1, pointerLineTreeNode, adaptiveObjectOdd, "Adaptive Object", modus);
                this.addObjectPointer((i - 1) * 8 + j * 2 + 1, pointerLineTreeNode, pasiveObjectOdd, "Passive Object", modus);
            }
        }
        for (i = 3; i <= 41; ++i) {
            txtDataField = this.getLine(i);
            if (txtDataField == null || ((functionByte = Utils.getHammingReverseByte(txtDataField.getRawByte(0))) & 1) != 0) continue;
            List<TxtTriplet> tripletList = txtDataField.getTxtTripletList();
            Utils.addListJTree(objPage, tripletList, modus, "triplet_list line " + i);
        }
    }

    private void addObjectPointer(int i, KVP t, int objPointer, String label, int modus) {
        if (objPointer != 511) {
            KVP s = new KVP(label + " " + i, objPointer);
            t.add(s);
            int lineNo = 3 + objPointer / 13;
            int tripletNo = objPointer % 13;
            List<TxtTriplet> objectDefinition = SubPage.getObjectDefinition(this, lineNo, tripletNo);
            Utils.addListJTree(s, objectDefinition, modus, "Object Definition");
        }
    }

    private void addDRCSDownloadPageDetailsToJTree(int modus, KVP s) {
        TxtDataField drcsDatafield = null;
        for (TxtDataField txtDatafield : this.packetx_28) {
            if (txtDatafield == null || txtDatafield.getDesignationCode() != 3) continue;
            drcsDatafield = txtDatafield;
        }
        if (drcsDatafield != null) {
            List<Triplet> tripletList = drcsDatafield.getTripletList();
            BitString bs = new BitString();
            for (int i = 2; i <= 11; ++i) {
                bs.addIntBitsReverse(tripletList.get(i - 1).getVal(), 18);
            }
            bs.addIntBitsReverse(tripletList.get(11).getVal() & 0xFFF, 12);
            KVP drcs = new KVP("DRCS Downloading Mode Invocation");
            for (int i = 0; i < 48; ++i) {
                int drcsMode = bs.getIntBitsReverse(4);
                DRCSCharacter drcsChar = new DRCSCharacter(drcsMode, this, i);
                drcs.add(drcsChar.getJTreeNode(modus));
            }
            s.add(drcs);
        }
    }

    private boolean isDRCSDownloadingpage() {
        for (TxtDataField txtDatafield : this.packetx_28) {
            List<Triplet> tripletList;
            Triplet tr1;
            if (txtDatafield == null || txtDatafield.getDesignationCode() != 3 || (tr1 = (tripletList = txtDatafield.getTripletList()).getFirst()).getPageFunction() != 4 && tr1.getPageFunction() != 5) continue;
            return true;
        }
        SubPage motPage = this.getMOTPage();
        if (motPage != null) {
            List<DRCSLink> drcsLinks = motPage.getDRCSLinksLevel25();
            for (DRCSLink link : drcsLinks) {
                if (link.getMagazine() != this.getMagazineNo() || link.getPageNo() != this.getPageNo() || link.getPageNo() == 255) continue;
                return true;
            }
        }
        return false;
    }

    private SubPage getMOTPage() {
        return this.pageHandler.getMOTPage();
    }

    private SubPage getBTTPage() {
        Page p;
        if (this.getMagazine(1) != null && (p = this.getMagazine(1).getPage(240)) != null && !p.getSubPages().isEmpty()) {
            return p.getSubPages().values().iterator().next();
        }
        return null;
    }

    private boolean isObjectDefinitionpage() {
        for (TxtDataField txtDatafield : this.packetx_28) {
            List<Triplet> tripletList;
            Triplet tr1;
            if (txtDatafield == null || txtDatafield.getDesignationCode() != 0 || (tr1 = (tripletList = txtDatafield.getTripletList()).getFirst()).getPageFunction() != 2 && tr1.getPageFunction() != 3) continue;
            return true;
        }
        SubPage motPage = this.getMOTPage();
        if (motPage != null) {
            List<ObjectLink> objectLinks = motPage.getObjectLinksLevel25();
            for (ObjectLink link : objectLinks) {
                if (link.getMagazine() != this.getMagazineNo() || link.getPageNo() != this.getPageNo() || link.getPageNo() == 255) continue;
                return true;
            }
        }
        return false;
    }

    private static List<ObjectLink> getObjectLinks(TxtDataField txtDataField1, TxtDataField txtDataField2) {
        ArrayList<ObjectLink> objects = new ArrayList<ObjectLink>();
        if (txtDataField1 != null) {
            ObjectLink gpop = new ObjectLink(txtDataField1.data_block, 6 + txtDataField1.offset);
            objects.add(gpop);
            for (int i = 1; i < 4; ++i) {
                ObjectLink pop = new ObjectLink(txtDataField1.data_block, 6 + 10 * i + txtDataField1.offset);
                objects.add(pop);
            }
        }
        if (txtDataField2 != null) {
            for (int i = 4; i < 8; ++i) {
                ObjectLink pop = new ObjectLink(txtDataField2.data_block, 6 + 10 * (i - 4) + txtDataField2.offset);
                objects.add(pop);
            }
        }
        return objects;
    }

    private List<ObjectLink> getObjectLinksLevel25() {
        return SubPage.getObjectLinks(this.linesList[19], this.linesList[20]);
    }

    private void addMOTPageDetailsToJTree(int modus, KVP s) {
        int associationPageNo;
        int drcsPageAssociation;
        int objectPageAssociation;
        int k;
        int j;
        int i;
        KVP mot = new KVP("MOT Structure");
        s.add(mot);
        for (i = 1; i <= 8; ++i) {
            if (this.linesList[i] == null) continue;
            for (j = 0; j < 2; ++j) {
                for (k = 0; k <= 9; ++k) {
                    objectPageAssociation = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 20 + k * 2));
                    drcsPageAssociation = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 20 + 1 + k * 2));
                    associationPageNo = 16 * ((i - 1) * 2 + j) + k;
                    SubPage.addPageAssociationsToTree(mot, objectPageAssociation, drcsPageAssociation, associationPageNo);
                }
            }
        }
        for (i = 9; i <= 14; ++i) {
            if (this.linesList[i] == null) continue;
            for (j = 0; j < 3; ++j) {
                for (k = 0; k <= 5; ++k) {
                    if (i >= 14 && j != 0) continue;
                    objectPageAssociation = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 12 + k * 2));
                    drcsPageAssociation = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 12 + 1 + k * 2));
                    associationPageNo = 16 * ((i - 9) * 3 + j) + k + 10;
                    SubPage.addPageAssociationsToTree(mot, objectPageAssociation, drcsPageAssociation, associationPageNo);
                }
            }
        }
        String level = "Level 2.5";
        SubPage.addObjectLinkLine1ToJTree(mot, this.linesList[19], level);
        SubPage.addObjectLinkLine2ToJTree(mot, this.linesList[20], level);
        List<ObjectLink> obs = this.getObjectLinksLevel25();
        Utils.addListJTree(mot, obs, modus, "Objects list");
        SubPage.addDRCSLinkLineToJTree(mot, this.linesList[21], level);
        level = "Level 3.5";
        SubPage.addObjectLinkLine1ToJTree(mot, this.linesList[22], level);
        SubPage.addObjectLinkLine2ToJTree(mot, this.linesList[23], level);
        SubPage.addDRCSLinkLineToJTree(mot, this.linesList[24], level);
    }

    private static void addPageAssociationsToTree(KVP mot, int objectPageAssociation, int drcsPageAssociation, int associationPageNo) {
        Object exp;
        if (objectPageAssociation != 0) {
            exp = (objectPageAssociation & 8) != 0 ? "global objects required" : "no global objects required";
            exp = (String)exp + ", " + (String)((objectPageAssociation & 7) == 0 ? "no public objects required" : "POP link " + (objectPageAssociation & 7));
            mot.add(new KVP("Page " + Utils.toHexString(associationPageNo, 2) + " Object Page Association", objectPageAssociation, (String)exp));
        }
        if (drcsPageAssociation != 0) {
            exp = (drcsPageAssociation & 8) != 0 ? "global DRCS required" : "no global DRCS required";
            exp = (String)exp + ", " + (String)((drcsPageAssociation & 7) == 0 ? "no public DRCS required" : "DRCS link " + (drcsPageAssociation & 7));
            mot.add(new KVP("Page " + Utils.toHexString(associationPageNo, 2) + " DRCS Page Association", drcsPageAssociation, (String)exp));
        }
    }

    private void addMIPPageDetailsToJTree(KVP s) {
        int mipPageNo;
        int upperNibble;
        int lowerNibble;
        int k;
        int j;
        int i;
        KVP mot = new KVP("MIP Structure");
        s.add(mot);
        for (i = 1; i <= 8; ++i) {
            if (this.linesList[i] == null) continue;
            for (j = 0; j <= 1; ++j) {
                for (k = 0; k <= 9; ++k) {
                    lowerNibble = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 20 + k * 2));
                    upperNibble = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 20 + 1 + k * 2));
                    mipPageNo = 16 * ((i - 1) * 2 + j) + k;
                    SubPage.addMIPPageDetailsToTree(mot, lowerNibble, upperNibble, mipPageNo);
                }
            }
        }
        for (i = 9; i <= 14; ++i) {
            if (this.linesList[i] == null) continue;
            for (j = 0; j <= 3; ++j) {
                for (k = 0; k <= 5; ++k) {
                    if (i >= 14 && j != 0) continue;
                    lowerNibble = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 12 + k * 2));
                    upperNibble = Utils.getHammingReverseByte(this.linesList[i].getRawByte(j * 12 + 1 + k * 2));
                    mipPageNo = 16 * ((i - 9) * 3 + j) + k + 10;
                    SubPage.addMIPPageDetailsToTree(mot, lowerNibble, upperNibble, mipPageNo);
                }
            }
        }
    }

    private static void addMIPPageDetailsToTree(KVP mot, int lowerNibble, int upperNibble, int mipPageNo) {
        int pagecode = 16 * upperNibble + lowerNibble;
        if (pagecode != 0) {
            mot.add(new KVP("Page " + Utils.toHexString(mipPageNo, 2), pagecode, SubPage.getMIPPageFunctionString(pagecode)));
        }
    }

    private static void addObjectLinkLine1ToJTree(KVP mot, TxtDataField txtDataField, String level) {
        if (txtDataField != null) {
            ObjectLink gpop = new ObjectLink(txtDataField.data_block, 6 + txtDataField.offset);
            mot.add(gpop.getJTreeNode(level + " GPOP "));
            for (int i = 1; i < 4; ++i) {
                ObjectLink pop = new ObjectLink(txtDataField.data_block, 6 + 10 * i + txtDataField.offset);
                mot.add(pop.getJTreeNode(level + " POP " + i + " "));
            }
        }
    }

    private static void addObjectLinkLine2ToJTree(KVP mot, TxtDataField txtDataField, String level) {
        if (txtDataField != null) {
            for (int i = 4; i < 8; ++i) {
                ObjectLink pop = new ObjectLink(txtDataField.data_block, 6 + 10 * (i - 4) + txtDataField.offset);
                mot.add(pop.getJTreeNode(level + " POP " + i + " "));
            }
        }
    }

    private static void addDRCSLinkLineToJTree(KVP mot, TxtDataField txtDataField, String level) {
        if (txtDataField != null) {
            DRCSLink gpop = new DRCSLink(txtDataField.data_block, 6 + txtDataField.offset);
            mot.add(gpop.getJTreeNode(level + " GDRCS "));
            for (int i = 1; i < 8; ++i) {
                DRCSLink pop = new DRCSLink(txtDataField.data_block, 6 + 4 * i + txtDataField.offset);
                mot.add(pop.getJTreeNode(level + " DRCS " + i + " "));
            }
            int mag1 = Utils.getHammingReverseByte(txtDataField.getRawByte(34));
            int mag2 = Utils.getHammingReverseByte(txtDataField.getRawByte(35));
            KVP noPagesNode = new KVP("Number of Enhancement Pages");
            noPagesNode.add(new KVP("Magazine 3,2,1,8", mag1));
            noPagesNode.add(new KVP("Magazine 7,6,5,4", mag2));
            int objectPages = Utils.getHammingReverseByte(txtDataField.getRawByte(36)) + 16 * Utils.getHammingReverseByte(txtDataField.getRawByte(37));
            int drcsPages = Utils.getHammingReverseByte(txtDataField.getRawByte(38)) + 16 * Utils.getHammingReverseByte(txtDataField.getRawByte(39));
            noPagesNode.add(new KVP("Total number of object pages", objectPages));
            noPagesNode.add(new KVP("Total number of DRCS pages", drcsPages));
            mot.add(noPagesNode);
        }
    }

    private static List<DRCSLink> getDRCSLinks(TxtDataField txtDataField) {
        ArrayList<DRCSLink> res = new ArrayList<DRCSLink>();
        if (txtDataField != null) {
            DRCSLink gpop = new DRCSLink(txtDataField.data_block, 6 + txtDataField.offset);
            res.add(gpop);
            for (int i = 1; i < 8; ++i) {
                DRCSLink pop = new DRCSLink(txtDataField.data_block, 6 + 4 * i + txtDataField.offset);
                res.add(pop);
            }
        }
        return res;
    }

    private List<DRCSLink> getDRCSLinksLevel25() {
        return SubPage.getDRCSLinks(this.linesList[21]);
    }

    public TxtDataField[] getLinesList() {
        return this.linesList;
    }

    public TxtDataField[] getPacketx_26() {
        return this.packetx_26;
    }

    public TxtDataField[] getPacketx_27() {
        return this.packetx_27;
    }

    public TxtDataField[] getPacketx_28() {
        return this.packetx_28;
    }

    public int getSubPageNo() {
        return this.subPageNo;
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(600, 475, 1);
        Graphics2D gd = img.createGraphics();
        gd.setColor(Color.BLACK);
        gd.fillRect(0, 0, 600, 475);
        BufferedImage charImg = new BufferedImage(15, 19, 2);
        Graphics2D charGD = charImg.createGraphics();
        Font font = new Font("Monospaced", 1, 18);
        charGD.setFont(font);
        this.fillLevel1();
        this.processX26Enhancements();
        this.processDefaultObjects();
        List<DRCSCharacter> globalDrcsChars = this.getDRCSChars(false);
        List<DRCSCharacter> localDrcsChars = this.getDRCSChars(true);
        for (int i = 24; i >= 0; --i) {
            for (int j = 0; j < 40; ++j) {
                Image targetChar;
                boolean doubleWidthUsed = false;
                if ((this.effect[i][j] & 0x400) != 0) {
                    targetChar = this.drawDRCSChar(globalDrcsChars, localDrcsChars, i, j);
                } else if ((this.effect[i][j] & 0x800) != 0) {
                    targetChar = this.drawG3Char(i, j);
                } else {
                    this.drawChar(charGD, i, j);
                    targetChar = charImg;
                }
                int h = 19;
                int w = 15;
                if ((this.effect[i][j] & 0x40) != 0) {
                    h = 38;
                } else if ((this.effect[i][j] & 0x80) != 0) {
                    w = 30;
                    doubleWidthUsed = true;
                } else if ((this.effect[i][j] & 0x100) != 0) {
                    h = 38;
                    w = 30;
                    doubleWidthUsed = true;
                }
                gd.drawImage(targetChar, j * 15, i * 19, w, h, null);
                if (!doubleWidthUsed) continue;
                ++j;
                doubleWidthUsed = false;
            }
        }
        return img;
    }

    private void fillLevel1() {
        boolean doubleHeightUsed1 = false;
        for (int row = 0; row < 25; ++row) {
            byte[] rowData;
            if (doubleHeightUsed1) {
                for (int k = 0; k < 40; ++k) {
                    this.txt[row][k] = 32;
                    this.bgColor[row][k] = this.bgColor[row - 1][k];
                }
                doubleHeightUsed1 = false;
                continue;
            }
            if (row == 0) {
                rowData = new byte[40];
                Arrays.fill(rowData, (byte)32);
                System.arraycopy(this.linesList[0].getHeaderDataBytes(), 0, rowData, 8, 32);
            } else if (this.linesList[row] != null) {
                rowData = this.linesList[row].getPageDataBytes();
            } else {
                rowData = new byte[40];
                Arrays.fill(rowData, (byte)32);
            }
            byte bg = 0;
            byte fg = 7;
            int effectFlags = 0;
            int heldMosaicCharacter = 32;
            boolean useSecondaryG0set = false;
            for (int column = 0; column < rowData.length; ++column) {
                int targetChar1;
                this.fgColor[row][column] = fg;
                this.bgColor[row][column] = bg;
                this.effect[row][column] = effectFlags;
                byte ch = rowData[column];
                if (ch >= 32) {
                    int nocs = this.getNationalOptionCharSubset(useSecondaryG0set);
                    if ((effectFlags & 2) == 0) {
                        targetChar1 = TxtTriplet.getNationalOptionChar(ch, nocs);
                    } else {
                        targetChar1 = ch;
                        if ((ch & 0x20) != 0) {
                            heldMosaicCharacter = (char)ch;
                        }
                    }
                } else if (ch >= 0 && ch <= 7) {
                    fg = ch;
                    effectFlags = effectFlags & 0xFFFFFFFD & 0xFFFFFFFE;
                    heldMosaicCharacter = 32;
                    targetChar1 = 32;
                } else if (ch == 8) {
                    targetChar1 = SubPage.holdMosaicActive(effectFlags |= 0x10) ? heldMosaicCharacter : 32;
                } else if (ch == 9) {
                    targetChar1 = SubPage.holdMosaicActive(effectFlags &= 0xFFFFFFEF) ? heldMosaicCharacter : 32;
                } else if (ch == 10) {
                    targetChar1 = SubPage.holdMosaicActive(effectFlags &= 0xFFFFFFDF) ? heldMosaicCharacter : 32;
                } else if (ch == 11) {
                    targetChar1 = SubPage.holdMosaicActive(effectFlags |= 0x20) ? heldMosaicCharacter : 32;
                } else if (ch == 12) {
                    oldEffectFlags = effectFlags;
                    if (oldEffectFlags != (effectFlags &= 0xFFFFFE3F)) {
                        heldMosaicCharacter = 32;
                    }
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                } else if (ch == 13) {
                    oldEffectFlags = effectFlags;
                    effectFlags |= 0x40;
                    if (oldEffectFlags != (effectFlags &= 0xFFFFFE7F)) {
                        heldMosaicCharacter = 32;
                    }
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                    doubleHeightUsed1 = true;
                } else if (ch == 14) {
                    effectFlags |= 0x80;
                    effectFlags &= 0xFFFFFEBF;
                    targetChar1 = 32;
                    heldMosaicCharacter = 32;
                } else if (ch == 15) {
                    effectFlags |= 0x100;
                    effectFlags &= 0xFFFFFF3F;
                    targetChar1 = 32;
                    heldMosaicCharacter = 32;
                    doubleHeightUsed1 = true;
                } else if (ch >= 16 && ch <= 23) {
                    fg = ch - 16;
                    effectFlags |= 2;
                    targetChar1 = SubPage.holdMosaicActive(effectFlags &= 0xFFFFFFFE) ? heldMosaicCharacter : 32;
                } else if (ch == 24) {
                    this.effect[row][column] = effectFlags |= 1;
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                } else if (ch == 25) {
                    this.effect[row][column] = effectFlags &= 0xFFFFFFFB;
                    targetChar1 = 32;
                } else if (ch == 26) {
                    this.effect[row][column] = effectFlags |= 4;
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                } else if (ch == 27) {
                    useSecondaryG0set = !useSecondaryG0set;
                    targetChar1 = 32;
                } else if (ch == 28) {
                    this.bgColor[row][column] = bg = 0;
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                } else if (ch == 29) {
                    this.bgColor[row][column] = bg = fg;
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                } else if (ch == 30) {
                    this.effect[row][column] = effectFlags |= 0x200;
                    targetChar1 = heldMosaicCharacter;
                } else if (ch == 31) {
                    targetChar1 = SubPage.holdMosaicActive(effectFlags) ? heldMosaicCharacter : 32;
                    effectFlags &= 0xFFFFFDFF;
                } else {
                    logger.warning("Teletext: found not implemented character:" + ch + " at magazine:" + this.pageHandler.getMagazineNo() + ",page:" + this.pageHandler.getPageNo() + ",subpage:" + this.subPageNo + ",row:" + row + ", column:" + column);
                    targetChar1 = 32;
                }
                this.txt[row][column] = targetChar1;
            }
        }
    }

    private Image drawG3Char(int i, int j) {
        BufferedImage b = new BufferedImage(12, 10, 12);
        Graphics2D gd = b.createGraphics();
        int bgC = this.getColorInt(this.bgColor[i][j]);
        int fgC = this.getColorInt(this.fgColor[i][j]);
        IndexColorModel blackAndWhite = new IndexColorModel(1, 2, new int[]{fgC, bgC}, 0, false, -1, 0);
        gd.drawImage(g3CharsImage, 0, 0, 12, 10, (this.txt[i][j] - 32) * 12, 0, (this.txt[i][j] - 31) * 12, 10, null);
        DataBuffer buf = b.getData().getDataBuffer();
        WritableRaster wr = Raster.createPackedRaster(buf, 12, 10, 1, null);
        BufferedImage target = new BufferedImage(blackAndWhite, wr, true, null);
        return target;
    }

    private Image drawDRCSChar(List<DRCSCharacter> globalDrcsChars, List<DRCSCharacter> localDdrcsChars, int i, int j) {
        int bgC = this.getColorInt(this.bgColor[i][j]);
        int fgC = this.getColorInt(this.fgColor[i][j]);
        IndexColorModel blackAndWhite = new IndexColorModel(1, 2, new int[]{bgC, fgC}, 0, false, -1, 0);
        BufferedImage target = this.txt[i][j] < '0' ? new BufferedImage(blackAndWhite, globalDrcsChars.get(this.txt[i][j]).getWritableRaster(), true, null) : new BufferedImage(blackAndWhite, localDdrcsChars.get(this.txt[i][j] - 64).getWritableRaster(), true, null);
        return target;
    }

    private List<DRCSCharacter> getDRCSChars(boolean local) {
        SubPage mot = this.getMOTPage();
        if (null != mot) {
            int pageNo = this.pageHandler.getPageNo();
            int association = mot.getDRCSPageAssociation(pageNo);
            if (association == 0) {
                return null;
            }
            List<DRCSLink> drcsLinks = mot.getDRCSLinksLevel25();
            DRCSLink drcsLink = local ? drcsLinks.get(association % 8) : drcsLinks.getFirst();
            int drcsPageNo = drcsLink.getPageNo();
            int drcsMagazine = drcsLink.getMagazine();
            Page drcsDefPage = this.getMagazine(drcsMagazine).getPage(drcsPageNo);
            SubPage drcsDefSubPage = drcsDefPage.getSubPages().values().iterator().next();
            TxtDataField drcsDatafield = null;
            for (TxtDataField txtDatafield : drcsDefSubPage.packetx_28) {
                if (txtDatafield == null || txtDatafield.getDesignationCode() != 3) continue;
                drcsDatafield = txtDatafield;
            }
            if (drcsDatafield != null) {
                return SubPage.getDrcsCharacters(drcsDatafield, drcsDefSubPage);
            }
        }
        return null;
    }

    private static List<DRCSCharacter> getDrcsCharacters(TxtDataField drcsDatafield, SubPage drcsDefSubPage) {
        List<Triplet> tripletList = drcsDatafield.getTripletList();
        BitString bs = new BitString();
        for (int i = 2; i <= 11; ++i) {
            bs.addIntBitsReverse(tripletList.get(i - 1).getVal(), 18);
        }
        bs.addIntBitsReverse(tripletList.get(11).getVal() & 0xFFF, 12);
        ArrayList<DRCSCharacter> drcsChars = new ArrayList<DRCSCharacter>();
        for (int i = 0; i < 48; ++i) {
            int drcsMode = bs.getIntBitsReverse(4);
            DRCSCharacter drcsChar = new DRCSCharacter(drcsMode, drcsDefSubPage, i);
            drcsChars.add(drcsChar);
        }
        return drcsChars;
    }

    private void processDefaultObjects() {
        SubPage mot = this.getMOTPage();
        if (mot != null) {
            ObjectLink objectLink;
            int pageNo = this.pageHandler.getPageNo();
            int association = mot.getObjectPageAssociation(pageNo);
            if (association == 0) {
                return;
            }
            List<ObjectLink> objectLinks = mot.getObjectLinksLevel25();
            if (association >= 8) {
                objectLink = objectLinks.getFirst();
                this.processDefaultObjectsLink(objectLink);
            }
            if ((association & 7) != 0) {
                objectLink = objectLinks.get(association & 7);
                this.processDefaultObjectsLink(objectLink);
            }
        }
    }

    private void processDefaultObjectsLink(ObjectLink objectLink) {
        int ptrPosition;
        int tripletOffset;
        int ptrLocation;
        SubPage objectDefSubPage;
        int subPageS1;
        Page objectDefPage;
        int objectPageNo = objectLink.getPageNo();
        int magazine = objectLink.getMagazine();
        if (objectLink.getDefaultObject1Type() != 0) {
            int object1type = objectLink.getDefaultObject1Type();
            objectDefPage = this.getMagazine(magazine).getPage(objectPageNo);
            subPageS1 = objectLink.getDefaultObject1SubPageS1();
            objectDefSubPage = objectDefPage.getSubPageByS1(subPageS1);
            ptrLocation = objectLink.getDefaultObject1PointerLocation();
            tripletOffset = objectLink.getDefaultObject1TripletNoOffset();
            ptrPosition = objectLink.getDefaultObject1PointerPosition();
            this.findProcessObjectDefinition(objectDefSubPage, object1type, ptrLocation, tripletOffset, ptrPosition, 0, 0, 0, 0);
        }
        if (objectLink.getDefaultObject2Type() != 0) {
            int object2type = objectLink.getDefaultObject2Type();
            objectDefPage = this.getMagazine(magazine).getPage(objectPageNo);
            subPageS1 = objectLink.getDefaultObject2SubPageS1();
            objectDefSubPage = objectDefPage.getSubPageByS1(subPageS1);
            ptrLocation = objectLink.getDefaultObject2PointerLocation();
            tripletOffset = objectLink.getDefaultObject2TripletNoOffset();
            ptrPosition = objectLink.getDefaultObject2PointerPosition();
            this.findProcessObjectDefinition(objectDefSubPage, object2type, ptrLocation, tripletOffset, ptrPosition, 0, 0, 0, 0);
        }
    }

    private void findProcessObjectDefinition(SubPage objectDefSubPage, int objectType, int ptrLocation, int tripletOffset, int ptrPosition, int actRow, int actCol, int rowOffset, int colOffset) {
        int functionByte;
        PageLine txtDataField = objectDefSubPage.linesList[1 + ptrLocation];
        if (txtDataField != null && ((functionByte = Utils.getHammingReverseByte(txtDataField.getRawByte(0))) & 1) != 0) {
            List<Triplet> tripletList = txtDataField.getTripletList();
            Triplet tr1 = tripletList.get(objectType + tripletOffset * 3);
            int tripletStart = ptrPosition == 0 ? tr1.getVal() & 0x1FF : (tr1.getVal() & 0x3FE00) >> 9;
            if (tripletStart != 511) {
                int lineNo = 3 + tripletStart / 13;
                int tripletNo = tripletStart % 13;
                List<TxtTriplet> objectDefinition = SubPage.getObjectDefinition(objectDefSubPage, lineNo, tripletNo);
                this.processTripletList(objectDefinition, objectType, actRow, actCol, rowOffset, colOffset);
            }
        }
    }

    private static List<TxtTriplet> getObjectDefinition(SubPage objectDefSubPage, int lineNo, int tripletOffset) {
        int lineNumber = lineNo;
        int offset = tripletOffset;
        ArrayList<TxtTriplet> objectDefinition = new ArrayList<TxtTriplet>();
        TxtDataField line = objectDefSubPage.getLine(lineNumber);
        if (line != null) {
            List<TxtTriplet> lineTriplets = line.getTxtTripletList();
            TxtTriplet triplet = lineTriplets.get(offset++);
            do {
                objectDefinition.add(triplet);
                if (offset != 13) continue;
                offset = 0;
                if ((line = objectDefSubPage.getLine(++lineNumber)) == null) continue;
                lineTriplets = line.getTxtTripletList();
            } while ((triplet = lineTriplets.get(offset++)) != null && !triplet.isTerminationMarker() && !triplet.isObjectDefinition() && line != null);
        }
        return objectDefinition;
    }

    private TxtDataField getLine(int lineNo) {
        if (lineNo <= 25) {
            return this.linesList[lineNo];
        }
        if (lineNo < 41) {
            return this.packetx_26[lineNo - 26];
        }
        return null;
    }

    private int getObjectPageAssociation(int pageNo) {
        int col;
        int row;
        int objectPageAssociation = 0;
        int pageNoUnits = pageNo & 0xF;
        int pageNoTens = (pageNo & 0xF0) >> 4;
        if (pageNoUnits < 10) {
            row = 1 + pageNoTens / 2;
            col = 2 * pageNoUnits + pageNoTens % 2 * 20;
        } else {
            row = 9 + pageNoTens / 3;
            col = 2 * (pageNoUnits - 10) + pageNoTens % 3 * 12;
        }
        if (this.linesList[row] != null) {
            objectPageAssociation = Utils.getHammingReverseByte(this.linesList[row].getRawByte(col));
        }
        return objectPageAssociation;
    }

    private int getDRCSPageAssociation(int pageNo) {
        int col;
        int row;
        int drcsPageAssociation = 0;
        if ((pageNo & 0xF) < 10) {
            row = 1 + ((pageNo & 0xF0) >> 4) / 2;
            col = 1 + 2 * (pageNo & 0xF);
        } else {
            row = 10 + ((pageNo & 0xF0) >> 4) / 3;
            col = 1 + 3 * ((pageNo & 0xF) - 10);
        }
        if (this.linesList[row] != null) {
            drcsPageAssociation = Utils.getHammingReverseByte(this.linesList[row].getRawByte(col));
        }
        return drcsPageAssociation;
    }

    private void drawChar(Graphics2D charGD, int i, int j) {
        FontMetrics metrics = charGD.getFontMetrics();
        int descent = metrics.getDescent();
        charGD.setColor(new Color(this.getColorInt(this.bgColor[i][j])));
        charGD.fillRect(0, 0, 15, 19);
        charGD.setColor(new Color(this.getColorInt(this.fgColor[i][j])));
        char ch = this.txt[i][j];
        int characterEffect = this.effect[i][j];
        if (SubPage.isMosaicGraphicsMode(characterEffect) && SubPage.isValidMosaicCharacter(ch)) {
            int blockH = 6;
            int blockW = 7;
            if ((ch & '\u0001') != 0) {
                charGD.fillRect(0, 0, 7, 6);
            }
            if ((ch & 2) != 0) {
                charGD.fillRect(7, 0, 8, 6);
            }
            if ((ch & 4) != 0) {
                charGD.fillRect(0, 6, 7, 6);
            }
            if ((ch & 8) != 0) {
                charGD.fillRect(7, 6, 8, 6);
            }
            if ((ch & 0x10) != 0) {
                charGD.fillRect(0, 12, 7, 7);
            }
            if ((ch & 0x40) != 0) {
                charGD.fillRect(7, 12, 8, 7);
            }
            if ((characterEffect & 4) != 0) {
                charGD.setColor(new Color(this.getColorInt(this.bgColor[i][j])));
                charGD.drawRect(0, 0, 15, 19);
                charGD.drawLine(0, 6, 14, 6);
                charGD.drawLine(0, 12, 14, 12);
                charGD.drawLine(7, 0, 7, 18);
            }
        } else {
            charGD.drawChars(this.txt[i], j, 1, 1, 19 - descent);
        }
    }

    private static boolean isValidMosaicCharacter(int ch) {
        return ch < 64 || ch >= 96 && ch <= 127;
    }

    private static boolean isMosaicGraphicsMode(int ef) {
        return (ef & 2) != 0;
    }

    private int getColorInt(int i) {
        TxtDataField line;
        Magazine mag;
        if (i > 15) {
            if (this.packetx_28[0] != null) {
                return this.packetx_28[0].getColor(i);
            }
            mag = this.pageHandler.getMagazine();
            line = mag.getPageEnhanceMentDataPackes(0);
            if (line != null) {
                return line.getColor(i);
            }
        }
        if (i == 0) {
            if (this.packetx_28[0] != null) {
                TxtDataField line2 = this.packetx_28[0];
                if (line2.getPageFunction() == 0 && line2.isBlackBackGroundColorSubstitution()) {
                    return line2.getColor(line2.getDefaultRowColour());
                }
            } else {
                mag = this.pageHandler.getMagazine();
                line = mag.getPageEnhanceMentDataPackes(0);
                if (line != null && line.getPageFunction() == 0 && line.isBlackBackGroundColorSubstitution()) {
                    return line.getColor(line.getDefaultRowColour());
                }
            }
        }
        return TxtDataField.getColorInt(i);
    }

    private void processX26Enhancements() {
        ArrayList<TxtTriplet> tripletList = new ArrayList<TxtTriplet>();
        for (TxtDataField x26 : this.packetx_26) {
            if (x26 == null || x26.getTxtTripletList() == null) continue;
            tripletList.addAll(x26.getTxtTripletList());
        }
        this.processTripletList(tripletList, 0, 0, 0, 0, 0);
    }

    private void processTripletList(List<TxtTriplet> tripletList, int objectType, int row, int col, int rowOffset, int colOffset) {
        int originModifierRowOffset = 0;
        int originModifierColOffset = 0;
        int actRow = row + rowOffset;
        int actCol = col + colOffset;
        int bgCol = 0;
        int fgCol = 7;
        int effct = -1;
        if (tripletList != null) {
            block10: for (TxtTriplet triplet : tripletList) {
                int i;
                int address = triplet.getAddress();
                int mode = triplet.getMode();
                int data = triplet.getData();
                if (address >= 40) {
                    if (mode == 4) {
                        actRow = rowOffset + (address == 40 ? 24 : address - 40);
                        actCol = colOffset + data;
                        if (objectType != 2) continue;
                        fgCol = -1;
                        bgCol = -1;
                        effct = -1;
                        continue;
                    }
                    if (mode == 16) {
                        originModifierRowOffset = address - 40;
                        originModifierColOffset = data;
                        continue;
                    }
                    if (mode >= 17 && mode <= 19) {
                        SubPage mot;
                        int objectSource = (address & 0x18) >> 3;
                        int calledObjectType = mode & 3;
                        int subPageS1 = data & 0xF;
                        if (objectSource != 3 && objectSource != 2 || (mot = this.getMOTPage()) == null) continue;
                        int pageNo = this.pageHandler.getPageNo();
                        int association = mot.getObjectPageAssociation(pageNo);
                        if (association == 0) {
                            return;
                        }
                        List<ObjectLink> objectLinks = mot.getObjectLinksLevel25();
                        ObjectLink objectLink = objectSource == 3 ? objectLinks.getFirst() : objectLinks.get(association);
                        int objectPageNo = objectLink.getPageNo();
                        int magazine = objectLink.getMagazine();
                        Page objectDefPage = this.pageHandler.getMagazine(magazine).getPage(objectPageNo);
                        SubPage objectDefSubPage = objectDefPage.getSubPageByS1(subPageS1);
                        int ptrLocation = address & 3;
                        int tripletOffset = (data & 0x60) >> 5;
                        int ptrPosition = (data & 0x10) >> 4;
                        this.findProcessObjectDefinition(objectDefSubPage, calledObjectType, ptrLocation, tripletOffset, ptrPosition, actRow, actCol, originModifierRowOffset, originModifierColOffset);
                        originModifierRowOffset = 0;
                        originModifierColOffset = 0;
                        continue;
                    }
                    if (mode >= 21 && mode <= 23) {
                        if ((mode & 3) == objectType) continue;
                        logger.log(Level.INFO, "Object definition type :" + (mode & 3) + " does not match called expected type " + objectType);
                        continue;
                    }
                    if (mode == 31) break;
                    logger.log(Level.FINE, "not implemented triplet:" + String.valueOf(triplet));
                    continue;
                }
                if (objectType == 2) {
                    for (i = actCol; i <= colOffset + address; ++i) {
                        if (fgCol != -1) {
                            this.fgColor[actRow][i] = fgCol;
                        }
                        if (bgCol != -1) {
                            this.bgColor[actRow][i] = bgCol;
                        }
                        if (effct == -1) continue;
                        this.setEffect(this.effect[actRow][i], effct);
                    }
                }
                actCol = colOffset + address;
                if (mode == 0) {
                    if (data >= 32) continue;
                    switch (objectType) {
                        case 1: {
                            this.fgColor[actRow][actCol] = data;
                            for (i = actCol + 1; i < 40 && this.getPageDataByte(actRow, i) > 7 && (this.getPageDataByte(actRow, i) < 16 || this.getPageDataByte(actRow, i) > 23); ++i) {
                                this.fgColor[actRow][i] = data;
                            }
                            continue block10;
                        }
                        case 2: {
                            fgCol = data;
                            this.fgColor[actRow][actCol] = data;
                            break;
                        }
                        case 3: {
                            fgCol = data;
                        }
                    }
                    continue;
                }
                if (mode == 1) {
                    this.txt[actRow][actCol] = (char)data;
                    int[] nArray = this.effect[actRow];
                    int n = actCol;
                    nArray[n] = nArray[n] | 2;
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode == 3) {
                    if (data >= 32) continue;
                    switch (objectType) {
                        case 1: {
                            this.bgColor[actRow][actCol] = data;
                            for (i = actCol + 1; i < 40 && this.getPageDataByte(actRow, i) != 28 && this.getPageDataByte(actRow, i) != 29; ++i) {
                                this.bgColor[actRow][i] = data;
                            }
                            continue block10;
                        }
                        case 2: {
                            bgCol = data;
                            this.bgColor[actRow][actCol] = data;
                            break;
                        }
                        case 3: {
                            bgCol = data;
                        }
                    }
                    continue;
                }
                if (mode == 9) {
                    this.txt[actRow][actCol] = (char)TxtTriplet.G0_sets[0][data];
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode == 11) {
                    this.txt[actRow][actCol] = (char)data;
                    int[] nArray = this.effect[actRow];
                    int n = actCol;
                    nArray[n] = nArray[n] | 0x800;
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode == 13) {
                    this.txt[actRow][actCol] = (char)data;
                    int[] nArray = this.effect[actRow];
                    int n = actCol;
                    nArray[n] = nArray[n] | 0x400;
                    int[] nArray2 = this.effect[actRow];
                    int n2 = actCol;
                    nArray2[n2] = nArray2[n2] & 0xFFFFFE3F;
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode == 15) {
                    this.txt[actRow][actCol] = (char)TxtTriplet.G2_sets[0][data];
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode == 16) {
                    this.txt[actRow][actCol] = (char)TxtTriplet.G0_sets[0][data];
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                if (mode > 16) {
                    this.txt[actRow][actCol] = (char)TxtTriplet.getCombinedCharacter(data, mode & 0xF);
                    if (objectType != 3) continue;
                    this.fgColor[actRow][actCol] = fgCol;
                    this.bgColor[actRow][actCol] = bgCol;
                    continue;
                }
                logger.log(Level.FINE, "not implemented triplet:" + String.valueOf(triplet));
            }
        }
    }

    private void setEffect(int i, int effct) {
    }

    private byte getPageDataByte(int actRow, int i) {
        if (this.linesList[actRow] != null) {
            return this.linesList[actRow].getPageDataByte(i);
        }
        return 32;
    }

    private static boolean holdMosaicActive(int effectFlags) {
        return (effectFlags & 0x200) != 0;
    }

    private boolean isMOTpage() {
        return this.getPageNo() == 254;
    }

    public String toString() {
        return "Mag:" + this.pageHandler.getMagazineNo() + ", pageNo" + this.pageHandler.getPageNo() + ". sub:" + this.subPageNo;
    }

    private boolean isBTTpage() {
        return this.getPageNo() == 240 && this.getMagazineNo() == 1;
    }

    private boolean isAITpage() {
        return this.isTOPpage(2);
    }

    private boolean isMPTpage() {
        return this.isTOPpage(1);
    }

    private boolean isTOPpage(int type) {
        SubPage btt = this.getBTTPage();
        if (btt != null) {
            for (int i = 21; i < 23; ++i) {
                TxtDataField txtDataField = btt.getLine(i);
                if (txtDataField == null) continue;
                for (int j = 0; j < 5; ++j) {
                    int magNo = Utils.getHammingReverseByte(txtDataField.getRawByte(j * 8));
                    int pagNo = Utils.getHammingReverseByte(txtDataField.getRawByte(j * 8 + 1)) * 16 + Utils.getHammingReverseByte(txtDataField.getRawByte(j * 8 + 2));
                    int t = Utils.getHammingReverseByte(txtDataField.getRawByte(j * 8 + 7));
                    if (t != type || pagNo != this.getPageNo() || magNo != this.getMagazineNo()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Magazine getMagazine() {
        return this.pageHandler.getMagazine();
    }

    public Magazine getMagazine(int m) {
        return this.pageHandler.getMagazine(m);
    }

    public int getMagazineNo() {
        return this.pageHandler.getMagazineNo();
    }

    public int getPageNo() {
        return this.pageHandler.getPageNo();
    }

    @Override
    public void save(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.saveSubPage(out);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "could not write file", e);
        }
    }

    public void saveSubPage(FileOutputStream out) throws IOException {
        SubPage.saveLineArray(out, this.getMagazine().getPageEnhanceMentDataPackes());
        SubPage.saveLineArray(out, this.linesList);
        SubPage.saveLineArray(out, this.packetx_26);
        SubPage.saveLineArray(out, this.packetx_27);
        SubPage.saveLineArray(out, this.packetx_28);
    }

    public static void saveLineArray(FileOutputStream out, EBUDataField[] linesList) throws IOException {
        for (EBUDataField line : linesList) {
            EBUTeletextHandler.saveLineT42(out, line);
        }
    }

    static {
        try (InputStream fileInputStream = classLoader.getResourceAsStream("g3_charset.gif");){
            g3CharsImage = ImageIO.read(fileInputStream);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "error reading image g3_charset.gif:", e);
        }
    }
}

