/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUPESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Triplet;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtTriplet;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.VPSDataField;
import nl.digitalekabeltelevisie.util.BitString;
import nl.digitalekabeltelevisie.util.Utils;

public class TxtDataField
extends EBUDataField {
    public TxtDataField(byte[] data, int offset, int len, long pts) {
        super(data, offset, len, pts);
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = new KVP(EBUPESDataField.getDataUnitIdString(this.dataUnitId));
        this.addDetailsToJTree(s);
        this.addDetailsToJTree(s, modus);
        if (this.getPacketNo() >= 0 && this.getPacketNo() <= 25) {
            s.add(new KVP(this.getTeletextPlain()).setHtmlLabel(this.getTeletextHTML()));
        }
        return s;
    }

    protected void addDetailsToJTree(KVP s, int modus) {
        s.add(new KVP("framing_code", Utils.getInt(this.data_block, this.offset + 3, 1, 255)));
        s.add(new KVP("magazine_and_packet_address", Utils.getInt(this.data_block, 4 + this.offset, 2, 65535), "Magazine:" + this.getMagazineNo() + " Packet:" + this.getPacketNo()));
        s.add(new KVP("raw data", this.data_block, this.offset, 46));
        if (this.getPacketNo() == 0) {
            s.add(new KVP("page number", Utils.toHexString((long)this.getPageNumberTens() * 16L + (long)this.getPageNumberUnits(), 2)));
            s.add(new KVP("sub page", Utils.toHexString(this.getSubPage(), 4)));
            s.add(new KVP("data bytes", this.getHeaderDataBytes()));
            StringJoiner flags = new StringJoiner(",");
            if (this.isErasePage()) {
                flags.add("Erase Page");
            }
            if (this.isNewsFlash()) {
                flags.add("Newsflash");
            }
            if (this.isSubtitle()) {
                flags.add("Subtitle");
            }
            if (this.isSuppresHeader()) {
                flags.add("Suppress Header");
            }
            if (this.isUpdateIndicator()) {
                flags.add("Update Indicator");
            }
            if (this.isInterruptedSequence()) {
                flags.add("Interrupted Sequence");
            }
            if (this.isInhibitDisplay()) {
                flags.add("Inhibit Display");
            }
            if (this.isMagazineSerial()) {
                flags.add("Magazine Serial");
            }
            s.add(new KVP("flags", flags.toString()));
            int normalOrderNOS = Utils.invNationalOptionSet[this.getNationalOptionCharacterSubset()];
            s.add(new KVP("National Option Character Subset", normalOrderNOS, "C12 C13 C14: " + Utils.toBinaryString(normalOrderNOS, 3)));
        } else if (this.getPacketNo() > 0 && this.getPacketNo() <= 25) {
            s.add(new KVP("data bytes", this.getPageDataBytes()));
        }
        if (this.getPacketNo() >= 26 && this.getPacketNo() <= 31) {
            s.add(new KVP("Designation Code", this.getDesignationCode()));
        }
        if (this.getPacketNo() == 26) {
            List<TxtTriplet> tripletList = this.getTxtTripletList();
            Utils.addListJTree(s, tripletList, modus, "triplet_list");
        }
        if (this.getPacketNo() == 28 || this.getPacketNo() == 29) {
            this.addPacketX28Format1Details(s, modus);
        }
        if (this.getPacketNo() == 27 && this.getDesignationCode() >= 0 && this.getDesignationCode() <= 3) {
            KVP linkControl = new KVP("Editorial Linking");
            s.add(linkControl);
            for (int t = 0; t < 6; ++t) {
                int pageNumber = this.getPageNumber(7 + t * 6);
                int subPage = this.getSubPage(9 + t * 6);
                int m = this.getMagazineComplement(10 + 6 * t) ^ this.getMagazineNo();
                String formattedPageNo = TxtDataField.formatPageNo(m, pageNumber, subPage);
                KVP link = new KVP("Link " + t + ": " + formattedPageNo);
                linkControl.add(link);
                link.add(new KVP("pageNumber", pageNumber));
                link.add(new KVP("sub page", subPage));
                link.add(new KVP("magazine modified", m));
            }
            if (this.getPacketNo() == 27) {
                int linkControlByte = Utils.getHammingByte(this.data_block[43 + this.offset]);
                s.add(new KVP("Link Control Byte", linkControlByte));
            }
        }
        if (this.getPacketNo() >= 30 && this.getPacketNo() <= 31) {
            s.add(new KVP("Data Channel", this.getDataChannel(), TxtDataField.getDataChannelString(this.getDataChannel())));
        }
        if (this.getMagazineNo() == 0 && this.getPacketNo() == 30 && this.getDesignationCode() >= 0 && this.getDesignationCode() <= 1) {
            this.addInititalPagePacket8_30ToJTree(s);
            this.addChannelDataLine30(s);
            s.add(new KVP("Status Display", this.getDataBytes(26, 46)));
        }
        if (this.getMagazineNo() == 0 && this.getPacketNo() == 30 && this.getDesignationCode() >= 2 && this.getDesignationCode() <= 3) {
            this.addInititalPagePacket8_30ToJTree(s);
            this.addPDCDetails(s);
            s.add(new KVP("Status Display", this.getDataBytes(26, 46)));
        }
    }

    public List<TxtTriplet> getTxtTripletList() {
        ArrayList<TxtTriplet> tripletList = new ArrayList<TxtTriplet>();
        for (int i = 1; i <= 13; ++i) {
            TxtTriplet tr = new TxtTriplet(this.data_block, this.offset + 4 + i * 3);
            tripletList.add(tr);
        }
        return tripletList;
    }

    private void addPacketX28Format1Details(KVP s, int modus) {
        List<Triplet> tripletList = this.getTripletList();
        Utils.addListJTree(s, tripletList, modus, "triplet_list");
        Triplet tr1 = tripletList.getFirst();
        int pageFunction = tr1.getPageFunction();
        int pageCoding = (tr1.getVal() & 0x70) >> 4;
        s.add(new KVP("pageFunction", pageFunction, TxtDataField.getPageFunctionString(pageFunction)));
        s.add(new KVP("pageCoding", pageCoding, TxtDataField.getPageCodingString(pageCoding)));
        if (pageFunction == 0) {
            int defaultCharset = (tr1.getVal() & 0x3F80) >> 7;
            int bits14_11 = (defaultCharset & 0x78) >> 3;
            int bits10_8 = defaultCharset & 7;
            s.add(new KVP("Default G0 and G2 Character Set Designation and National Option Selection", defaultCharset, "bits 14 13 12 11: " + Utils.toBinaryString(bits14_11, 4) + " bits 10 9 8: " + Utils.toBinaryString(bits10_8, 3)));
            Triplet tr2 = tripletList.get(1);
            int secondCharset = (tr1.getVal() & 0x3C000) >> 14 | (tr2.getVal() & 7) << 4;
            s.add(new KVP("Second G0 Set Designation and National Option Selection", secondCharset));
            int leftSidePanel = (tr2.getVal() & 8) >> 3;
            int rightSidePanel = (tr2.getVal() & 0x10) >> 4;
            int sidePanelStatusFlag = (tr2.getVal() & 0x20) >> 5;
            int numberOfColumnsInSidePanels = (tr2.getVal() & 0x3C0) >> 6;
            s.add(new KVP("Left Side Panel", leftSidePanel, leftSidePanel == 0 ? "No left side panel is to be displayed" : "Left side panel is to be displayed"));
            s.add(new KVP("Right Side Panel", rightSidePanel, rightSidePanel == 0 ? "No right side panel is to be displayed" : "Right side panel is to be displayed"));
            s.add(new KVP("Side Panel Status Flag", sidePanelStatusFlag, sidePanelStatusFlag == 0 ? "Side panel(s) required at Level 3.5 only" : "Side panel(s) required at Levels 2.5 & 3.5"));
            s.add(new KVP("Number of Columns in Side Panels", numberOfColumnsInSidePanels));
            BitString bs = new BitString();
            bs.addIntBitsReverse(tr2.getVal() & 0xFF, 8);
            for (int i = 3; i <= 12; ++i) {
                bs.addIntBitsReverse(tripletList.get(i - 1).getVal(), 18);
            }
            bs.addIntBitsReverse(tripletList.get(12).getVal() & 0xF, 4);
            KVP clut23 = new KVP("Colour Map Entry Coding for CLUTs 2 and 3");
            for (int i = 16; i <= 31; ++i) {
                int r = bs.getIntBitsReverse(4);
                int g = bs.getIntBitsReverse(4);
                int b = bs.getIntBitsReverse(4);
                int r_byte = r * 255 / 15;
                int g_byte = g * 255 / 15;
                int b_byte = b * 255 / 15;
                String bgColor = "#" + Utils.toHexStringUnformatted(r_byte, 2) + Utils.toHexStringUnformatted(g_byte, 2) + Utils.toHexStringUnformatted(b_byte, 2);
                KVP cmapEntry = new KVP("Colour Map entry " + i).setHtmlLabel("Colour Map entry " + i + " <code><span style=\"background-color: " + bgColor + "; color: white;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></code>");
                cmapEntry.add(new KVP("R", r));
                cmapEntry.add(new KVP("G", g));
                cmapEntry.add(new KVP("B", b));
                clut23.add(cmapEntry);
            }
            s.add(clut23);
            Triplet tr13 = tripletList.get(12);
            int defaultScreenColour = (tr13.getVal() & 0x1F0) >> 4;
            int defaultRowColour = (tr13.getVal() & 0x3E00) >> 9;
            int blackBackgroundColourSubstitution = (tr13.getVal() & 0x4000) >> 14;
            int colourTableRemapping = (tr13.getVal() & 0x38000) >> 15;
            s.add(new KVP("Default Screen Colour", defaultScreenColour));
            s.add(new KVP("Default Row Colour", defaultRowColour));
            s.add(new KVP("Black Background Colour Substitution", blackBackgroundColourSubstitution, blackBackgroundColourSubstitution == 1 ? "black background is replaced by the full row colour applying to that row" : "No substitution of black background by the pertaining row colour"));
            s.add(new KVP("Colour Table Re-mapping for use with Spacing Attributes", colourTableRemapping));
        }
    }

    protected List<Triplet> getTripletList() {
        ArrayList<Triplet> tripletList = new ArrayList<Triplet>();
        for (int i = 1; i <= 13; ++i) {
            Triplet tr = new Triplet(this.data_block, this.offset + 4 + i * 3);
            tripletList.add(tr);
        }
        return tripletList;
    }

    public static String getPageFunctionString(int pageFunction) {
        return switch (pageFunction) {
            case 0 -> "Basic Level 1 Teletext page (LOP)";
            case 1 -> "Data broadcasting page coded according to EN 300 708";
            case 2 -> "Global Object definition page (GPOP)";
            case 3 -> "Normal Object definition page (POP)";
            case 4 -> "Global DRCS downloading page (GDRCS)";
            case 5 -> "Normal DRCS downloading page (DRCS)";
            case 6 -> "Magazine Organization table (MOT)";
            case 7 -> "Magazine Inventory page (MIP)";
            case 8 -> "Basic TOP table (BTT)";
            case 9 -> "Additional Information Table (AIT)";
            case 10 -> "Multi-page table (MPT)";
            case 11 -> "Multi-page extension table (MPT-EX)";
            case 12 -> "Page contain trigger messages defined according to IEC/PAS 62297 Edition 1.0 (2002-01): Proposal for introducing a trigger mechanism into TV transmissions";
            default -> "reserved for future use";
        };
    }

    public static String getPageCodingString(int pageCoding) {
        return switch (pageCoding) {
            case 0 -> "All 8-bit bytes, each comprising 7 data bits and 1 odd parity bit";
            case 1 -> "All 8-bit bytes, each comprising 8 data bits";
            case 2 -> "Per packet: One 8-bit byte coded Hamming 8/4, followed by thirteen groups of three 8-bit bytes coded Hamming 24/18. All packets coded in this way";
            case 3 -> "All 8-bit bytes, each code Hamming 8/4";
            case 4 -> "Per packet: Eight 8-bit bytes coded Hamming 8/4, followed by twelve 8-bit bytes coded 7 data bits and 1 odd parity bit. This sequence is then repeated for the remaining 20 bytes. All packets coded in this way.";
            case 5 -> "Per packet: First 8-bit byte coded Hamming 8/4. The data bits from this byte define the coding of the remaining 39 bytes of this packet only, according to the first five entries in this table.";
            default -> "reserved for future use";
        };
    }

    private void addChannelDataLine30(KVP node) {
        KVP s = new KVP("TV channel related broadcast service data");
        node.add(s);
        s.add(new KVP("Multiplexing", this.getDesignationCode(), this.getDesignationCode() == 0 ? "Multiplexed with video" : "Non-multiplexed, all lines may be used to carry Teletext"));
        int netWorkIdent = Utils.getInt(this.data_block, this.offset + 13, 2, 65535);
        s.add(new KVP("Network Identification Code", netWorkIdent, Utils.getNIString(netWorkIdent)));
        int timeOffsetCode = Utils.getInt(this.data_block, this.offset + 15, 1, 126) >> 1;
        s.add(new KVP("Time Offset Code", timeOffsetCode, TxtDataField.getTimeOffsetCodeString(timeOffsetCode)));
        int tenthousands = Utils.invtab[Utils.getInt(this.data_block, this.offset + 16, 1, 240)] - 1;
        int hundreds = Utils.invtab[Utils.getInt(this.data_block, this.offset + 17, 1, 240)] - 1;
        int thousands = Utils.invtab[Utils.getInt(this.data_block, this.offset + 17, 1, 15) << 4] - 1;
        int units = Utils.invtab[Utils.getInt(this.data_block, this.offset + 18, 1, 240)] - 1;
        int tens = Utils.invtab[Utils.getInt(this.data_block, this.offset + 18, 1, 15) << 4] - 1;
        long mjd = ((((long)tenthousands * 10L + (long)thousands) * 10L + (long)hundreds) * 10L + (long)tens) * 10L + (long)units;
        long y = (long)(((double)mjd - 15078.2) / 365.25);
        long m = (long)(((double)mjd - 14956.1 - (double)((long)((double)y * 365.25))) / 30.6001);
        long d = mjd - 14956L - (long)((double)y * 365.25) - (long)((double)m * 30.6001);
        long k = m == 14L || m == 15L ? 1L : 0L;
        y = y + k + 1900L;
        m = m - 1L - k * 12L;
        s.add(new KVP("Modified Julian Date", mjd, y + "/" + m + "/" + d));
        int hoursUnits = Utils.invtab[Utils.getInt(this.data_block, this.offset + 19, 1, 240)] - 1;
        int hoursTens = Utils.invtab[Utils.getInt(this.data_block, this.offset + 19, 1, 15) << 4] - 1;
        int minutesUnits = Utils.invtab[Utils.getInt(this.data_block, this.offset + 20, 1, 240)] - 1;
        int minutesTens = Utils.invtab[Utils.getInt(this.data_block, this.offset + 20, 1, 15) << 4] - 1;
        int secondsUnits = Utils.invtab[Utils.getInt(this.data_block, this.offset + 21, 1, 240)] - 1;
        int secondsTens = Utils.invtab[Utils.getInt(this.data_block, this.offset + 21, 1, 15) << 4] - 1;
        s.add(new KVP("Universal Time Co-ordinated", String.valueOf(hoursTens) + hoursUnits + ":" + minutesTens + minutesUnits + ":" + secondsTens + secondsUnits));
    }

    private void addInititalPagePacket8_30ToJTree(KVP s) {
        int pageNumber = this.getPageNumber(7);
        int subPage = this.getSubPage(9);
        int m = this.getMagazineComplement(10) ^ this.getMagazineNo();
        String formattedPageNo = TxtDataField.formatPageNo(m, pageNumber, subPage);
        KVP initialTxtPage = new KVP("Initial Teletext Page", formattedPageNo);
        s.add(initialTxtPage);
        initialTxtPage.add(new KVP("pageNumber", pageNumber));
        initialTxtPage.add(new KVP("sub page", subPage));
        initialTxtPage.add(new KVP("magazine modified", m));
    }

    public static String formatPageNo(int m, int pageNumber, int subPage) {
        StringBuilder b = new StringBuilder();
        if (pageNumber == 255) {
            b.append(" - ");
        } else {
            if (m == 0) {
                b.append("8");
            } else {
                b.append(m);
            }
            b.append(Utils.toHexStringUnformatted(pageNumber, 2));
            if (subPage != 16255) {
                b.append(':').append(Utils.toHexStringUnformatted(subPage, 4));
            }
        }
        return b.toString();
    }

    public KVP getHTMLJTreeNode(int modus) {
        KVP s = new KVP(this.getTeletextPlain()).setHtmlLabel(this.getTeletextHTML());
        this.addDetailsToJTree(s);
        this.addDetailsToJTree(s, modus);
        return s;
    }

    public byte[] getHeaderDataBytes() {
        byte[] r = new byte[32];
        for (int i = 14; i < 46; ++i) {
            r[i - 14] = (byte)(Utils.invtab[Byte.toUnsignedInt(this.data_block[i + this.offset])] & 0x7F);
        }
        return r;
    }

    public byte[] getDataBytes(int start, int end) {
        byte[] r = new byte[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = (byte)(Utils.invtab[Byte.toUnsignedInt(this.data_block[i + this.offset])] & 0x7F);
        }
        return r;
    }

    public byte getRawByte(int i) {
        return this.data_block[i + this.offset + 6];
    }

    public String getTeletextHTML() {
        if (this.getPacketNo() == 0) {
            return this.getTeletextHTML(this.getHeaderDataBytes());
        }
        if (this.getPacketNo() < 26) {
            return this.getTeletextHTML(this.getPageDataBytes());
        }
        return "";
    }

    public String getTeletextPlain() {
        if (this.getPacketNo() == 0) {
            return TxtDataField.getTeletextPlain(this.getHeaderDataBytes());
        }
        if (this.getPacketNo() < 26) {
            return TxtDataField.getTeletextPlain(this.getPageDataBytes());
        }
        return "";
    }

    private static String getTeletextPlain(byte[] b) {
        StringBuilder buf = new StringBuilder();
        for (byte ch : b) {
            if (ch >= 32 && ch < 127) {
                buf.append((char)ch);
                continue;
            }
            buf.append(' ');
        }
        return buf.toString();
    }

    protected String getTeletextHTML(byte[] b) {
        String bg = "black";
        String fg = "white";
        StringBuilder buf = new StringBuilder("<code><b><span style=\"background-color: black; color: white; \">");
        for (byte ch : b) {
            if (ch == 32) {
                buf.append("&nbsp;");
                continue;
            }
            if (ch == 60) {
                buf.append("&lt;");
                continue;
            }
            if (ch == 38) {
                buf.append("&amp;");
                continue;
            }
            if (ch > 32 && ch < 127) {
                buf.append((char)ch);
                continue;
            }
            if (ch >= 0 && ch <= 7) {
                fg = TxtDataField.getHTMLColorString(ch);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch >= 16 && ch <= 23) {
                fg = TxtDataField.getHTMLColorString(ch - 16);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch == 28) {
                bg = TxtDataField.getHTMLColorString(0);
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            if (ch == 29) {
                bg = fg;
                buf.append("</span><span style=\"background-color: ").append(bg).append("; color: ").append(fg).append(";\">&nbsp;");
                continue;
            }
            buf.append("&nbsp;");
        }
        buf.append("</span></b></code>");
        return buf.toString();
    }

    public static int getColorInt(int i) {
        return Integer.decode("0x" + TxtDataField.getRawColorString(i));
    }

    public static String getHTMLColorString(int i) {
        return "#" + TxtDataField.getRawColorString(i);
    }

    public static String getRawColorString(int i) {
        return switch (i) {
            case 0 -> "000000";
            case 1 -> "ff0000";
            case 2 -> "00ff00";
            case 3 -> "ffff00";
            case 4 -> "0000ff";
            case 5 -> "ff00ff";
            case 6 -> "00ffff";
            case 7 -> "ffffff";
            case 8 -> "000000";
            case 9 -> "770000";
            case 10 -> "007700";
            case 11 -> "777700";
            case 12 -> "000077";
            case 13 -> "770077";
            case 14 -> "007777";
            case 15 -> "777777";
            case 16 -> "ff0055";
            case 17 -> "ff7700";
            case 18 -> "00ff77";
            case 19 -> "ffffbb";
            case 20 -> "00ccaa";
            case 21 -> "550000";
            case 22 -> "665522";
            case 23 -> "cc7777";
            case 24 -> "333333";
            case 25 -> "ff7777";
            case 26 -> "77ff77";
            case 27 -> "ffff77";
            case 28 -> "7777ff";
            case 29 -> "ff77ff";
            case 30 -> "77ffff";
            case 31 -> "dddddd";
            default -> "ffffff";
        };
    }

    private static String getDataChannelString(int i) {
        return switch (i) {
            case 0 -> "Packet 8/30";
            case 1 -> "Packet 1/30";
            case 2 -> "Packet 2/30";
            case 3 -> "Packet 3/30";
            case 4 -> "Low bit rate audio";
            case 5 -> "Datavideo";
            case 6 -> "Datavideo";
            case 7 -> "Packet 7/30";
            case 8 -> "IDL Format A or B";
            case 9 -> "IDL Format A or B";
            case 10 -> "IDL Format A or B";
            case 11 -> "IDL Format A or B";
            case 12 -> "Low bit rate audio";
            case 13 -> "Datavideo";
            case 14 -> "Datavideo";
            case 15 -> "IDL Format B";
            default -> "Illegal value";
        };
    }

    public byte[] getPageDataBytes() {
        byte[] r = new byte[40];
        for (int i = 6; i < 46; ++i) {
            r[i - 6] = (byte)(Utils.invtab[Byte.toUnsignedInt(this.data_block[i + this.offset])] & 0x7F);
        }
        return r;
    }

    public byte getPageDataByte(int i) {
        return (byte)(Utils.invtab[Byte.toUnsignedInt(this.data_block[i + this.offset + 6])] & 0x7F);
    }

    public int getPageNumberUnits() {
        return this.getPageNumberUnits(6);
    }

    public int getPageNumberUnits(int localOffset) {
        return Utils.getHammingReverseByte(this.data_block[localOffset + this.offset]);
    }

    public int getPageNumberTens() {
        return this.getPageNumberTens(7);
    }

    public int getPageNumberTens(int localOffset) {
        return Utils.getHammingReverseByte(this.data_block[localOffset + this.offset]);
    }

    public int getPageNumber() {
        return this.getPageNumber(6);
    }

    public int getPageNumber(int localOffset) {
        return Utils.getHammingReverseByte(this.data_block[localOffset + this.offset]) + 16 * Utils.getHammingReverseByte(this.data_block[localOffset + 1 + this.offset]);
    }

    public int getSubPage() {
        return this.getSubPage(8);
    }

    public int getSubPage(int localOffset) {
        return Utils.getHammingReverseByte(this.data_block[localOffset + this.offset]) + 16 * (Utils.getHammingReverseByte(this.data_block[localOffset + 1 + this.offset]) & 7) + 256 * Utils.getHammingReverseByte(this.data_block[localOffset + 2 + this.offset]) + 4096 * (Utils.getHammingReverseByte(this.data_block[localOffset + 3 + this.offset]) & 3);
    }

    public int getPageFunction() {
        Triplet tr = new Triplet(this.data_block, this.offset + 7);
        return tr.getPageFunction();
    }

    private int getMagazineComplement(int localOffset) {
        int m1 = Byte.toUnsignedInt(this.data_block[this.offset + localOffset]) & 1;
        int m2 = (Byte.toUnsignedInt(this.data_block[this.offset + localOffset + 2]) & 4) >> 1;
        int m3 = (Byte.toUnsignedInt(this.data_block[this.offset + localOffset + 2]) & 1) << 2;
        return m1 | m2 | m3;
    }

    public int getDesignationCode() {
        return Utils.getHammingReverseByte(this.data_block[6 + this.offset]);
    }

    public int getMagazineNo() {
        int magazine_and_packet_address = Utils.getInt(this.data_block, 4 + this.offset, 2, 65535);
        int r = (magazine_and_packet_address & 0x4000) >> 14;
        r |= (magazine_and_packet_address & 0x1000) >> 11;
        return r |= (magazine_and_packet_address & 0x400) >> 8;
    }

    public int getPacketNo() {
        int magazine_and_packet_address = Utils.getInt(this.data_block, 4 + this.offset, 2, 65535);
        int r = (magazine_and_packet_address & 0x100) >> 8;
        r |= (magazine_and_packet_address & 0x40) >> 5;
        r |= (magazine_and_packet_address & 0x10) >> 2;
        r |= (magazine_and_packet_address & 4) << 1;
        return r |= (magazine_and_packet_address & 1) << 4;
    }

    public int getDataChannel() {
        int magazine_and_packet_address = Utils.getInt(this.data_block, 4 + this.offset, 2, 65535);
        int r = (magazine_and_packet_address & 0x4000) >> 13;
        r |= (magazine_and_packet_address & 0x1000) >> 10;
        r |= (magazine_and_packet_address & 0x400) >> 7;
        return r |= (magazine_and_packet_address & 0x100) >> 8;
    }

    public boolean isErasePage() {
        return 0 != Utils.getInt(this.data_block, 9 + this.offset, 1, 1);
    }

    public boolean isNewsFlash() {
        return 0 != Utils.getInt(this.data_block, 11 + this.offset, 1, 4);
    }

    public boolean isSubtitle() {
        return 0 != Utils.getInt(this.data_block, 11 + this.offset, 1, 1);
    }

    public boolean isSuppresHeader() {
        return 0 != Utils.getInt(this.data_block, 12 + this.offset, 1, 64);
    }

    public boolean isUpdateIndicator() {
        return 0 != Utils.getInt(this.data_block, 12 + this.offset, 1, 16);
    }

    public boolean isInterruptedSequence() {
        return 0 != Utils.getInt(this.data_block, 12 + this.offset, 1, 4);
    }

    public boolean isInhibitDisplay() {
        return 0 != Utils.getInt(this.data_block, 12 + this.offset, 1, 1);
    }

    public boolean isMagazineSerial() {
        return 0 != Utils.getInt(this.data_block, 13 + this.offset, 1, 64);
    }

    public int getNationalOptionCharacterSubset() {
        return Utils.getHammingReverseByte(this.data_block[13 + this.offset]) >> 1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("TxtDataField ,Magazine:").append(this.getMagazineNo()).append("getPacketNo():").append(this.getPacketNo());
        if (this.getPacketNo() == 0) {
            b.append(", page=").append(this.getPageNumber()).append(", subPage=").append(this.getSubPage());
        }
        return b.toString();
    }

    protected void addPDCDetails(KVP node) {
        KVP s = new KVP("TV programme identification data for VCR control");
        node.add(s);
        s.add(new KVP("Label channel identifier", this.getLabelChannelIdentifier()));
        s.add(new KVP("Label Update Flag", this.getLabelUpdateFlag(), this.getLabelUpdateFlag() == 1 ? "label does not relate to the current television programme, but is intended to update the label memories in video recorders" : "label does relate to the current television programme"));
        s.add(new KVP("Prepare to Record Flag", this.getPrepareToRecordFlag()));
        s.add(new KVP("Status of analogue sound", this.getStatusOfAnalogueSound(), VPSDataField.getPCSAudioString(this.getStatusOfAnalogueSound())));
        s.add(new KVP("Mode identifier", this.getModeIdentifier(), this.getModeIdentifier() == 1 ? "service code takes immediate effect" : "effect of service codes is delayed by 30 s"));
        s.add(new KVP("CNI Country", this.getCNICountry()));
        s.add(new KVP("CNI Network", this.getCNINetwork()));
        s.add(new KVP("day", this.getDay()));
        s.add(new KVP("month", this.getMonth()));
        s.add(new KVP("hour", this.getHour()));
        s.add(new KVP("minute", this.getMinute()));
        s.add(new KVP("PTY", this.getPTY()));
    }

    protected int getCNICountry() {
        return 16 * Utils.getHammingByte(this.data_block[13 + this.offset + 2]) + 4 * (Utils.getHammingByte(this.data_block[13 + this.offset + 8]) & 3) + ((Utils.getHammingByte(this.data_block[13 + this.offset + 9]) & 0xC) >> 2);
    }

    protected int getCNINetwork() {
        return (64 * (Utils.getHammingByte(this.data_block[13 + this.offset + 3]) & 0xC) >> 2) + 16 * (Utils.getHammingByte(this.data_block[13 + this.offset + 9]) & 3) + Utils.getHammingByte(this.data_block[13 + this.offset + 10]);
    }

    protected int getLabelChannelIdentifier() {
        return (Utils.getHammingByte(this.data_block[13 + this.offset]) & 0xC) >> 2;
    }

    protected int getLabelUpdateFlag() {
        return (Utils.getHammingByte(this.data_block[13 + this.offset]) & 2) >> 1;
    }

    protected int getPrepareToRecordFlag() {
        return Utils.getHammingByte(this.data_block[13 + this.offset]) & 1;
    }

    protected int getStatusOfAnalogueSound() {
        return (Utils.getHammingByte(this.data_block[13 + this.offset + 1]) & 0xC) >> 2;
    }

    protected int getModeIdentifier() {
        return (Utils.getHammingByte(this.data_block[13 + this.offset + 1]) & 2) >> 1;
    }

    protected int getDay() {
        return 8 * (Utils.getHammingByte(this.data_block[13 + this.offset + 3]) & 3) + ((Utils.getHammingByte(this.data_block[13 + this.offset + 4]) & 0xE) >> 1);
    }

    protected int getMonth() {
        return 2 * (Utils.getHammingByte(this.data_block[13 + this.offset + 4]) & 1) + ((Utils.getHammingByte(this.data_block[13 + this.offset + 5]) & 0xE) >> 1);
    }

    protected int getHour() {
        return 16 * (Utils.getHammingByte(this.data_block[13 + this.offset + 5]) & 1) + Utils.getHammingByte(this.data_block[13 + this.offset + 6]);
    }

    protected int getMinute() {
        return 4 * Utils.getHammingByte(this.data_block[13 + this.offset + 7]) + ((Utils.getHammingByte(this.data_block[13 + this.offset + 8]) & 0xC) >> 2);
    }

    protected int getPTY() {
        return 16 * Utils.getHammingByte(this.data_block[13 + this.offset + 11]) + Utils.getHammingByte(this.data_block[13 + this.offset + 12]);
    }

    private static String getTimeOffsetCodeString(int timeOffset) {
        int uren = Utils.invtab[(timeOffset & 0x1E) << 3];
        StringBuilder b = new StringBuilder().append(uren);
        if ((timeOffset & 0x20) != 0) {
            b.append('\u00bd');
        }
        if ((timeOffset & 1) != 0) {
            b.append(" hour(s), negative offset (west of Greenwich)");
        } else {
            b.append(" hour(s), positive offset (east of Greenwich)");
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TxtDataField other = (TxtDataField)obj;
        if (this.dataUnitId != other.dataUnitId) {
            return false;
        }
        if (this.dataUnitLength != other.dataUnitLength) {
            return false;
        }
        if (!Utils.equals(this.data_block, this.offset, this.len, other.data_block, other.offset, other.len)) {
            return false;
        }
        if (this.field_parity != other.field_parity) {
            return false;
        }
        if (this.line_offset != other.line_offset) {
            return false;
        }
        return this.reserved_future_use == other.reserved_future_use;
    }

    public int getColor(int c) {
        int i;
        List<Triplet> tripletList = this.getTripletList();
        BitString bs = new BitString();
        bs.addIntBitsReverse(tripletList.get(1).getVal() & 0xFF, 8);
        for (i = 3; i <= 12; ++i) {
            bs.addIntBitsReverse(tripletList.get(i - 1).getVal(), 18);
        }
        bs.addIntBitsReverse(tripletList.get(12).getVal() & 0xF, 4);
        for (i = 16; i <= 31; ++i) {
            int r = bs.getIntBitsReverse(4);
            int g = bs.getIntBitsReverse(4);
            int b = bs.getIntBitsReverse(4);
            if (i != c) continue;
            int r_byte = r * 255 / 15;
            int g_byte = g * 255 / 15;
            int b_byte = b * 255 / 15;
            return r_byte << 16 | g_byte << 8 | b_byte;
        }
        return 0;
    }

    public boolean isBlackBackGroundColorSubstitution() {
        Triplet tr13 = new Triplet(this.data_block, this.offset + 4 + 39);
        int blackBackgroundColourSubstitution = (tr13.getVal() & 0x4000) >> 14;
        return blackBackgroundColourSubstitution == 1;
    }

    public int getDefaultScreenColour() {
        Triplet tr13 = new Triplet(this.data_block, this.offset + 4 + 39);
        return (tr13.getVal() & 0x1F0) >> 4;
    }

    public int getDefaultRowColour() {
        Triplet tr13 = new Triplet(this.data_block, this.offset + 4 + 39);
        return (tr13.getVal() & 0x3E00) >> 9;
    }
}

