/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Magazine;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.TxtDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class TxtService
implements TreeNode {
    private TransportStream transportStream;
    private final Magazine[] magazineList = new Magazine[8];
    private final List<TxtDataField>[] packet8_30 = new ArrayList[16];
    private final List<TxtDataField>[] packet8_31 = new ArrayList[16];

    TxtService(TransportStream transportStream) {
        this.transportStream = transportStream;
    }

    void addTxtDataField(TxtDataField txtDataField) {
        int mag = txtDataField.getMagazineNo();
        if (txtDataField.getPacketNo() < 30) {
            if (this.magazineList[mag] == null) {
                this.magazineList[mag] = new Magazine(this, mag);
            }
            this.magazineList[mag].addTxtDataField(txtDataField);
        } else if (txtDataField.getPacketNo() == 30) {
            if (this.packet8_30[txtDataField.getDesignationCode()] == null) {
                this.packet8_30[txtDataField.getDesignationCode()] = new ArrayList<TxtDataField>();
            }
            EBUTeletextHandler.add(txtDataField, this.packet8_30[txtDataField.getDesignationCode()]);
        } else if (txtDataField.getPacketNo() == 31) {
            if (this.packet8_31[txtDataField.getDesignationCode()] == null) {
                this.packet8_31[txtDataField.getDesignationCode()] = new ArrayList<TxtDataField>();
            }
            EBUTeletextHandler.add(txtDataField, this.packet8_31[txtDataField.getDesignationCode()]);
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        List<TxtDataField> txtDatafield;
        int i;
        KVP s = new KVP("TxtService");
        for (i = 0; i < this.packet8_30.length; ++i) {
            txtDatafield = this.packet8_30[i];
            if (txtDatafield == null) continue;
            Utils.addListJTree(s, txtDatafield, modus, "Line Y=30, designation:" + i);
        }
        for (i = 0; i < this.packet8_31.length; ++i) {
            txtDatafield = this.packet8_31[i];
            if (txtDatafield == null) continue;
            Utils.addListJTree(s, txtDatafield, modus, "Line Y=31, designation:" + i);
        }
        for (i = 1; i < 9; ++i) {
            Magazine m = this.magazineList[i % 8];
            if (m == null) continue;
            s.add(m.getJTreeNode(modus));
        }
        return s;
    }

    public Magazine getMagazine(int m) {
        return this.magazineList[m];
    }

    public TransportStream getTransportStream() {
        return this.transportStream;
    }

    public List<TxtDataField>[] getPacket8_30() {
        return this.packet8_30;
    }

    public List<TxtDataField>[] getPacket8_31() {
        return this.packet8_31;
    }
}

