/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.Triplet;

public class TxtTriplet
extends Triplet {
    private static final short[][] diacritical_uppercase_char_map = new short[][]{{0, 192, 193, 194, 195, 256, 258, 0, 196, 0, 197, 0, 0, 0, 260, 258}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 262, 264, 0, 0, 268, 266, 0, 0, 0, 199, 0, 0, 0, 268}, {0, 0, 0, 0, 0, 0, 270, 0, 0, 0, 0, 0, 0, 0, 0, 270}, {0, 200, 201, 202, 0, 274, 276, 278, 203, 0, 0, 0, 0, 0, 280, 282}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 284, 0, 0, 286, 288, 0, 0, 0, 290, 0, 0, 0, 0}, {0, 0, 0, 292, 0, 294, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 204, 205, 206, 296, 298, 300, 304, 207, 0, 0, 0, 0, 0, 302, 300}, {0, 0, 0, 308, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 310, 0, 0, 0, 0}, {0, 0, 313, 0, 0, 0, 0, 319, 0, 0, 0, 315, 0, 0, 0, 317}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 323, 0, 209, 0, 0, 0, 0, 0, 0, 325, 0, 0, 0, 327}, {0, 210, 211, 212, 213, 332, 334, 0, 214, 0, 0, 0, 0, 336, 0, 334}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 340, 0, 0, 0, 0, 0, 0, 0, 0, 342, 0, 0, 0, 344}, {0, 0, 346, 348, 0, 0, 0, 0, 0, 0, 0, 350, 0, 0, 0, 352}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 354, 0, 0, 0, 356}, {0, 217, 218, 219, 360, 362, 364, 0, 220, 0, 366, 0, 0, 368, 370, 364}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 372, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 221, 374, 0, 0, 0, 0, 376, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 377, 0, 0, 0, 0, 379, 0, 0, 0, 0, 0, 0, 0, 381}};
    private static final short[][] diacritical_lowercase_char_map = new short[][]{{0, 224, 225, 226, 227, 257, 259, 0, 228, 0, 229, 0, 0, 0, 261, 259}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 263, 265, 0, 0, 269, 267, 0, 0, 0, 231, 0, 0, 0, 269}, {0, 0, 0, 0, 0, 0, 271, 0, 0, 0, 0, 0, 0, 0, 0, 271}, {0, 232, 233, 234, 0, 275, 277, 279, 235, 0, 0, 0, 0, 0, 281, 283}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 285, 0, 0, 287, 289, 0, 0, 0, 291, 0, 0, 0, 0}, {0, 0, 0, 293, 0, 295, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 236, 237, 238, 297, 299, 301, 305, 239, 0, 0, 0, 0, 0, 303, 301}, {0, 0, 0, 309, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 311, 0, 0, 0, 0}, {0, 0, 314, 0, 0, 0, 0, 320, 0, 0, 0, 316, 0, 0, 0, 318}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 324, 0, 241, 0, 0, 0, 0, 0, 0, 326, 0, 0, 0, 328}, {0, 242, 243, 244, 245, 333, 335, 0, 246, 0, 0, 0, 0, 337, 0, 335}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 341, 0, 0, 0, 0, 0, 0, 0, 0, 343, 0, 0, 0, 345}, {0, 0, 347, 349, 0, 0, 0, 0, 0, 0, 0, 351, 0, 0, 0, 353}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 355, 0, 0, 0, 357}, {0, 249, 250, 251, 361, 363, 365, 0, 252, 0, 367, 0, 0, 369, 371, 365}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 373, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 253, 375, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 378, 0, 0, 0, 0, 380, 0, 0, 0, 0, 0, 0, 0, 382}};
    public static final short[][] G0_sets = new short[][]{{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 1063, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1032, 1050, 1051, 1052, 1053, 1054, 1055, 1036, 1056, 1057, 1058, 1059, 1042, 1027, 1033, 1034, 1047, 1035, 1046, 1026, 1064, 1039, 1095, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1112, 1082, 1083, 1084, 1085, 1086, 1087, 1116, 1088, 1089, 1090, 1091, 1074, 1107, 1113, 1114, 1101, 1115, 1078, 1106, 1096, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 1099, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1066, 1047, 1064, 1069, 1065, 1063, 1067, 1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1098, 1079, 1096, 1101, 1097, 1095, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 1111, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 1070, 1040, 1041, 1062, 1044, 1045, 1060, 1043, 1061, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1071, 1056, 1057, 1058, 1059, 1046, 1042, 1068, 1030, 1047, 1064, 1028, 1065, 1063, 1031, 1102, 1072, 1073, 1094, 1076, 1077, 1092, 1075, 1093, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1103, 1088, 1089, 1090, 1091, 1078, 1074, 1100, 1110, 1079, 1096, 1108, 1097, 1095, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 171, 61, 187, 63, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 900, 931, 932, 933, 934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 1567, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 34, 35, 164, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 8592, 189, 8594, 8593, 35, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 32, 1520, 188, 247, 32}};
    public static final short[][] G2_sets = new short[][]{{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 161, 162, 163, 36, 165, 35, 167, 164, 180, 34, 171, 60, 94, 61, 118, 176, 177, 178, 179, 215, 181, 182, 183, 247, 180, 34, 187, 188, 189, 190, 191, 32, 96, 180, 710, 126, 713, 728, 729, 776, 46, 730, 32, 95, 34, 32, 728, 45, 185, 174, 169, 8482, 42, 8364, 8240, 945, 32, 32, 32, 42, 42, 42, 42, 937, 198, 272, 97, 294, 32, 306, 319, 321, 216, 338, 111, 222, 358, 330, 329, 312, 230, 273, 271, 295, 305, 307, 320, 322, 248, 339, 223, 254, 359, 331, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 161, 162, 163, 36, 165, 32, 167, 32, 180, 34, 171, 60, 94, 61, 118, 176, 177, 178, 179, 215, 181, 182, 183, 247, 180, 34, 187, 188, 189, 190, 191, 32, 96, 180, 710, 126, 713, 728, 729, 776, 46, 730, 32, 95, 34, 32, 728, 45, 185, 174, 169, 8482, 42, 8364, 8240, 945, 321, 322, 223, 42, 42, 42, 42, 68, 69, 70, 71, 73, 74, 75, 76, 78, 81, 82, 83, 85, 86, 87, 90, 100, 101, 102, 103, 105, 106, 107, 108, 110, 113, 114, 115, 117, 118, 119, 122}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 97, 98, 163, 101, 104, 105, 167, 58, 180, 34, 107, 60, 94, 61, 118, 176, 177, 178, 179, 215, 109, 110, 112, 247, 180, 34, 116, 188, 189, 190, 120, 32, 96, 180, 710, 126, 713, 728, 729, 776, 46, 730, 32, 95, 34, 32, 728, 63, 185, 174, 169, 8482, 42, 8364, 8240, 945, 906, 910, 911, 42, 42, 42, 42, 67, 68, 70, 71, 74, 76, 81, 82, 83, 85, 86, 87, 89, 90, 902, 905, 99, 100, 102, 103, 106, 108, 113, 114, 115, 117, 118, 119, 121, 122, 904, 32}, {32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 161, 162, 163, 36, 165, 35, 167, 164, 180, 34, 171, 60, 94, 61, 118, 176, 177, 178, 179, 215, 181, 182, 183, 247, 180, 34, 187, 188, 189, 190, 191, 32, 96, 180, 710, 126, 713, 728, 729, 776, 46, 730, 32, 95, 34, 32, 728, 45, 185, 174, 169, 8482, 42, 8364, 8240, 32, 32, 32, 32, 42, 42, 42, 42, 937, 198, 272, 97, 294, 32, 306, 319, 321, 216, 338, 111, 222, 358, 330, 329, 312, 230, 273, 271, 295, 305, 307, 320, 322, 248, 339, 223, 254, 359, 331, 32}};
    private static final int[][] G0_set_mapping = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 3, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 6, 0, 5}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
    private static final short[][] national_subsets = new short[][]{{163, 36, 64, 171, 189, 187, 94, 35, 45, 188, 166, 190, 247}, {233, 239, 224, 235, 234, 249, 238, 35, 232, 226, 244, 251, 231}, {35, 164, 201, 196, 214, 197, 220, 95, 233, 228, 246, 229, 252}, {35, 367, 269, 357, 382, 253, 237, 345, 233, 225, 277, 250, 353}, {35, 36, 167, 196, 214, 220, 94, 95, 176, 228, 246, 252, 223}, {231, 36, 161, 225, 233, 237, 243, 250, 191, 252, 241, 232, 224}, {163, 36, 233, 176, 231, 187, 94, 35, 249, 224, 242, 232, 236}, {35, 164, 354, 194, 350, 258, 206, 305, 355, 226, 351, 259, 238}, {35, 36, 352, 279, 281, 381, 269, 363, 353, 261, 371, 382, 303}, {35, 324, 261, 90, 346, 321, 263, 243, 281, 380, 347, 322, 378}, {35, 203, 268, 262, 381, 272, 352, 235, 269, 263, 382, 273, 353}, {35, 245, 352, 196, 214, 382, 220, 213, 353, 228, 246, 382, 252}, {84, 287, 304, 350, 214, 199, 220, 286, 305, 351, 246, 231, 252}, null};
    private static final int[][] national_subset_mapping = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {9, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 12, 4, 5, 6, 7}, {13, 13, 13, 13, 13, 10, 13, 7}, {13, 13, 11, 3, 4, 13, 8, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 12, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {0, 1, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}, {13, 13, 13, 13, 13, 13, 13, 13}};

    public static short getCombinedCharacter(int basic_char, int combine_char) {
        short val = 0;
        if (basic_char >= 65 && basic_char <= 90) {
            val = diacritical_uppercase_char_map[basic_char - 65][combine_char];
        } else if (basic_char >= 97 && basic_char <= 122) {
            val = diacritical_lowercase_char_map[basic_char - 97][combine_char];
        }
        if (val == 0) {
            return (short)basic_char;
        }
        return val;
    }

    public TxtTriplet(byte[] data, int offset) {
        super(data, offset);
    }

    public static String getObjectSourceString(int objectSource) {
        return switch (objectSource) {
            case 0 -> "Illegal";
            case 1 -> "Local";
            case 2 -> "POP";
            case 3 -> "GPOP";
            default -> "illegal value";
        };
    }

    public int getAddress() {
        return this.val & 0x3F;
    }

    public int getMode() {
        return (this.val & 0x7C0) >> 6;
    }

    public int getData() {
        return (this.val & 0x3F800) >> 11;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        int address = this.val & 0x3F;
        int mode = (this.val & 0x7C0) >> 6;
        int data = (this.val & 0x3F800) >> 11;
        String detailString = TxtTriplet.buildDetail(address, mode, data);
        KVP t = new KVP("Triplet", this.val, TxtTriplet.getModeString(mode, address) + detailString);
        t.add(new KVP("mode", mode, TxtTriplet.getModeString(mode, address)));
        t.add(new KVP("address/data word A", address, (String)(address <= 39 ? "Column Address Group" : "Row Address Group " + (address == 40 ? 24 : address - 40))));
        t.add(new KVP("data/data word B", data));
        return t;
    }

    private static String buildDetail(int address, int mode, int data) {
        String result = TxtTriplet.buildDetailCore(address, mode, data);
        if (!result.isEmpty()) {
            return " (" + result + ")";
        }
        return "";
    }

    private static String buildDetailCore(int address, int mode, int data) {
        if (address < 40) {
            return TxtTriplet.buildColumnAddresGroupDetail(address, mode, data);
        }
        return TxtTriplet.buildRowAddressGroupDetail(address, mode, data);
    }

    private static String buildRowAddressGroupDetail(int address, int mode, int data) {
        StringBuilder stringBuilder = new StringBuilder();
        if (mode == 4) {
            stringBuilder.append("Row ");
            stringBuilder.append(TxtTriplet.getRow(address));
            stringBuilder.append(", column ");
            stringBuilder.append(data < 40 ? Integer.valueOf(data) : "undefined");
        }
        if (mode == 8) {
            stringBuilder.append("Country of Origin ");
            stringBuilder.append(address & 0xF);
            stringBuilder.append(", Programme Source ");
            stringBuilder.append(data & 0x3F);
        }
        if (mode == 9) {
            stringBuilder.append("Month ");
            stringBuilder.append(address & 0xF);
            stringBuilder.append(", Day ");
            stringBuilder.append((data & 0x30) >> 4);
            stringBuilder.append(data & 0xF);
        }
        if (mode == 10) {
            stringBuilder.append("Row ");
            stringBuilder.append(TxtTriplet.getRow(address));
            stringBuilder.append(", hours ");
            stringBuilder.append(TxtTriplet.getHoursString(data));
            stringBuilder.append(", Controlled Access Flag ");
            stringBuilder.append((data & 0x40) > 0 ? "controlled access" : "free access");
        }
        if (mode == 11) {
            stringBuilder.append("Row ");
            stringBuilder.append(TxtTriplet.getRow(address));
            stringBuilder.append(", hours ");
            stringBuilder.append(TxtTriplet.getHoursString(data));
            stringBuilder.append(", duration ");
            stringBuilder.append((data & 0x40) > 0 ? "programme duration" : "finishing time");
        }
        if (mode == 16) {
            stringBuilder.append("row offset  ");
            stringBuilder.append(address - 40);
            stringBuilder.append(", column offset ");
            stringBuilder.append(data & 0xF);
        }
        if (mode >= 17 && mode <= 19) {
            int objectSource = (address & 0x18) >> 3;
            int objectType = mode & 3;
            int subPageS1 = data & 0xF;
            int ptrLocation = address & 3;
            int tripletOffset = (data & 0x60) >> 5;
            int ptrPosition = (data & 0x10) >> 4;
            int objectNo = ptrLocation << 3 | tripletOffset << 1 | ptrPosition;
            stringBuilder.append("object source");
            stringBuilder.append(objectSource);
            stringBuilder.append(" (");
            stringBuilder.append(TxtTriplet.getObjectSourceString(objectSource));
            stringBuilder.append("), object type:");
            stringBuilder.append(objectType);
            stringBuilder.append(" (");
            stringBuilder.append(EBUTeletextHandler.getObjectTypeString(objectType));
            stringBuilder.append(") objectNo:");
            stringBuilder.append(objectNo);
            stringBuilder.append(", SubPageS1:");
            stringBuilder.append(subPageS1);
            stringBuilder.append(", ptrLocation:");
            stringBuilder.append(ptrLocation);
            stringBuilder.append(", tripletOffset ");
            stringBuilder.append(tripletOffset);
            stringBuilder.append(" ptrPosition ");
            stringBuilder.append(ptrPosition);
        }
        if (mode >= 21 && mode <= 23) {
            String objectUsage = switch ((address & 0x18) >> 3) {
                case 0 -> "illegal";
                case 1 -> "Level 2.5";
                case 2 -> "Level 3.5";
                case 3 -> "Levels 2.5 and 3.5";
                default -> "illegal";
            };
            stringBuilder.append("Object Usage ");
            stringBuilder.append(objectUsage);
            stringBuilder.append(", packet within object page containing the pointer to this object ");
            stringBuilder.append(1 + (address & 3));
        }
        return stringBuilder.toString();
    }

    private static String buildColumnAddresGroupDetail(int address, int mode, int data) {
        int clutEntry;
        int clut;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("column ");
        stringBuilder.append(address);
        stringBuilder.append(", ");
        if (mode == 0) {
            clut = (data & 0x18) >> 3;
            clutEntry = data & 7;
            stringBuilder.append("clut ");
            stringBuilder.append(clut);
            stringBuilder.append(", entry ");
            stringBuilder.append(clutEntry);
        }
        if (mode == 3) {
            clut = (data & 0x18) >> 3;
            clutEntry = data & 7;
            stringBuilder.append("clut ");
            stringBuilder.append(clut);
            stringBuilder.append(", entry ");
            stringBuilder.append(clutEntry);
        }
        if (mode == 6) {
            int minutesUnits = data & 0xF;
            int minutesTens = (data & 0x70) >> 4;
            stringBuilder.append("minutes ");
            stringBuilder.append(minutesTens);
            stringBuilder.append(minutesUnits);
        }
        if (mode == 12) {
            int doubleWidth = (data & 0x40) >> 6;
            int underline = (data & 0x20) >> 5;
            int invert = (data & 0x10) >> 4;
            int conceal = (data & 4) >> 2;
            int boxing = (data & 2) >> 1;
            int doubleHeigth = data & 1;
            stringBuilder.append("Double Width:");
            stringBuilder.append(doubleWidth);
            stringBuilder.append(", Underline/Separated Mosaics:");
            stringBuilder.append(underline);
            stringBuilder.append(", Invert Colour:");
            stringBuilder.append(invert);
            stringBuilder.append(", Conceal:");
            stringBuilder.append(conceal);
            stringBuilder.append(", Boxing/Window:");
            stringBuilder.append(boxing);
            stringBuilder.append(", Double Height:");
            stringBuilder.append(doubleHeigth);
        }
        if (mode == 13) {
            int normal = (data & 0x40) >> 6;
            int chr = data & 0x3F;
            if (normal == 1) {
                stringBuilder.append("normal");
            } else {
                stringBuilder.append("global");
            }
            stringBuilder.append(", character ");
            stringBuilder.append(chr);
        }
        if (mode > 16) {
            stringBuilder.append((char)data);
            stringBuilder.append("+ ");
            stringBuilder.append((char)G2_sets[0][64 + (mode & 0xF)]);
            stringBuilder.append("  ");
            stringBuilder.append((char)TxtTriplet.getCombinedCharacter(data, mode & 0xF));
        }
        if (mode == 15) {
            stringBuilder.append((char)G2_sets[0][data]);
        }
        if (mode == 16) {
            stringBuilder.append((char)G0_sets[0][data]);
        }
        return stringBuilder.toString();
    }

    private static String getHoursString(int data) {
        int hoursUnits = data & 0xF;
        int hoursTens = (data & 0x30) >> 4;
        return String.valueOf(hoursTens) + hoursUnits;
    }

    protected static int getRow(int address) {
        int row = address == 40 ? 24 : address - 40;
        return row;
    }

    public static String getModeString(int mode, int address) {
        if (address <= 39) {
            return switch (mode) {
                case 0 -> "Foreground Colour";
                case 1 -> "Block Mosaic Character from the G1 set";
                case 2 -> "Line Drawing or Smoothed Mosaic Character from the G3 set (Level 1.5)";
                case 3 -> "Background Colour";
                case 4 -> "Reserved";
                case 5 -> "Reserved";
                case 6 -> "PDC - Cursor Column & Announced Starting & Finishing Time Minutes";
                case 7 -> "Additional Flash Functions";
                case 8 -> "Modified G0 and G2 Character Set Design.";
                case 9 -> "Character from the G0 set (Levels 2.5 & 3.5)";
                case 10 -> "Reserved";
                case 11 -> "Line Drawing or Smoothed Mosaic Character from the G3 set (Levels 2.5 & 3.5)";
                case 12 -> "Display Attributes";
                case 13 -> "DRCS Character Invocation";
                case 14 -> "Font Style";
                case 15 -> "Character from the G2 set";
                case 16 -> "G0 character without diacritical mark";
                case 17 -> "G0 character with diacritical mark";
                case 18 -> "G0 character with diacritical mark";
                case 19 -> "G0 character with diacritical mark";
                case 20 -> "G0 character with diacritical mark";
                case 21 -> "G0 character with diacritical mark";
                case 22 -> "G0 character with diacritical mark";
                case 23 -> "G0 character with diacritical mark";
                case 24 -> "G0 character with diacritical mark";
                case 25 -> "G0 character with diacritical mark";
                case 26 -> "G0 character with diacritical mark";
                case 27 -> "G0 character with diacritical mark";
                case 28 -> "G0 character with diacritical mark";
                case 29 -> "G0 character with diacritical mark";
                case 30 -> "G0 character with diacritical mark";
                case 31 -> "G0 character with diacritical mark";
                default -> "Illegal value";
            };
        }
        return switch (mode) {
            case 0 -> "Full Screen Colour";
            case 1 -> "Full Row Colour";
            case 2 -> "Reserved";
            case 3 -> "Reserved";
            case 4 -> "Set Active Position";
            case 5 -> "Reserved";
            case 6 -> "Reserved";
            case 7 -> "Address Display Row 0";
            case 8 -> "PDC - Country of Origin and Programme Source";
            case 9 -> "PDC - Month & Day";
            case 10 -> "PDC - Cursor Row & Announced Starting Time Hours";
            case 11 -> "PDC - Cursor Row & Announce Finishing Time Hours";
            case 12 -> "PDC - Cursor Row & Local Time Offset";
            case 13 -> "PDC - Series Identifier and Series Code";
            case 14 -> "Reserved";
            case 15 -> "Reserved";
            case 16 -> "Origin Modifier";
            case 17 -> "Active Object Invocation";
            case 18 -> "Adaptive Object Invocation";
            case 19 -> "Passive Object Invocation";
            case 20 -> "Reserved";
            case 21 -> "Active Object Definition";
            case 22 -> "Adaptive Object Definition";
            case 23 -> "Passive Object Definition";
            case 24 -> "DRCS Mode";
            case 25 -> "Reserved";
            case 26 -> "Reserved";
            case 27 -> "Reserved";
            case 28 -> "Reserved";
            case 29 -> "Reserved";
            case 30 -> "Reserved";
            case 31 -> "Termination Marker";
            default -> "Illegal value";
        };
    }

    @Override
    public int getVal() {
        return this.val;
    }

    public boolean isTerminationMarker() {
        return this.getMode() == 31 && this.getAddress() >= 40;
    }

    public boolean isObjectDefinition() {
        return this.getMode() >= 21 && this.getMode() <= 23 && this.getAddress() >= 40;
    }

    public String toString() {
        return "TxtTriplet " + TxtTriplet.getModeString(this.getMode(), this.getAddress());
    }

    public static char getNationalOptionChar(byte ch, int nocs) {
        int g0SetDesignation = (nocs & 0x78) >>> 3;
        int controlBits = nocs & 7;
        int subset_idx = national_subset_mapping[g0SetDesignation][controlBits];
        if (subset_idx == 13) {
            return TxtTriplet.getG0Character(ch, g0SetDesignation, controlBits);
        }
        return switch (ch) {
            case 35 -> (char)national_subsets[subset_idx][0];
            case 36 -> (char)national_subsets[subset_idx][1];
            case 64 -> (char)national_subsets[subset_idx][2];
            case 91 -> (char)national_subsets[subset_idx][3];
            case 92 -> (char)national_subsets[subset_idx][4];
            case 93 -> (char)national_subsets[subset_idx][5];
            case 94 -> (char)national_subsets[subset_idx][6];
            case 95 -> (char)national_subsets[subset_idx][7];
            case 96 -> (char)national_subsets[subset_idx][8];
            case 123 -> (char)national_subsets[subset_idx][9];
            case 124 -> (char)national_subsets[subset_idx][10];
            case 125 -> (char)national_subsets[subset_idx][11];
            case 126 -> (char)national_subsets[subset_idx][12];
            case 127 -> '\u25a0';
            default -> TxtTriplet.getG0Character(ch, g0SetDesignation, controlBits);
        };
    }

    private static char getG0Character(byte ch, int g0SetDesignation, int controlBits) {
        return (char)G0_sets[G0_set_mapping[g0SetDesignation][controlBits]][ch];
    }
}

