/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ebu;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUDataField;
import nl.digitalekabeltelevisie.util.Utils;

public class WSSDataField
extends EBUDataField {
    private int wss_data_block;
    private int aspectRatio;
    private int filmBit;
    private int colourCodingBit;
    private int helperBit;
    private int subtitlesWithinTeletextBit;
    private int subtitlingMode;
    private int surroundSoundBit;
    private int copyrightBit;
    private int generationBit;

    public WSSDataField(byte[] data, int offset, int len, long pts) {
        super(data, offset, len, pts);
        this.wss_data_block = Utils.getInt(this.data_block, offset + 3, 2, 65532) >> 2;
        this.aspectRatio = Utils.getInt(this.data_block, offset + 3, 1, 240) >> 4;
        this.filmBit = Utils.getInt(this.data_block, offset + 3, 1, 8) >> 3;
        this.colourCodingBit = Utils.getInt(this.data_block, offset + 3, 1, 4) >> 2;
        this.helperBit = Utils.getInt(this.data_block, offset + 3, 1, 2) >> 1;
        this.subtitlesWithinTeletextBit = Utils.getInt(this.data_block, offset + 4, 1, 128) >> 7;
        this.subtitlingMode = Utils.getInt(this.data_block, offset + 4, 1, 96) >> 5;
        this.surroundSoundBit = Utils.getInt(this.data_block, offset + 4, 1, 16) >> 4;
        this.copyrightBit = Utils.getInt(this.data_block, offset + 4, 1, 8) >> 3;
        this.generationBit = Utils.getInt(this.data_block, offset + 4, 1, 4) >> 2;
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = super.getJTreeNode(modus);
        s.add(new KVP("wss_data_block", this.wss_data_block));
        s.add(new KVP("Aspect Ratio", this.aspectRatio, WSSDataField.getAspectRatioString(this.aspectRatio)));
        s.add(new KVP("Film Bit", this.filmBit, WSSDataField.getFilmBitString(this.filmBit)));
        s.add(new KVP("Colour coding Bit", this.colourCodingBit, WSSDataField.getColourCodingBitString(this.colourCodingBit)));
        s.add(new KVP("Helper Bit", this.helperBit, WSSDataField.getHelperBitString(this.helperBit)));
        s.add(new KVP("Subtitles within Teletext", this.subtitlesWithinTeletextBit, WSSDataField.getSubtitlesWithinTeletextString(this.subtitlesWithinTeletextBit)));
        s.add(new KVP("Subtitling mode", this.subtitlingMode, WSSDataField.getSubtitlingModeString(this.subtitlingMode)));
        s.add(new KVP("Surround sound bit", this.surroundSoundBit, WSSDataField.getSurroundSoundBitString(this.surroundSoundBit)));
        s.add(new KVP("Copyright bit", this.copyrightBit, WSSDataField.getCopyrightBitString(this.copyrightBit)));
        s.add(new KVP("Generation bit", this.generationBit, WSSDataField.getGenerationBitString(this.generationBit)));
        return s;
    }

    public static String getAspectRatioString(int flag) {
        return switch (flag) {
            case 1 -> "4:3 full format";
            case 8 -> "14:9 letterbox centre";
            case 4 -> "14:9 letterbox top";
            case 13 -> "16:9 letterbox centre";
            case 2 -> "16:9 letterbox top";
            case 11 -> "> 16:9 letterbox centre";
            case 7 -> "14:9 full format";
            case 14 -> "16:9 full format";
            default -> "Parity error";
        };
    }

    public static String getFilmBitString(int flag) {
        return switch (flag) {
            case 0 -> "Camera mode";
            case 1 -> "Film mode";
            default -> "Illegal Value";
        };
    }

    public static String getColourCodingBitString(int flag) {
        return switch (flag) {
            case 0 -> "standard coding";
            case 1 -> "Motion Adaptive Colour Plus";
            default -> "Illegal Value";
        };
    }

    public static String getHelperBitString(int flag) {
        return switch (flag) {
            case 0 -> "No helper";
            case 1 -> "Modulated helper";
            default -> "Illegal Value";
        };
    }

    public static String getSubtitlesWithinTeletextString(int flag) {
        return switch (flag) {
            case 0 -> "no subtitles within Teletext";
            case 1 -> "subtitles within Teletext";
            default -> "Illegal Value";
        };
    }

    public static String getSubtitlingModeString(int flag) {
        return switch (flag) {
            case 0 -> "no open subtitles";
            case 1 -> "subtitles out of active image area";
            case 2 -> "subtitles in active image area";
            case 3 -> "reserved";
            default -> "Illegal Value";
        };
    }

    public static String getSurroundSoundBitString(int flag) {
        return switch (flag) {
            case 0 -> "no surround sound information";
            case 1 -> "surround sound mode";
            default -> "Illegal Value";
        };
    }

    public static String getCopyrightBitString(int flag) {
        return switch (flag) {
            case 0 -> "no copyright asserted or status unknown";
            case 1 -> "copyright asserted";
            default -> "Illegal Value";
        };
    }

    public static String getGenerationBitString(int flag) {
        return switch (flag) {
            case 0 -> "copying not restricted";
            case 1 -> "copying restricted";
            default -> "Illegal Value";
        };
    }
}

