/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.smpte;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class AncillaryDataPacket
implements TreeNode {
    private final int b0;
    private final int c_not_y_channel_flag;
    private final int line_number;
    private final int horizontal_offset;
    private final int DID;
    private final int SDID;
    private final int data_count;
    private final List<DataWord> user_data_word = new ArrayList<DataWord>();
    private final int checksum_word;

    protected AncillaryDataPacket(BitSource bs) {
        this.b0 = bs.readBits(6);
        this.c_not_y_channel_flag = bs.readBits(1);
        this.line_number = bs.readBits(11);
        this.horizontal_offset = bs.readBits(12);
        this.DID = bs.readBits(10);
        this.SDID = bs.readBits(10);
        this.data_count = bs.readBits(10);
        for (int i = 0; i < (this.data_count & 0xFF); ++i) {
            this.user_data_word.add(new DataWord(bs.readBits(10)));
        }
        this.checksum_word = bs.readBits(10);
    }

    public int getB0() {
        return this.b0;
    }

    public int getC_not_y_channel_flag() {
        return this.c_not_y_channel_flag;
    }

    public int getLine_number() {
        return this.line_number;
    }

    public int getHorizontal_offset() {
        return this.horizontal_offset;
    }

    public int getDID() {
        return this.DID;
    }

    public int getSDID() {
        return this.SDID;
    }

    public int getData_count() {
        return this.data_count;
    }

    public List<DataWord> getUser_data_word() {
        return this.user_data_word;
    }

    public int getChecksum_word() {
        return this.checksum_word;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("Ancillary Data Packet"));
        s.add(new DefaultMutableTreeNode(new KVP("b0", this.b0, null)));
        s.add(new DefaultMutableTreeNode(new KVP("c_not_y_channelFlag", this.c_not_y_channel_flag, "SD streams: should be 0 / HD streams:" + (this.c_not_y_channel_flag == 1 ? " ANC data corresponds to the color difference channel" : " ANC data corresponds to the luminance channel"))));
        s.add(new DefaultMutableTreeNode(new KVP("line_number", this.line_number, null)));
        s.add(new DefaultMutableTreeNode(new KVP("horizontal_offset", this.horizontal_offset, null)));
        s.add(new DefaultMutableTreeNode(new KVP("DID", this.DID, "8 LSB: " + (this.DID & 0xFF))));
        s.add(new DefaultMutableTreeNode(new KVP("SDID", this.SDID, "8 LSB: " + (this.SDID & 0xFF))));
        s.add(new DefaultMutableTreeNode(new KVP("data_count", this.data_count, "8 LSB: " + (this.data_count & 0xFF))));
        DefaultMutableTreeNode d = new DefaultMutableTreeNode(new KVP("User data words"));
        Utils.addListJTree(d, this.user_data_word, modus, "User data words");
        s.add(d);
        s.add(new DefaultMutableTreeNode(new KVP("checksum_word", this.checksum_word, null)));
        return s;
    }

    public record DataWord(int dataWord) implements TreeNode
    {
        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            return new DefaultMutableTreeNode(new KVP("user_data_word", this.dataWord, "8 LSB: " + (this.dataWord & 0xFF)));
        }
    }
}

