/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.temi;

import java.util.ArrayList;
import java.util.List;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.afdescriptors.AFDescriptorFactory;
import nl.digitalekabeltelevisie.util.Utils;

public class TEMIPesDataField
extends PesPacketData {
    private int crc_flag;
    private List<AFDescriptor> afDescriptors = new ArrayList<AFDescriptor>();
    private long crc_32;

    public TEMIPesDataField(PesPacketData pesPacketData) {
        super(pesPacketData);
        int offset = pesPacketData.getPesDataStart();
        if (this.pesDataLen > 0) {
            this.crc_flag = Utils.getInt(this.data, offset, 1, 128) >>> 7;
            int descriptorsLen = pesPacketData.getPesDataLen() - 1 - 4 * this.crc_flag;
            this.afDescriptors = AFDescriptorFactory.buildDescriptorList(this.data, offset + 1, descriptorsLen);
            if (this.crc_flag == 1) {
                this.crc_32 = Utils.getLong(this.data, offset + descriptorsLen + 1, 4, -1L);
            }
        }
    }

    @Override
    public KVP getJTreeNode(int modus) {
        KVP s = (KVP)this.getJTreeNode(modus, new KVP("TEMI PES Packet"));
        if (this.pesDataLen > 0) {
            s.add(new KVP("CRC_flag", this.crc_flag));
            s.addList(this.afDescriptors, modus, "af_descriptors");
            if (this.crc_flag == 1) {
                s.add(new KVP("CRC_32", this.crc_32));
            }
        }
        return s;
    }

    public int getCrc_flag() {
        return this.crc_flag;
    }

    public List<AFDescriptor> getAfDescriptors() {
        return this.afDescriptors;
    }

    public long getCrc_32() {
        return this.crc_32;
    }
}

