/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.ttml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.CRCcheck;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.gui.XMLSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class TtmlPesDataField
extends PesPacketData {
    private static final Logger logger = Logger.getLogger(TtmlPesDataField.class.getName());
    private final long segment_mediatime;
    private final int num_of_segments;
    private final List<Segment> segmentList = new ArrayList<Segment>();
    private final long crc_32;
    private boolean crc32Failed;

    protected TtmlPesDataField(PesPacketData pesPacket) {
        super(pesPacket);
        int offset = this.pesDataStart;
        this.segment_mediatime = Utils.getLong(this.data, offset, 6, 0xFFFFFFFFFFL);
        offset += 6;
        this.num_of_segments = Utils.getInt(this.data, offset++, 1, 255);
        for (int i = 0; i < this.num_of_segments; ++i) {
            int segment_type = Utils.getInt(this.data, offset++, 1, 255);
            int segment_length = Utils.getInt(this.data, offset, 2, 65535);
            byte[] segment_data_field = Arrays.copyOfRange(this.data, offset += 2, offset + segment_length);
            offset += segment_length;
            Segment segment = new Segment(segment_type, segment_length, segment_data_field);
            this.segmentList.add(segment);
        }
        this.crc_32 = Utils.getLong(this.data, offset, 4, -1L);
        long checkRes = CRCcheck.crc32(this.data, this.pesDataStart, offset + 4 - this.pesDataStart);
        if (checkRes != 0L) {
            logger.warning("crc32 check failed, checkRes=" + checkRes);
            this.crc32Failed = true;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = super.getJTreeNode(modus, new KVP("Ttml Subtitling PES Packet"));
        s.add(new DefaultMutableTreeNode(new KVP("segment_mediatime", this.segment_mediatime, "(* 100 microseconds)")));
        s.add(new DefaultMutableTreeNode(new KVP("num_of_segments", this.num_of_segments, null)));
        Utils.addListJTree(s, this.segmentList, modus, "Segments");
        s.add(new DefaultMutableTreeNode(new KVP("crc_32", this.crc_32, this.crc32Failed ? "error in CRC Check" : null)));
        return s;
    }

    public static class Segment
    implements TreeNode,
    XMLSource {
        final LookUpList segmentTypeList = new LookUpList.Builder().add(0, "reserved for future use").add(1, "uncompressed TTML document").add(2, "gzip compressed TTML document").add(3, 255, "reserved for future use").build();
        private final int segment_type;
        private final int segment_length;
        private final byte[] segment_data_field;
        private String xml;

        public Segment(int segment_type, int segment_length, byte[] segment_data_field) {
            this.segment_type = segment_type;
            this.segment_length = segment_length;
            this.segment_data_field = segment_data_field;
            if (segment_type == 1) {
                this.xml = new String(segment_data_field, StandardCharsets.UTF_8);
            } else if (segment_type == 2) {
                try {
                    GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(segment_data_field));
                    ByteArrayOutputStream byteout = new ByteArrayOutputStream();
                    int res = 0;
                    byte[] buf = new byte[1024];
                    while (res >= 0) {
                        res = gzin.read(buf, 0, buf.length);
                        if (res <= 0) continue;
                        byteout.write(buf, 0, res);
                    }
                    byte[] uncompressed = byteout.toByteArray();
                    this.xml = new String(uncompressed, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    this.xml = "gunzip error";
                    e.printStackTrace();
                }
            } else {
                this.xml = "error";
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("Ttml Segment"));
            s.add(new DefaultMutableTreeNode(new KVP("segment_type", this.segment_type, this.segmentTypeList.get(this.segment_type))));
            s.add(new DefaultMutableTreeNode(new KVP("segment_length", this.segment_length, null)));
            s.add(new DefaultMutableTreeNode(new KVP("segment_data_field", this.segment_data_field, null)));
            KVP xmlKvp = new KVP("xml", this.xml, null);
            xmlKvp.addXMLSource(this, "Ttml Segment");
            s.add(new DefaultMutableTreeNode(xmlKvp));
            return s;
        }

        @Override
        public String getXML() {
            return this.xml;
        }
    }
}

