/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;

public class ExtensionHeader
extends VideoMPEG2Section {
    private final int extension_start_code_identifier;

    public ExtensionHeader(byte[] data, int offset) {
        super(data, offset);
        this.extension_start_code_identifier = this.bs.readBits(4);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("extension_start_code_identifier", this.extension_start_code_identifier, ExtensionHeader.getExtensionStartCodeIdentifierString(this.extension_start_code_identifier))));
        return t;
    }

    public static String getExtensionStartCodeIdentifierString(int startCode) {
        switch (startCode) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "Sequence Extension ID";
            }
            case 2: {
                return "Sequence Display Extension ID";
            }
            case 3: {
                return "Quant Matrix Extension ID";
            }
            case 4: {
                return "Copyright Extension ID";
            }
            case 5: {
                return "Sequence Scalable Extension ID";
            }
            case 6: {
                return "reserved";
            }
            case 7: {
                return "Picture Display Extension ID";
            }
            case 8: {
                return "Picture Coding Extension ID";
            }
            case 9: {
                return "Picture Spatial Scalable Extension ID";
            }
            case 10: {
                return "Picture Temporal Scalable Extension ID";
            }
        }
        return "reserved";
    }

    public int getExtension_start_code_identifier() {
        return this.extension_start_code_identifier;
    }
}

