/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import java.awt.image.BufferedImage;
import java.util.Arrays;

public class MpvDecoder {
    private int[] pixels = new int[250];
    private int Fault_Flag = 0;
    private int BitPos = 0;
    private int BufferPos = 0;
    private int YGain = 0;
    private long StartPos = 0L;
    private boolean FAST = false;
    private boolean DIRECTION = false;
    private boolean ERROR1 = false;
    private boolean ERROR2 = false;
    private boolean ERROR3 = false;
    private boolean ERROR4 = false;
    private boolean ERROR5 = false;
    private boolean ERROR6 = false;
    private boolean viewGOP = true;
    private byte[] buf = new byte[0];
    private final int[] LastPosVal = new int[2];
    static int[] ref_dct_matrix_i = new int[64];
    private static final int PICTURE_START_CODE = 256;
    private static final int SLICE_START_CODE_MIN = 257;
    private static final int SLICE_START_CODE_MAX = 431;
    private static final int USER_DATA_START_CODE = 434;
    private static final int SEQUENCE_HEADER_CODE = 435;
    private static final int EXTENSION_START_CODE = 437;
    private static final int GROUP_START_CODE = 440;
    private int ERROR_CODE1 = 0;
    private static final int SEQUENCE_EXTENSION_ID = 1;
    private static final int SEQUENCE_DISPLAY_EXTENSION_ID = 2;
    private static final int QUANT_MATRIX_EXTENSION_ID = 3;
    private static final int COPYRIGHT_EXTENSION_ID = 4;
    private static final int PICTURE_DISPLAY_EXTENSION_ID = 7;
    private static final int PICTURE_CODING_EXTENSION_ID = 8;
    private static final int ZIG_ZAG = 0;
    private static final int MC_FIELD = 1;
    private static final int MC_FRAME = 2;
    private static final int MC_16X8 = 2;
    private static final int MC_DMV = 3;
    private static final int MV_FIELD = 0;
    private static final int MV_FRAME = 1;
    private static final int I_TYPE = 1;
    private static final int P_TYPE = 2;
    private static final int B_TYPE = 3;
    private static final int BOTTOM_FIELD = 2;
    private static final int FRAME_PICTURE = 3;
    private static final int MACROBLOCK_INTRA = 1;
    private static final int MACROBLOCK_PATTERN = 2;
    private static final int MACROBLOCK_MOTION_BACKWARD = 4;
    private static final int MACROBLOCK_MOTION_FORWARD = 8;
    private static final int MACROBLOCK_QUANT = 16;
    private static final int CHROMA420 = 1;
    private static final int CHROMA422 = 2;
    private static final int CHROMA444 = 3;
    private static final int IDCT_CLIP_TABLE_OFFSET = 512;
    private int q_scale_type = 0;
    private int quantizer_scale = 0;
    private int alternate_scan = 0;
    private int Coded_Picture_Width = 0;
    private int Coded_Picture_Height = 0;
    private int Chroma_Width = 0;
    private int block_count = 0;
    private int Second_Field = 0;
    private int horizontal_size = 0;
    private int vertical_size = 0;
    private int mb_width = 0;
    private int mb_height = 0;
    private int frame_rate_code = 0;
    private int aspect_ratio_information = 0;
    private int progressive_sequence = 1;
    private int chroma_format = 1;
    private int profile_and_level_indication;
    private int video_format;
    private int picture_coding_type = 0;
    private int temporal_reference = 0;
    private final int[][] f_code = new int[2][2];
    private int picture_structure = 3;
    private int frame_pred_frame_dct = 1;
    private int progressive_frame = 1;
    private int concealment_motion_vectors = 0;
    private int intra_dc_precision = 0;
    private int top_field_first = 0;
    private int repeat_first_field = 0;
    private int intra_vlc_format = 0;
    private final int[] intra_quantizer_matrix = new int[64];
    private final int[] non_intra_quantizer_matrix = new int[64];
    private final int[] chroma_intra_quantizer_matrix = new int[64];
    private final int[] chroma_non_intra_quantizer_matrix = new int[64];
    private int load_intra_quantizer_matrix = 0;
    private int load_non_intra_quantizer_matrix = 0;
    private int load_chroma_intra_quantizer_matrix = 0;
    private int load_chroma_non_intra_quantizer_matrix = 0;
    private final short[][] block = new short[12][64];
    public static final String[] picture_coding_type_string = new String[]{"bad", "I", "P", "B", "D"};
    public static final String[] progressive_string = new String[]{"i", "p"};
    public static final String[] aspect_ratio_string = new String[]{"bad", "1:1", "4:3", "16:9", "2.21:1", "0.8055", "0.8437", "0.9375", "0.9815", "1.0255", "1.0695", "1.1250", "1.1575", "1.2015"};
    public static final float[][] ref_dct_matrix = new float[][]{{0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f, 0.35355338f}, {0.49039263f, 0.4157348f, 0.27778512f, 0.09754516f, -0.09754516f, -0.27778512f, -0.4157348f, -0.49039263f}, {0.46193975f, 0.19134171f, -0.19134171f, -0.46193975f, -0.46193975f, -0.19134171f, 0.19134171f, 0.46193975f}, {0.4157348f, -0.09754516f, -0.49039263f, -0.27778512f, 0.27778512f, 0.49039263f, 0.09754516f, -0.4157348f}, {0.35355338f, -0.35355338f, -0.35355338f, 0.35355338f, 0.35355338f, -0.35355338f, -0.35355338f, 0.35355338f}, {0.27778512f, -0.49039263f, 0.09754516f, 0.4157348f, -0.4157348f, -0.09754516f, 0.49039263f, -0.27778512f}, {0.19134171f, -0.46193975f, 0.46193975f, -0.19134171f, -0.19134171f, 0.46193975f, -0.46193975f, 0.19134171f}, {0.09754516f, -0.27778512f, 0.4157348f, -0.49039263f, 0.49039263f, -0.4157348f, 0.27778512f, -0.09754516f}};
    static final short[] idct_clip_table;
    public static final byte[] cc_table;
    public static final int[] ChromaFormat;
    public static final byte[] Non_Linear_quantizer_scale;
    public static final byte[][] MBAtab1;
    public static final byte[][] MBAtab2;
    public static final int[] default_intra_quantizer_matrix;
    public static final byte[][] scan;
    public static final byte[][] DCTtab0;
    public static final byte[][] DCTtab0a;
    public static final byte[][] DCTtab1;
    public static final byte[][] DCTtab1a;
    public static final byte[][] DCTtab2;
    public static final byte[][] DCTtab3;
    public static final byte[][] DCTtab4;
    public static final byte[][] DCTtab5;
    public static final byte[][] DCTtab6;
    public static final byte[][] DCTtabfirst;
    public static final byte[][] DCTtabnext;
    public static final byte[][] CBPtab0;
    public static final byte[][] CBPtab1;
    public static final byte[][] CBPtab2;
    public static final byte[][] DClumtab0;
    public static final byte[][] DClumtab1;
    public static final byte[][] DCchromtab0;
    public static final byte[][] DCchromtab1;
    public static final byte[][] MVtab0;
    public static final byte[][] MVtab1;
    public static final byte[][] MVtab2;
    public static final byte[][] PMBtab0;
    public static final byte[][] PMBtab1;
    public static final byte[][] BMBtab0;
    public static final byte[][] BMBtab1;
    public static final double[] frame_rate_Table;
    private final byte[] backward_reference_frame = new byte[3];
    private final byte[] forward_reference_frame = new byte[3];
    private final byte[] auxframe = new byte[3];
    private final byte[] current_frame = new byte[3];
    private float frame_rate;

    private void Clear_Block(int comp) {
        Arrays.fill(this.block[comp], (short)0);
    }

    private int Get_Bits(int N) {
        int Val;
        int Pos = this.BitPos >>> 3;
        int a = Pos;
        if (a >= this.buf.length) {
            this.ERROR3 = true;
        }
        if (a == this.LastPosVal[0]) {
            Val = this.LastPosVal[1];
        } else {
            Val = (0xFF & this.buf[a++]) << 24;
            if (a < this.buf.length) {
                Val |= (0xFF & this.buf[a++]) << 16;
            }
            if (a < this.buf.length) {
                Val |= (0xFF & this.buf[a++]) << 8;
            }
            if (a < this.buf.length) {
                Val |= 0xFF & this.buf[a];
            }
        }
        this.LastPosVal[0] = Pos;
        this.LastPosVal[1] = Val;
        Val <<= this.BitPos & 7;
        this.BitPos += N;
        this.BufferPos = this.BitPos >>> 3;
        return Val >>>= 32 - N;
    }

    private int Show_Bits(int N) {
        int Val;
        int Pos = this.BitPos >>> 3;
        int a = Pos;
        if (a >= this.buf.length) {
            this.ERROR3 = true;
        }
        if (a == this.LastPosVal[0]) {
            Val = this.LastPosVal[1];
        } else {
            Val = (0xFF & this.buf[a++]) << 24;
            if (a < this.buf.length) {
                Val |= (0xFF & this.buf[a++]) << 16;
            }
            if (a < this.buf.length) {
                Val |= (0xFF & this.buf[a++]) << 8;
            }
            if (a < this.buf.length) {
                Val |= 0xFF & this.buf[a];
            }
        }
        this.LastPosVal[0] = Pos;
        this.LastPosVal[1] = Val;
        Val <<= this.BitPos & 7;
        return Val >>>= 32 - N;
    }

    private void Flush_Bits(int N) {
        this.BitPos += N;
        this.BufferPos = this.BitPos >>> 3;
    }

    public int extern_Get_Hdr() {
        while (true) {
            if (this.DIRECTION) {
                this.previous_start_code();
            } else {
                this.next_start_code();
            }
            int start_code = this.Get_Bits(32);
            if (start_code == 435) {
                this.resetDecoder();
                this.StartPos = this.BufferPos - 4;
                this.sequence_header();
                this.next_start_code();
                start_code = this.Get_Bits(32);
                if (start_code == 440) {
                    this.group_of_pictures_header();
                    this.next_start_code();
                    start_code = this.Get_Bits(32);
                    if (start_code != 256) continue;
                    this.picture_header();
                    return 1;
                }
                if (start_code != 256) continue;
                this.picture_header();
                return 1;
            }
            if (this.viewGOP && start_code == 440) {
                this.StartPos = this.BufferPos - 4;
                this.group_of_pictures_header();
                this.next_start_code();
                start_code = this.Get_Bits(32);
                if (start_code != 256) continue;
                this.picture_header();
                return 1;
            }
            if (!this.viewGOP && start_code == 440) {
                if (this.DIRECTION) {
                    this.Flush_Bits(-40);
                }
                this.ERROR5 = true;
                continue;
            }
            if (!this.DIRECTION) continue;
            this.Flush_Bits(-40);
        }
    }

    private void next_start_code() {
        this.Flush_Bits(8 - (this.BitPos & 7) & 7);
        while (this.Show_Bits(24) != 1) {
            this.Flush_Bits(8);
        }
    }

    private void previous_start_code() {
        this.Flush_Bits(8 - (this.BitPos & 7) & 7);
        while (this.Show_Bits(24) != 1) {
            this.Flush_Bits(-8);
        }
    }

    private void sequence_header() {
        int i;
        this.horizontal_size = this.Get_Bits(12);
        this.vertical_size = this.Get_Bits(12);
        this.aspect_ratio_information = this.Get_Bits(4);
        this.frame_rate_code = this.Get_Bits(4);
        this.Get_Bits(18);
        this.Flush_Bits(1);
        this.Get_Bits(10);
        this.Get_Bits(1);
        this.load_intra_quantizer_matrix = this.Get_Bits(1);
        if (this.load_intra_quantizer_matrix > 0) {
            for (i = 0; i < 64; ++i) {
                this.intra_quantizer_matrix[MpvDecoder.scan[0][i]] = this.Get_Bits(8);
            }
        } else {
            System.arraycopy(default_intra_quantizer_matrix, 0, this.intra_quantizer_matrix, 0, 64);
        }
        if ((this.load_non_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            for (i = 0; i < 64; ++i) {
                this.non_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = this.Get_Bits(8);
            }
        } else {
            Arrays.fill(this.non_intra_quantizer_matrix, 16);
        }
        System.arraycopy(this.intra_quantizer_matrix, 0, this.chroma_intra_quantizer_matrix, 0, 64);
        System.arraycopy(this.non_intra_quantizer_matrix, 0, this.chroma_non_intra_quantizer_matrix, 0, 64);
        this.frame_rate = (float)frame_rate_Table[this.frame_rate_code];
        this.extension_and_user_data();
    }

    private void group_of_pictures_header() {
        this.Get_Bits(1);
        this.Get_Bits(5);
        this.Get_Bits(6);
        this.Flush_Bits(1);
        this.Get_Bits(6);
        this.Get_Bits(6);
        this.Get_Bits(1);
        this.Get_Bits(1);
        this.extension_and_user_data();
    }

    private void extension_and_user_data() {
        int code;
        this.next_start_code();
        while ((code = this.Show_Bits(32)) == 437 || code == 434) {
            if (code == 437) {
                this.Flush_Bits(32);
                int ext_ID = this.Get_Bits(4);
                switch (ext_ID) {
                    case 1: {
                        this.sequence_extension();
                        break;
                    }
                    case 2: {
                        this.sequence_display_extension();
                        break;
                    }
                    case 3: {
                        this.quant_matrix_extension();
                        break;
                    }
                    case 7: {
                        this.picture_display_extension();
                        break;
                    }
                    case 8: {
                        this.picture_coding_extension();
                        break;
                    }
                    case 4: {
                        this.copyright_extension();
                    }
                }
                this.next_start_code();
                continue;
            }
            this.Flush_Bits(32);
            this.next_start_code();
        }
    }

    private void picture_header() {
        this.temporal_reference = this.Get_Bits(10);
        this.picture_coding_type = this.Get_Bits(3);
        this.Get_Bits(16);
        if (this.picture_coding_type == 2 || this.picture_coding_type == 3) {
            this.Get_Bits(1);
            this.Get_Bits(3);
        }
        if (this.picture_coding_type == 3) {
            this.Get_Bits(1);
            this.Get_Bits(3);
        }
        this.extra_bit_information();
        this.extension_and_user_data();
    }

    private void sequence_extension() {
        this.profile_and_level_indication = this.Get_Bits(8);
        this.progressive_sequence = this.Get_Bits(1);
        this.chroma_format = this.Get_Bits(2);
        int horizontal_size_extension = this.Get_Bits(2);
        int vertical_size_extension = this.Get_Bits(2);
        this.Get_Bits(12);
        this.Flush_Bits(1);
        this.Get_Bits(8);
        this.Get_Bits(1);
        int frame_rate_extension_n = this.Get_Bits(2);
        int frame_rate_extension_d = this.Get_Bits(5);
        this.frame_rate = this.frame_rate * (float)(frame_rate_extension_n + 1) / (float)(frame_rate_extension_d + 1);
        this.horizontal_size = horizontal_size_extension << 12 | this.horizontal_size & 0xFFF;
        this.vertical_size = vertical_size_extension << 12 | this.vertical_size & 0xFFF;
    }

    private void sequence_display_extension() {
        this.video_format = this.Get_Bits(3);
        int color_description = this.Get_Bits(1);
        if (color_description > 0) {
            this.Get_Bits(8);
            this.Get_Bits(8);
            this.Get_Bits(8);
        }
        this.Get_Bits(14);
        this.Flush_Bits(1);
        this.Get_Bits(14);
    }

    private void quant_matrix_extension() {
        int i;
        this.load_intra_quantizer_matrix = this.Get_Bits(1);
        if (this.load_intra_quantizer_matrix > 0) {
            for (i = 0; i < 64; ++i) {
                int n = this.Get_Bits(8);
                this.intra_quantizer_matrix[MpvDecoder.scan[0][i]] = n;
                this.chroma_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = n;
            }
        }
        if ((this.load_non_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            for (i = 0; i < 64; ++i) {
                int n = this.Get_Bits(8);
                this.non_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = n;
                this.chroma_non_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = n;
            }
        }
        if ((this.load_chroma_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            for (i = 0; i < 64; ++i) {
                this.chroma_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = this.Get_Bits(8);
            }
        }
        if ((this.load_chroma_non_intra_quantizer_matrix = this.Get_Bits(1)) > 0) {
            for (i = 0; i < 64; ++i) {
                this.chroma_non_intra_quantizer_matrix[MpvDecoder.scan[0][i]] = this.Get_Bits(8);
            }
        }
    }

    private void picture_display_extension() {
        int[] frame_center_horizontal_offset = new int[3];
        int[] frame_center_vertical_offset = new int[3];
        int number_of_frame_center_offsets = this.progressive_sequence > 0 ? (this.repeat_first_field > 0 ? (this.top_field_first > 0 ? 3 : 2) : 1) : (this.picture_structure != 3 ? 1 : (this.repeat_first_field > 0 ? 3 : 2));
        for (int i = 0; i < number_of_frame_center_offsets; ++i) {
            frame_center_horizontal_offset[i] = this.Get_Bits(16);
            this.Flush_Bits(1);
            frame_center_vertical_offset[i] = this.Get_Bits(16);
            this.Flush_Bits(1);
        }
    }

    private void picture_coding_extension() {
        this.f_code[0][0] = this.Get_Bits(4);
        this.f_code[0][1] = this.Get_Bits(4);
        this.f_code[1][0] = this.Get_Bits(4);
        this.f_code[1][1] = this.Get_Bits(4);
        this.intra_dc_precision = this.Get_Bits(2);
        this.picture_structure = this.Get_Bits(2);
        this.top_field_first = this.Get_Bits(1);
        this.frame_pred_frame_dct = this.Get_Bits(1);
        this.concealment_motion_vectors = this.Get_Bits(1);
        this.q_scale_type = this.Get_Bits(1);
        this.intra_vlc_format = this.Get_Bits(1);
        this.alternate_scan = this.Get_Bits(1);
        this.repeat_first_field = this.Get_Bits(1);
        this.Get_Bits(1);
        this.progressive_frame = this.Get_Bits(1);
        int composite_display_flag = this.Get_Bits(1);
        if (composite_display_flag > 0) {
            this.Get_Bits(1);
            this.Get_Bits(3);
            this.Get_Bits(1);
            this.Get_Bits(7);
            this.Get_Bits(8);
        }
    }

    private void copyright_extension() {
        this.Get_Bits(1);
        this.Get_Bits(8);
        this.Get_Bits(1);
        this.Get_Bits(7);
        this.Flush_Bits(1);
        this.Get_Bits(20);
        this.Flush_Bits(1);
        this.Get_Bits(22);
        this.Flush_Bits(1);
        this.Get_Bits(22);
    }

    private void resetDecoder() {
        this.Fault_Flag = 0;
        this.picture_coding_type = 0;
        this.video_format = 5;
        this.progressive_sequence = 1;
        this.chroma_format = 1;
        this.profile_and_level_indication = 0;
        this.Second_Field = 0;
        this.intra_dc_precision = 0;
        this.picture_structure = 3;
        this.top_field_first = 0;
        this.frame_pred_frame_dct = 1;
        this.concealment_motion_vectors = 0;
        this.intra_vlc_format = 0;
        this.repeat_first_field = 0;
        this.progressive_frame = 1;
        this.q_scale_type = 0;
        this.quantizer_scale = 0;
        this.alternate_scan = 0;
    }

    private void InitialDecoder() {
        this.mb_width = this.horizontal_size + 15 >>> 4;
        this.mb_height = this.progressive_sequence > 0 ? this.vertical_size + 15 >>> 4 : this.vertical_size + 31 >>> 5 << 1;
        this.Coded_Picture_Width = this.mb_width << 4;
        this.Coded_Picture_Height = this.mb_height << 4;
        this.Chroma_Width = this.chroma_format == 3 ? this.Coded_Picture_Width : this.Coded_Picture_Width >> 1;
        this.block_count = ChromaFormat[this.chroma_format];
        if (this.picture_coding_type == 1) {
            this.resizePixels(this.Coded_Picture_Width, this.Coded_Picture_Height, this.horizontal_size, this.vertical_size);
        }
    }

    public void resizePixels(int cw, int ch, int hs, int vs) {
        this.Coded_Picture_Width = cw;
        this.Coded_Picture_Height = ch;
        this.horizontal_size = hs;
        this.vertical_size = vs;
        if (this.pixels.length != this.Coded_Picture_Width * this.Coded_Picture_Height) {
            this.pixels = new int[this.Coded_Picture_Width * this.Coded_Picture_Height];
        } else {
            Arrays.fill(this.pixels, 0);
        }
    }

    public void Decode_Picture() {
        if (this.picture_structure == 3 && this.Second_Field > 0) {
            this.Second_Field = 0;
        }
        this.Update_Picture_Buffers();
        this.picture_data();
        if (this.picture_structure != 3) {
            this.Second_Field ^= this.Second_Field;
        }
    }

    public void Update_Picture_Buffers() {
        for (int cc = 0; cc < 3; ++cc) {
            if (this.picture_coding_type == 3) {
                this.current_frame[cc] = this.auxframe[cc];
            } else {
                if (this.Second_Field < 1) {
                    byte tmp = this.forward_reference_frame[cc];
                    this.forward_reference_frame[cc] = this.backward_reference_frame[cc];
                    this.backward_reference_frame[cc] = tmp;
                }
                this.current_frame[cc] = this.backward_reference_frame[cc];
            }
            if (this.picture_structure != 2) continue;
            int n = cc;
            this.current_frame[n] = (byte)(this.current_frame[n] + (cc == 0 ? this.Coded_Picture_Width : this.Chroma_Width));
        }
    }

    public void picture_data() {
        int MBAmax = this.mb_width * this.mb_height;
        if (this.picture_structure != 3) {
            MBAmax >>= 1;
        }
        while (this.slice(MBAmax) >= 0) {
        }
    }

    public int slice_header() {
        int slice_vertical_position_extension = this.vertical_size > 2800 ? this.Get_Bits(3) : 0;
        int quantizer_scale_code = this.Get_Bits(5);
        int n = this.quantizer_scale = this.q_scale_type > 0 ? Non_Linear_quantizer_scale[quantizer_scale_code] : quantizer_scale_code << 1;
        if (this.Get_Bits(1) > 0) {
            this.Get_Bits(1);
            this.Get_Bits(1);
            this.Get_Bits(6);
            this.extra_bit_information();
        }
        return slice_vertical_position_extension;
    }

    public int extra_bit_information() {
        int Byte_Count = 0;
        while (this.Get_Bits(1) > 0) {
            this.Flush_Bits(8);
            ++Byte_Count;
        }
        return Byte_Count;
    }

    public int slice(int MBAmax) {
        int[] MBA = new int[]{0};
        int[] MBAinc = new int[]{0};
        int[] macroblock_type = new int[]{0};
        int[] motion_type = new int[]{0};
        int[] dct_type = new int[]{0};
        int ret = 0;
        int[] dc_dct_pred = new int[3];
        int[][][] PMV = new int[2][2][2];
        int[][] motion_vertical_field_select = new int[2][2];
        int[] dmvector = new int[2];
        ret = this.start_of_slice(MBA, MBAinc, dc_dct_pred, PMV);
        if (ret != 1) {
            return ret;
        }
        do {
            if (MBA[0] >= MBAmax) {
                return -1;
            }
            if (MBAinc[0] == 0) {
                if (this.Show_Bits(23) < 1 || this.Fault_Flag > 0) {
                    this.Fault_Flag = 0;
                    return 0;
                }
                MBAinc[0] = this.Get_macroblock_address_increment();
                if (this.Fault_Flag > 0) {
                    this.Fault_Flag = 0;
                    return 0;
                }
            }
            if (MBAinc[0] == 1) {
                if (this.decode_macroblock(macroblock_type, motion_type, dct_type, PMV, dc_dct_pred, motion_vertical_field_select, dmvector) < 1) {
                    this.Fault_Flag = 0;
                    return 0;
                }
            } else {
                this.skipped_macroblock(dc_dct_pred, PMV, motion_type, motion_vertical_field_select, macroblock_type);
            }
            this.motion_compensation(MBA, macroblock_type, motion_type, PMV, motion_vertical_field_select, dmvector, dct_type);
            MBA[0] = MBA[0] + 1;
            MBAinc[0] = MBAinc[0] - 1;
        } while (MBA[0] < MBAmax);
        return -1;
    }

    public void skipped_macroblock(int[] dc_dct_pred, int[][][] PMV, int[] motion_type, int[][] motion_vertical_field_select, int[] macroblock_type) {
        for (int comp = 0; comp < this.block_count; ++comp) {
            this.Clear_Block(comp);
        }
        dc_dct_pred[2] = 0;
        dc_dct_pred[1] = 0;
        dc_dct_pred[0] = 0;
        if (this.picture_coding_type == 2) {
            PMV[1][0][1] = 0;
            PMV[1][0][0] = 0;
            PMV[0][0][1] = 0;
            PMV[0][0][0] = 0;
        }
        if (this.picture_structure == 3) {
            motion_type[0] = 2;
        } else {
            motion_type[0] = 1;
            int n = this.picture_structure == 2 ? 1 : 0;
            motion_vertical_field_select[0][1] = n;
            motion_vertical_field_select[0][0] = n;
        }
        macroblock_type[0] = macroblock_type[0] & 0xFFFFFFFE;
    }

    public int decode_macroblock(int[] macroblock_type, int[] motion_type, int[] dct_type, int[][][] PMV, int[] dc_dct_pred, int[][] motion_vertical_field_select, int[] dmvector) {
        int coded_block_pattern;
        int[] motion_vector_count = new int[]{0};
        int[] mv_format = new int[]{0};
        int[] dmv = new int[]{0};
        int[] mvscale = new int[]{0};
        this.macroblock_modes(macroblock_type, motion_type, motion_vector_count, mv_format, dmv, mvscale, dct_type);
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((macroblock_type[0] & 0x10) > 0) {
            int quantizer_scale_code = this.Get_Bits(5);
            int n = this.quantizer_scale = this.q_scale_type > 0 ? Non_Linear_quantizer_scale[quantizer_scale_code] : quantizer_scale_code << 1;
        }
        if ((macroblock_type[0] & 8) > 0 || (macroblock_type[0] & 1) > 0 && this.concealment_motion_vectors > 0) {
            this.motion_vectors(PMV, dmvector, motion_vertical_field_select, 0, motion_vector_count, mv_format, this.f_code[0][0] - 1, this.f_code[0][1] - 1, dmv, mvscale);
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((macroblock_type[0] & 4) > 0) {
            this.motion_vectors(PMV, dmvector, motion_vertical_field_select, 1, motion_vector_count, mv_format, this.f_code[1][0] - 1, this.f_code[1][1] - 1, new int[1], mvscale);
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        if ((macroblock_type[0] & 1) > 0 && this.concealment_motion_vectors > 0) {
            this.Flush_Bits(1);
        }
        if ((macroblock_type[0] & 2) > 0) {
            coded_block_pattern = this.Get_coded_block_pattern();
            if (this.chroma_format == 2) {
                coded_block_pattern = coded_block_pattern << 2 | this.Get_Bits(2);
            } else if (this.chroma_format == 3) {
                coded_block_pattern = coded_block_pattern << 6 | this.Get_Bits(6);
            }
        } else {
            int n = coded_block_pattern = (macroblock_type[0] & 1) > 0 ? (1 << this.block_count) - 1 : 0;
        }
        if (this.Fault_Flag > 0) {
            return 0;
        }
        for (int comp = 0; comp < this.block_count; ++comp) {
            this.Clear_Block(comp);
            if ((coded_block_pattern & 1 << this.block_count - 1 - comp) <= 0) continue;
            if ((macroblock_type[0] & 1) > 0) {
                this.Decode_MPEG2_Intra_Block(comp, dc_dct_pred);
            } else {
                this.Decode_MPEG2_Non_Intra_Block(comp);
            }
            if (this.Fault_Flag <= 0) continue;
            return 0;
        }
        if ((macroblock_type[0] & 1) < 1) {
            dc_dct_pred[2] = 0;
            dc_dct_pred[1] = 0;
            dc_dct_pred[0] = 0;
        }
        if ((macroblock_type[0] & 1) > 0 && this.concealment_motion_vectors < 1) {
            PMV[1][0][1] = 0;
            PMV[1][0][0] = 0;
            PMV[0][0][1] = 0;
            PMV[0][0][0] = 0;
            PMV[1][1][1] = 0;
            PMV[1][1][0] = 0;
            PMV[0][1][1] = 0;
            PMV[0][1][0] = 0;
        }
        if (this.picture_coding_type == 2 && (macroblock_type[0] & 9) < 1) {
            PMV[1][0][1] = 0;
            PMV[1][0][0] = 0;
            PMV[0][0][1] = 0;
            PMV[0][0][0] = 0;
            if (this.picture_structure == 3) {
                motion_type[0] = 2;
            } else {
                motion_type[0] = 1;
                motion_vertical_field_select[0][0] = this.picture_structure == 2 ? 1 : 0;
            }
        }
        return 1;
    }

    private void Decode_MPEG2_Intra_Block(int comp, int[] dc_dct_pred) {
        int val = 0;
        short[] bp = this.block[comp];
        int[] qmat = comp < 4 || this.chroma_format == 1 ? this.intra_quantizer_matrix : this.chroma_intra_quantizer_matrix;
        switch (cc_table[comp]) {
            case 0: {
                val = dc_dct_pred[0] = dc_dct_pred[0] + this.Get_Luma_DC_dct_diff();
                break;
            }
            case 1: {
                val = dc_dct_pred[1] = dc_dct_pred[1] + this.Get_Chroma_DC_dct_diff();
                break;
            }
            case 2: {
                val = dc_dct_pred[2] = dc_dct_pred[2] + this.Get_Chroma_DC_dct_diff();
            }
        }
        bp[0] = (short)(val << 3 - this.intra_dc_precision);
        int i = 1;
        while (true) {
            int sign;
            byte[] tab;
            int code;
            if ((code = this.Show_Bits(16)) >= 16384 && this.intra_vlc_format < 1) {
                tab = DCTtabnext[(code >> 12) - 4];
            } else if (code >= 1024) {
                tab = this.intra_vlc_format > 0 ? DCTtab0a[(code >> 8) - 4] : DCTtab0[(code >> 8) - 4];
            } else if (code >= 512) {
                tab = this.intra_vlc_format > 0 ? DCTtab1a[(code >> 6) - 8] : DCTtab1[(code >> 6) - 8];
            } else if (code >= 256) {
                tab = DCTtab2[(code >> 4) - 16];
            } else if (code >= 128) {
                tab = DCTtab3[(code >> 3) - 16];
            } else if (code >= 64) {
                tab = DCTtab4[(code >> 2) - 16];
            } else if (code >= 32) {
                tab = DCTtab5[(code >> 1) - 16];
            } else if (code >= 16) {
                tab = DCTtab6[code - 16];
            } else {
                this.Fault_Flag = 1;
                return;
            }
            this.Flush_Bits(tab[2]);
            if (tab[0] < 64) {
                i += tab[0];
                val = tab[1];
                sign = this.Get_Bits(1);
            } else {
                if (tab[0] == 64) {
                    return;
                }
                if (this.profile_and_level_indication == 0) {
                    i += this.Get_Bits(6);
                    val = this.Get_Bits(8);
                    if (val == 0) {
                        val = this.Get_Bits(8);
                    } else if (val == 128) {
                        val = this.Get_Bits(8) - 128;
                    } else if (val > 128) {
                        val -= 256;
                    }
                    sign = 0;
                } else {
                    i += this.Get_Bits(6);
                    val = this.Get_Bits(12);
                    sign = val >= 2048 ? 1 : 0;
                    if (sign > 0) {
                        val = 4096 - val;
                    }
                }
            }
            i = i > 63 ? 63 : i;
            byte j = scan[this.alternate_scan][i];
            val = val * this.quantizer_scale * qmat[j] >> 4;
            bp[j] = (short)(sign > 0 ? -val : val);
            ++i;
        }
    }

    private void Decode_MPEG2_Non_Intra_Block(int comp) {
        short[] bp = this.block[comp];
        int[] qmat = comp < 4 || this.chroma_format == 1 ? this.non_intra_quantizer_matrix : this.chroma_non_intra_quantizer_matrix;
        int i = 0;
        while (true) {
            int sign;
            int val;
            byte[] tab;
            int code;
            if ((code = this.Show_Bits(16)) >= 16384) {
                tab = i == 0 ? DCTtabfirst[(code >> 12) - 4] : DCTtabnext[(code >> 12) - 4];
            } else if (code >= 1024) {
                tab = DCTtab0[(code >> 8) - 4];
            } else if (code >= 512) {
                tab = DCTtab1[(code >> 6) - 8];
            } else if (code >= 256) {
                tab = DCTtab2[(code >> 4) - 16];
            } else if (code >= 128) {
                tab = DCTtab3[(code >> 3) - 16];
            } else if (code >= 64) {
                tab = DCTtab4[(code >> 2) - 16];
            } else if (code >= 32) {
                tab = DCTtab5[(code >> 1) - 16];
            } else if (code >= 16) {
                tab = DCTtab6[code - 16];
            } else {
                this.Fault_Flag = 1;
                return;
            }
            this.Flush_Bits(tab[2]);
            if (tab[0] < 64) {
                i += tab[0];
                val = tab[1];
                sign = this.Get_Bits(1);
            } else {
                if (tab[0] == 64) {
                    return;
                }
                i += this.Get_Bits(6);
                val = this.Get_Bits(12);
                sign = val >= 2048 ? 1 : 0;
                if (sign > 0) {
                    val = 4096 - val;
                }
            }
            byte j = scan[this.alternate_scan][i];
            val = ((val << 1) + 1) * this.quantizer_scale * qmat[j] >> 5;
            bp[j] = (short)(sign > 0 ? -val : val);
            ++i;
        }
    }

    private int Get_Luma_DC_dct_diff() {
        int dct_diff;
        byte size;
        int code = this.Show_Bits(5);
        if (code < 31) {
            size = DClumtab0[code][0];
            this.Flush_Bits(DClumtab0[code][1]);
        } else {
            code = this.Show_Bits(9) - 496;
            size = DClumtab1[code][0];
            this.Flush_Bits(DClumtab1[code][1]);
        }
        if (size == 0) {
            dct_diff = 0;
        } else {
            dct_diff = this.Get_Bits(size);
            if ((dct_diff & 1 << size - 1) == 0) {
                dct_diff -= (1 << size) - 1;
            }
        }
        return dct_diff;
    }

    private int Get_Chroma_DC_dct_diff() {
        int dct_diff;
        byte size;
        int code = this.Show_Bits(5);
        if (code < 31) {
            size = DCchromtab0[code][0];
            this.Flush_Bits(DCchromtab0[code][1]);
        } else {
            code = this.Show_Bits(10) - 992;
            size = DCchromtab1[code][0];
            this.Flush_Bits(DCchromtab1[code][1]);
        }
        if (size == 0) {
            dct_diff = 0;
        } else {
            dct_diff = this.Get_Bits(size);
            if ((dct_diff & 1 << size - 1) == 0) {
                dct_diff -= (1 << size) - 1;
            }
        }
        return dct_diff;
    }

    private int Get_coded_block_pattern() {
        int code = this.Show_Bits(9);
        if (code >= 128) {
            this.Flush_Bits(CBPtab0[code >>= 4][1]);
            return CBPtab0[code][0];
        }
        if (code >= 8) {
            this.Flush_Bits(CBPtab1[code >>= 1][1]);
            return CBPtab1[code][0];
        }
        if (code < 1) {
            this.Fault_Flag = 3;
            return 0;
        }
        this.Flush_Bits(CBPtab2[code][1]);
        return CBPtab2[code][0];
    }

    private int start_of_slice(int[] MBA, int[] MBAinc, int[] dc_dct_pred, int[][][] PMV) {
        this.next_start_code();
        int code = this.Get_Bits(32);
        if (code < 257 || code > 431) {
            this.Fault_Flag = 10;
            return -1;
        }
        int slice_vert_pos_ext = this.slice_header();
        MBAinc[0] = this.Get_macroblock_address_increment();
        if (this.Fault_Flag > 0) {
            return -1;
        }
        MBA[0] = ((slice_vert_pos_ext << 7) + (code & 0xFF) - 1) * this.mb_width + MBAinc[0] - 1;
        MBAinc[0] = 1;
        dc_dct_pred[2] = 0;
        dc_dct_pred[1] = 0;
        dc_dct_pred[0] = 0;
        PMV[1][0][1] = 0;
        PMV[1][0][0] = 0;
        PMV[0][0][1] = 0;
        PMV[0][0][0] = 0;
        PMV[1][1][1] = 0;
        PMV[1][1][0] = 0;
        PMV[0][1][1] = 0;
        PMV[0][1][0] = 0;
        return 1;
    }

    private int Get_macroblock_address_increment() {
        int code = 0;
        int val = 0;
        while ((code = this.Show_Bits(11)) < 24) {
            if (code != 15) {
                if (code == 8) {
                    val += 33;
                } else {
                    this.Fault_Flag = 4;
                    return 1;
                }
            }
            this.Flush_Bits(11);
        }
        if (code >= 1024) {
            this.Flush_Bits(1);
            return val + 1;
        }
        if (code >= 128) {
            this.Flush_Bits(MBAtab1[code >>= 6][1]);
            return val + MBAtab1[code][0];
        }
        this.Flush_Bits(MBAtab2[code -= 24][1]);
        return val + MBAtab2[code][0];
    }

    private void motion_vectors(int[][][] PMV, int[] dmvector, int[][] motion_vertical_field_select, int s, int[] motion_vector_count, int[] mv_format, int h_r_size, int v_r_size, int[] dmv, int[] mvscale) {
        if (motion_vector_count[0] == 1) {
            if (mv_format[0] == 0 && dmv[0] < 1) {
                int n = this.Get_Bits(1);
                motion_vertical_field_select[0][s] = n;
                motion_vertical_field_select[1][s] = n;
            }
            this.motion_vector(PMV[0][s], dmvector, h_r_size, v_r_size, dmv, mvscale, 0);
            PMV[1][s][0] = PMV[0][s][0];
            PMV[1][s][1] = PMV[0][s][1];
        } else {
            motion_vertical_field_select[0][s] = this.Get_Bits(1);
            this.motion_vector(PMV[0][s], dmvector, h_r_size, v_r_size, dmv, mvscale, 0);
            motion_vertical_field_select[1][s] = this.Get_Bits(1);
            this.motion_vector(PMV[1][s], dmvector, h_r_size, v_r_size, dmv, mvscale, 0);
        }
    }

    private void motion_vector(int[] PMV, int[] dmvector, int h_r_size, int v_r_size, int[] dmv, int[] mvscale, int full_pel_vector) {
        int motion_code = this.Get_motion_code();
        int motion_residual = h_r_size != 0 && motion_code != 0 ? this.Get_Bits(h_r_size) : 0;
        MpvDecoder.decode_motion_vector(PMV[0], h_r_size, motion_code, motion_residual, full_pel_vector);
        if (dmv[0] > 0) {
            dmvector[0] = this.Get_dmvector();
        }
        motion_code = this.Get_motion_code();
        int n = motion_residual = v_r_size != 0 && motion_code != 0 ? this.Get_Bits(v_r_size) : 0;
        if (mvscale[0] > 0) {
            PMV[1] = PMV[1] >> 1;
        }
        MpvDecoder.decode_motion_vector(PMV[1], v_r_size, motion_code, motion_residual, full_pel_vector);
        if (mvscale[0] > 0) {
            PMV[1] = PMV[1] << 1;
        }
        if (dmv[0] > 0) {
            dmvector[1] = this.Get_dmvector();
        }
    }

    private static void decode_motion_vector(int pred, int r_size, int motion_code, int motion_residual, int full_pel_vector) {
        int vec;
        int lim = 16 << r_size;
        int n = vec = full_pel_vector > 0 ? pred >> 1 : pred;
        if (motion_code > 0) {
            if ((vec += (motion_code - 1 << r_size) + motion_residual + 1) >= lim) {
                vec -= lim + lim;
            }
        } else if (motion_code < 0 && (vec -= (-motion_code - 1 << r_size) + motion_residual + 1) < -lim) {
            vec += lim + lim;
        }
        pred = full_pel_vector > 0 ? vec << 1 : vec;
    }

    private void motion_compensation(int[] MBA, int[] macroblock_type, int[] motion_type, int[][][] PMV, int[][] motion_vertical_field_select, int[] dmvector, int[] dct_type) {
        int bx = MBA[0] % this.mb_width << 4;
        int by = MBA[0] / this.mb_width << 4;
        for (int comp = 0; comp < this.block_count; ++comp) {
            if (this.FAST) {
                MpvDecoder.IDCT_referenceFAST(this.block[comp]);
            } else {
                MpvDecoder.IDCT_reference1(this.block[comp]);
            }
            this.Add_Block(comp, bx, by, dct_type, (macroblock_type[0] & 1) == 0);
        }
    }

    private static void IDCT_referenceFAST(short[] block) {
        long tmp0 = ref_dct_matrix_i[0] * block[0];
        long partial_product = (long)ref_dct_matrix_i[0] * tmp0;
        int v = (int)(partial_product >> 32);
        block[0] = idct_clip_table[512 + v];
        Arrays.fill(block, block[0]);
    }

    private static void IDCT_reference1(short[] block) {
        long[] tmp = new long[64];
        int i8 = 0;
        try {
            int j;
            int i;
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 8; ++j) {
                    tmp[i8 + j] = ref_dct_matrix_i[0 + j] * block[i8] + ref_dct_matrix_i[8 + j] * block[i8 + 1] + ref_dct_matrix_i[16 + j] * block[i8 + 2] + ref_dct_matrix_i[24 + j] * block[i8 + 3] + ref_dct_matrix_i[32 + j] * block[i8 + 4] + ref_dct_matrix_i[40 + j] * block[i8 + 5] + ref_dct_matrix_i[48 + j] * block[i8 + 6] + ref_dct_matrix_i[56 + j] * block[i8 + 7];
                }
                i8 += 8;
            }
            for (j = 0; j < 8; ++j) {
                for (i = 0; i < 8; ++i) {
                    long partial_product = (long)ref_dct_matrix_i[i] * tmp[j] + (long)ref_dct_matrix_i[8 + i] * tmp[8 + j] + (long)ref_dct_matrix_i[16 + i] * tmp[16 + j] + (long)ref_dct_matrix_i[24 + i] * tmp[24 + j] + (long)ref_dct_matrix_i[32 + i] * tmp[32 + j] + (long)ref_dct_matrix_i[40 + i] * tmp[40 + j] + (long)ref_dct_matrix_i[48 + i] * tmp[48 + j] + (long)ref_dct_matrix_i[56 + i] * tmp[56 + j];
                    int v = (int)(partial_product >> 32);
                    block[8 * i + j] = idct_clip_table[512 + v];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void Add_Block(int comp, int bx, int by, int[] dct_type, boolean addflag) {
        int cc_value;
        int iincr;
        int rfp;
        short[] Block_Ptr = this.block[comp];
        byte cc = cc_table[comp];
        if (cc == 0) {
            if (this.picture_structure == 3) {
                if (dct_type[0] > 0) {
                    rfp = this.current_frame[0] + this.Coded_Picture_Width * (by + ((comp & 2) >> 1)) + bx + ((comp & 1) << 3);
                    iincr = (this.Coded_Picture_Width << 1) - 8;
                } else {
                    rfp = this.current_frame[0] + this.Coded_Picture_Width * (by + ((comp & 2) << 2)) + bx + ((comp & 1) << 3);
                    iincr = this.Coded_Picture_Width - 8;
                }
            } else {
                rfp = this.current_frame[0] + (this.Coded_Picture_Width << 1) * (by + ((comp & 2) << 2)) + bx + ((comp & 1) << 3);
                iincr = (this.Coded_Picture_Width << 1) - 8;
            }
        } else {
            if (this.chroma_format != 3) {
                bx >>= 1;
            }
            if (this.picture_structure == 3) {
                if (dct_type[0] > 0 && this.chroma_format != 1) {
                    rfp = this.current_frame[cc] + this.Chroma_Width * (by + ((comp & 2) >> 1)) + bx + (comp & 8);
                    iincr = (this.Chroma_Width << 1) - 8;
                } else {
                    rfp = this.current_frame[cc] + this.Chroma_Width * (by + ((comp & 2) << 2)) + bx + (comp & 8);
                    iincr = this.Chroma_Width - 8;
                }
            } else {
                rfp = this.current_frame[cc] + (this.Chroma_Width << 1) * (by + ((comp & 2) << 2)) + bx + (comp & 8);
                iincr = (this.Chroma_Width << 1) - 8;
            }
        }
        iincr += 8;
        int gain = this.picture_coding_type == 1 ? 128 : 0;
        gain += this.YGain;
        int chroma_value_444 = this.chroma_format == 3 ? 1 : 0;
        int chroma_value_420 = this.chroma_format != 1 ? 1 : 0;
        int n = cc_value = cc == 1 ? 8 : 0;
        if (cc == 0) {
            int y = 8;
            while (--y >= 0) {
                int tmp1 = rfp + y * iincr;
                int tmp2 = y << 3;
                int x = 8;
                while (--x >= 0) {
                    int pPos = x + tmp1;
                    int val = Block_Ptr[x + tmp2] + gain;
                    val = val < 0 ? 0 : (val > 255 ? 255 : val);
                    int n2 = pPos;
                    this.pixels[n2] = this.pixels[n2] | val << 16;
                }
            }
        } else {
            if (this.chroma_format != 3) {
                rfp <<= 1;
                iincr <<= 1;
            }
            for (int y = 0; y < 16; ++y) {
                int tmp1 = rfp + (y >> chroma_value_420) * iincr;
                int tmp3 = y >> 1;
                int tmp2 = (this.chroma_format != 1 ? tmp3 : ((y & 1) == 0 ? tmp3 & ~dct_type[0] : tmp3 | dct_type[0])) << 3;
                for (int x = 0; x < 16; ++x) {
                    int pPos = (x >> chroma_value_444) + tmp1;
                    int val = 128 + Block_Ptr[(x >> 1) + tmp2];
                    val = val < 0 ? 0 : (val > 255 ? 255 : val);
                    int n3 = pPos;
                    this.pixels[n3] = this.pixels[n3] | val << cc_value;
                    x += chroma_value_444;
                }
                y += chroma_value_420;
            }
        }
    }

    private void macroblock_modes(int[] pmacroblock_type, int[] pmotion_type, int[] pmotion_vector_count, int[] pmv_format, int[] pdmv, int[] pmvscale, int[] pdct_type) {
        int mv_format;
        int motion_vector_count;
        int motion_type = 0;
        int macroblock_type = this.Get_macroblock_type();
        if (this.Fault_Flag > 0) {
            return;
        }
        if ((macroblock_type & 0xC) > 0) {
            motion_type = this.picture_structure == 3 ? (this.frame_pred_frame_dct > 0 ? 2 : this.Get_Bits(2)) : this.Get_Bits(2);
        } else if ((macroblock_type & 1) > 0 && this.concealment_motion_vectors > 0) {
            int n = motion_type = this.picture_structure == 3 ? 2 : 1;
        }
        if (this.picture_structure == 3) {
            motion_vector_count = motion_type == 1 ? 2 : 1;
            mv_format = motion_type == 2 ? 1 : 0;
        } else {
            motion_vector_count = motion_type == 2 ? 2 : 1;
            mv_format = 0;
        }
        int dmv = motion_type == 3 ? 1 : 0;
        int mvscale = mv_format == 0 && this.picture_structure == 3 ? 1 : 0;
        int dct_type = this.picture_structure == 3 && this.frame_pred_frame_dct < 1 && (macroblock_type & 3) > 0 ? this.Get_Bits(1) : 0;
        pmacroblock_type[0] = macroblock_type;
        pmotion_type[0] = motion_type;
        pmotion_vector_count[0] = motion_vector_count;
        pmv_format[0] = mv_format;
        pdmv[0] = dmv;
        pmvscale[0] = mvscale;
        pdct_type[0] = dct_type;
    }

    private int Get_macroblock_type() {
        int macroblock_type = 0;
        switch (this.picture_coding_type) {
            case 1: {
                macroblock_type = this.Get_I_macroblock_type();
                break;
            }
            case 2: {
                macroblock_type = this.Get_P_macroblock_type();
                break;
            }
            case 3: {
                macroblock_type = this.Get_B_macroblock_type();
            }
        }
        return macroblock_type;
    }

    private int Get_I_macroblock_type() {
        if (this.Get_Bits(1) > 0) {
            return 1;
        }
        if (this.Get_Bits(1) < 1) {
            this.Fault_Flag = 2;
        }
        return 17;
    }

    private int Get_P_macroblock_type() {
        int code = this.Show_Bits(6);
        if (code >= 8) {
            this.Flush_Bits(PMBtab0[code >>= 3][1]);
            return PMBtab0[code][0];
        }
        if (code == 0) {
            this.Fault_Flag = 2;
            return 0;
        }
        this.Flush_Bits(PMBtab1[code][1]);
        return PMBtab1[code][0];
    }

    private int Get_B_macroblock_type() {
        int code = this.Show_Bits(6);
        if (code >= 8) {
            this.Flush_Bits(BMBtab0[code >>= 2][1]);
            return BMBtab0[code][0];
        }
        if (code == 0) {
            this.Fault_Flag = 2;
            return 0;
        }
        this.Flush_Bits(BMBtab1[code][1]);
        return BMBtab1[code][0];
    }

    private int Get_motion_code() {
        if (this.Get_Bits(1) > 0) {
            return 0;
        }
        int code = this.Show_Bits(9);
        if (code >= 64) {
            this.Flush_Bits(MVtab0[code >>= 6][1]);
            return this.Get_Bits(1) > 0 ? -MVtab0[code][0] : MVtab0[code][0];
        }
        if (code >= 24) {
            this.Flush_Bits(MVtab1[code >>= 3][1]);
            return this.Get_Bits(1) > 0 ? -MVtab1[code][0] : MVtab1[code][0];
        }
        if ((code -= 12) < 0) {
            this.Fault_Flag = 10;
            return 0;
        }
        this.Flush_Bits(MVtab2[code][1]);
        return this.Get_Bits(1) > 0 ? -MVtab2[code][0] : MVtab2[code][0];
    }

    private int Get_dmvector() {
        if (this.Get_Bits(1) > 0) {
            return this.Get_Bits(1) > 0 ? -1 : 1;
        }
        return 0;
    }

    private int YUVtoRGB(int YUV) {
        int T = 255;
        int Y = 0xFF & YUV >>> 16;
        int Cb = 0xFF & YUV >>> 8;
        int Cr = 0xFF & YUV;
        if (Y == 0) {
            return 0;
        }
        int R = (int)((float)Y + 1.402f * (float)(Cr - 128));
        int G = (int)((double)Y - 0.34414 * (double)(Cb - 128) - 0.71414 * (double)(Cr - 128));
        int B = (int)((double)Y + 1.722 * (double)(Cb - 128));
        int n = R < 0 ? 0 : (R = R > 255 ? 255 : R);
        int n2 = G < 0 ? 0 : (G = G > 255 ? 255 : G);
        B = B < 0 ? 0 : (B > 255 ? 255 : B);
        return 0xFF000000 | R << 16 | G << 8 | B;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getWidth() {
        return this.horizontal_size;
    }

    public int getHeight() {
        return this.vertical_size;
    }

    public int getErrors() {
        return 0 | (this.ERROR1 ? 1 : 0) | (this.ERROR2 ? 2 : 0) | (this.ERROR3 ? 4 : 0) | (this.ERROR4 ? 8 : 0) | (this.ERROR5 ? 16 : 0) | (this.ERROR6 ? 32 : 0);
    }

    public long decodeArray(byte[] array, boolean direction, boolean _viewGOP, boolean fast, int yGain) {
        return this.decodeArray(array, 0, direction, _viewGOP, fast, yGain, false);
    }

    public long decodeArray(byte[] array, boolean direction, boolean _viewGOP, boolean fast, int yGain, boolean silent) {
        return this.decodeArray(array, 0, direction, _viewGOP, fast, yGain, silent);
    }

    public long decodeArray(byte[] array, int start_position, boolean direction, boolean _viewGOP, boolean fast, int yGain, boolean silent) {
        this.FAST = fast;
        this.DIRECTION = direction;
        this.YGain = yGain;
        this.ERROR1 = false;
        this.ERROR2 = false;
        this.ERROR3 = false;
        this.ERROR4 = false;
        this.ERROR5 = false;
        this.ERROR6 = false;
        Arrays.fill(this.LastPosVal, -1);
        this.buf = array;
        this.BufferPos = start_position;
        this.BitPos = this.BufferPos << 3;
        this.StartPos = this.BufferPos;
        this.viewGOP = _viewGOP;
        if (this.DIRECTION) {
            this.BufferPos = this.buf.length - 4;
            this.StartPos = this.BufferPos;
            this.BitPos = this.BufferPos << 3;
        }
        try {
            while (this.BufferPos < this.buf.length && this.BufferPos >= 0) {
                this.ERROR_CODE1 = this.extern_Get_Hdr();
                if (this.ERROR_CODE1 == 1) {
                    if (this.picture_coding_type != 1) {
                        this.BufferPos += 2048;
                        continue;
                    }
                    this.InitialDecoder();
                    this.Decode_Picture();
                    return this.StartPos;
                }
                if (this.ERROR_CODE1 == 2) {
                    return 0L;
                }
                ++this.BufferPos;
            }
            this.ERROR2 = true;
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.ERROR1 = true;
        }
        catch (Error ee) {
            this.ERROR1 = true;
            this.ERROR6 = ee.toString().indexOf("OutOfMemory") > 0;
        }
        return 0L;
    }

    public BufferedImage getImage() {
        return this.getImage(this.getWidth(), this.getHeight());
    }

    public BufferedImage getImage(int w, int h) {
        int[] pix = new int[w * h];
        for (int y = 0; y < h; ++y) {
            int oY = this.getWidth() * (y * this.getHeight() / h);
            for (int x = 0; x < w; ++x) {
                int oX = x * this.getWidth() / w;
                pix[x + y * w] = this.YUVtoRGB(this.pixels[oX + oY]);
            }
        }
        BufferedImage image = new BufferedImage(w, h, 1);
        image.setRGB(0, 0, w, h, pix, 0, w);
        return image;
    }

    /*
     * Opcode count of 18254 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                MpvDecoder.ref_dct_matrix_i[i * 8 + j] = Math.round(ref_dct_matrix[i][j] * 65536.0f);
            }
        }
        idct_clip_table = new short[]{-256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -256, -255, -254, -253, -252, -251, -250, -249, -248, -247, -246, -245, -244, -243, -242, -241, -240, -239, -238, -237, -236, -235, -234, -233, -232, -231, -230, -229, -228, -227, -226, -225, -224, -223, -222, -221, -220, -219, -218, -217, -216, -215, -214, -213, -212, -211, -210, -209, -208, -207, -206, -205, -204, -203, -202, -201, -200, -199, -198, -197, -196, -195, -194, -193, -192, -191, -190, -189, -188, -187, -186, -185, -184, -183, -182, -181, -180, -179, -178, -177, -176, -175, -174, -173, -172, -171, -170, -169, -168, -167, -166, -165, -164, -163, -162, -161, -160, -159, -158, -157, -156, -155, -154, -153, -152, -151, -150, -149, -148, -147, -146, -145, -144, -143, -142, -141, -140, -139, -138, -137, -136, -135, -134, -133, -132, -131, -130, -129, -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        cc_table = new byte[]{0, 0, 0, 0, 1, 2, 1, 2, 1, 2, 1, 2};
        ChromaFormat = new int[]{0, 6, 8, 12};
        Non_Linear_quantizer_scale = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 12, 14, 16, 18, 20, 22, 24, 28, 32, 36, 40, 44, 48, 52, 56, 64, 72, 80, 88, 96, 104, 112};
        MBAtab1 = new byte[][]{{-1, 0}, {-1, 0}, {7, 5}, {6, 5}, {5, 4}, {5, 4}, {4, 4}, {4, 4}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {2, 3}, {2, 3}, {2, 3}, {2, 3}};
        MBAtab2 = new byte[][]{{33, 11}, {32, 11}, {31, 11}, {30, 11}, {29, 11}, {28, 11}, {27, 11}, {26, 11}, {25, 11}, {24, 11}, {23, 11}, {22, 11}, {21, 10}, {21, 10}, {20, 10}, {20, 10}, {19, 10}, {19, 10}, {18, 10}, {18, 10}, {17, 10}, {17, 10}, {16, 10}, {16, 10}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}};
        default_intra_quantizer_matrix = new int[]{8, 16, 19, 22, 26, 27, 29, 34, 16, 16, 22, 24, 27, 29, 34, 37, 19, 22, 26, 27, 29, 34, 34, 38, 22, 22, 26, 27, 29, 34, 37, 40, 22, 26, 27, 29, 32, 35, 40, 48, 26, 27, 29, 32, 35, 40, 48, 58, 26, 27, 29, 34, 38, 46, 56, 69, 27, 29, 35, 38, 46, 56, 69, 83};
        scan = new byte[][]{{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63}, {0, 8, 16, 24, 1, 9, 2, 10, 17, 25, 32, 40, 48, 56, 57, 49, 41, 33, 26, 18, 3, 11, 4, 12, 19, 27, 34, 42, 50, 58, 35, 43, 51, 59, 20, 28, 5, 13, 6, 14, 21, 29, 36, 44, 52, 60, 37, 45, 53, 61, 22, 30, 7, 15, 23, 31, 38, 46, 54, 62, 39, 47, 55, 63}};
        DCTtab0 = new byte[][]{{65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {2, 2, 7}, {2, 2, 7}, {9, 1, 7}, {9, 1, 7}, {0, 4, 7}, {0, 4, 7}, {8, 1, 7}, {8, 1, 7}, {7, 1, 6}, {7, 1, 6}, {7, 1, 6}, {7, 1, 6}, {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {13, 1, 8}, {0, 6, 8}, {12, 1, 8}, {11, 1, 8}, {3, 2, 8}, {1, 3, 8}, {0, 5, 8}, {10, 1, 8}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}};
        DCTtab0a = new byte[][]{{65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {7, 1, 7}, {7, 1, 7}, {8, 1, 7}, {8, 1, 7}, {6, 1, 7}, {6, 1, 7}, {2, 2, 7}, {2, 2, 7}, {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, {4, 1, 6}, {4, 1, 6}, {4, 1, 6}, {4, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {1, 5, 8}, {11, 1, 8}, {0, 11, 8}, {0, 10, 8}, {13, 1, 8}, {12, 1, 8}, {3, 2, 8}, {1, 4, 8}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {9, 1, 7}, {9, 1, 7}, {1, 3, 7}, {1, 3, 7}, {10, 1, 7}, {10, 1, 7}, {0, 8, 7}, {0, 8, 7}, {0, 9, 7}, {0, 9, 7}, {0, 12, 8}, {0, 13, 8}, {2, 3, 8}, {4, 2, 8}, {0, 14, 8}, {0, 15, 8}};
        DCTtab1 = new byte[][]{{16, 1, 10}, {5, 2, 10}, {0, 7, 10}, {2, 3, 10}, {1, 4, 10}, {15, 1, 10}, {14, 1, 10}, {4, 2, 10}};
        DCTtab1a = new byte[][]{{5, 2, 9}, {5, 2, 9}, {14, 1, 9}, {14, 1, 9}, {2, 4, 10}, {16, 1, 10}, {15, 1, 9}, {15, 1, 9}};
        DCTtab2 = new byte[][]{{0, 11, 12}, {8, 2, 12}, {4, 3, 12}, {0, 10, 12}, {2, 4, 12}, {7, 2, 12}, {21, 1, 12}, {20, 1, 12}, {0, 9, 12}, {19, 1, 12}, {18, 1, 12}, {1, 5, 12}, {3, 3, 12}, {0, 8, 12}, {6, 2, 12}, {17, 1, 12}};
        DCTtab3 = new byte[][]{{10, 2, 13}, {9, 2, 13}, {5, 3, 13}, {3, 4, 13}, {2, 5, 13}, {1, 7, 13}, {1, 6, 13}, {0, 15, 13}, {0, 14, 13}, {0, 13, 13}, {0, 12, 13}, {26, 1, 13}, {25, 1, 13}, {24, 1, 13}, {23, 1, 13}, {22, 1, 13}};
        DCTtab4 = new byte[][]{{0, 31, 14}, {0, 30, 14}, {0, 29, 14}, {0, 28, 14}, {0, 27, 14}, {0, 26, 14}, {0, 25, 14}, {0, 24, 14}, {0, 23, 14}, {0, 22, 14}, {0, 21, 14}, {0, 20, 14}, {0, 19, 14}, {0, 18, 14}, {0, 17, 14}, {0, 16, 14}};
        DCTtab5 = new byte[][]{{0, 40, 15}, {0, 39, 15}, {0, 38, 15}, {0, 37, 15}, {0, 36, 15}, {0, 35, 15}, {0, 34, 15}, {0, 33, 15}, {0, 32, 15}, {1, 14, 15}, {1, 13, 15}, {1, 12, 15}, {1, 11, 15}, {1, 10, 15}, {1, 9, 15}, {1, 8, 15}};
        DCTtab6 = new byte[][]{{1, 18, 16}, {1, 17, 16}, {1, 16, 16}, {1, 15, 16}, {6, 3, 16}, {16, 2, 16}, {15, 2, 16}, {14, 2, 16}, {13, 2, 16}, {12, 2, 16}, {11, 2, 16}, {31, 1, 16}, {30, 1, 16}, {29, 1, 16}, {28, 1, 16}, {27, 1, 16}};
        DCTtabfirst = new byte[][]{{0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}};
        DCTtabnext = new byte[][]{{0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}};
        CBPtab0 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {62, 5}, {2, 5}, {61, 5}, {1, 5}, {56, 5}, {52, 5}, {44, 5}, {28, 5}, {40, 5}, {20, 5}, {48, 5}, {12, 5}, {32, 4}, {32, 4}, {16, 4}, {16, 4}, {8, 4}, {8, 4}, {4, 4}, {4, 4}, {60, 3}, {60, 3}, {60, 3}, {60, 3}};
        CBPtab1 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {-1, 0}, {58, 8}, {54, 8}, {46, 8}, {30, 8}, {57, 8}, {53, 8}, {45, 8}, {29, 8}, {38, 8}, {26, 8}, {37, 8}, {25, 8}, {43, 8}, {23, 8}, {51, 8}, {15, 8}, {42, 8}, {22, 8}, {50, 8}, {14, 8}, {41, 8}, {21, 8}, {49, 8}, {13, 8}, {35, 8}, {19, 8}, {11, 8}, {7, 8}, {34, 7}, {34, 7}, {18, 7}, {18, 7}, {10, 7}, {10, 7}, {6, 7}, {6, 7}, {33, 7}, {33, 7}, {17, 7}, {17, 7}, {9, 7}, {9, 7}, {5, 7}, {5, 7}, {63, 6}, {63, 6}, {63, 6}, {63, 6}, {3, 6}, {3, 6}, {3, 6}, {3, 6}, {36, 6}, {36, 6}, {36, 6}, {36, 6}, {24, 6}, {24, 6}, {24, 6}, {24, 6}};
        CBPtab2 = new byte[][]{{-1, 0}, {0, 9}, {39, 9}, {27, 9}, {59, 9}, {55, 9}, {47, 9}, {31, 9}};
        DClumtab0 = new byte[][]{{1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {0, 3}, {0, 3}, {0, 3}, {0, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 3}, {4, 3}, {4, 3}, {4, 3}, {5, 4}, {5, 4}, {6, 5}, {-1, 0}};
        DClumtab1 = new byte[][]{{7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {9, 8}, {9, 8}, {10, 9}, {11, 9}};
        DCchromtab0 = new byte[][]{{0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 4}, {4, 4}, {5, 5}, {-1, 0}};
        DCchromtab1 = new byte[][]{{6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {8, 8}, {8, 8}, {8, 8}, {8, 8}, {9, 9}, {9, 9}, {10, 10}, {11, 10}};
        MVtab0 = new byte[][]{{-1, 0}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}};
        MVtab1 = new byte[][]{{-1, 0}, {-1, 0}, {-1, 0}, {7, 6}, {6, 6}, {5, 6}, {4, 5}, {4, 5}};
        MVtab2 = new byte[][]{{16, 9}, {15, 9}, {14, 9}, {13, 9}, {12, 9}, {11, 9}, {10, 8}, {10, 8}, {9, 8}, {9, 8}, {8, 8}, {8, 8}};
        PMBtab0 = new byte[][]{{-1, 0}, {8, 3}, {2, 2}, {2, 2}, {10, 1}, {10, 1}, {10, 1}, {10, 1}};
        PMBtab1 = new byte[][]{{-1, 0}, {17, 6}, {18, 5}, {18, 5}, {26, 5}, {26, 5}, {1, 5}, {1, 5}};
        BMBtab0 = new byte[][]{{-1, 0}, {-1, 0}, {8, 4}, {10, 4}, {4, 3}, {4, 3}, {6, 3}, {6, 3}, {12, 2}, {12, 2}, {12, 2}, {12, 2}, {14, 2}, {14, 2}, {14, 2}, {14, 2}};
        BMBtab1 = new byte[][]{{-1, 0}, {17, 6}, {22, 6}, {26, 6}, {30, 5}, {30, 5}, {1, 5}, {1, 5}};
        frame_rate_Table = new double[]{0.0, 23.976023976023978, 24.0, 25.0, 29.97002997002997, 30.0, 50.0, 59.94005994005994, 60.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    }
}

