/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.ExtensionHeader;

public class PictureCodingExtension
extends ExtensionHeader {
    private final int forward_horizontal_f_code;
    private final int forward_vertical_f_code;
    private final int backward_horizontal_f_code;
    private final int backward_vertical_f_code;
    private final int intra_dc_precision;
    private final int picture_structure;
    private final int top_field_first;
    private final int frame_pred_frame_dct;
    private final int concealment_motion_vectors;
    private final int q_scale_type;
    private final int intra_vlc_format;
    private final int alternate_scan;
    private final int repeat_first_field;
    private final int chroma_420_type;
    private final int progressive_frame;
    private final int composite_display_flag;
    private int v_axis;
    private int field_sequence;
    private int sub_carrier;
    private int burst_amplitude;
    private int sub_carrier_phase;

    public PictureCodingExtension(byte[] data, int offset) {
        super(data, offset);
        this.forward_horizontal_f_code = this.bs.readBits(4);
        this.forward_vertical_f_code = this.bs.readBits(4);
        this.backward_horizontal_f_code = this.bs.readBits(4);
        this.backward_vertical_f_code = this.bs.readBits(4);
        this.intra_dc_precision = this.bs.readBits(2);
        this.picture_structure = this.bs.readBits(2);
        this.top_field_first = this.bs.readBits(1);
        this.frame_pred_frame_dct = this.bs.readBits(1);
        this.concealment_motion_vectors = this.bs.readBits(1);
        this.q_scale_type = this.bs.readBits(1);
        this.intra_vlc_format = this.bs.readBits(1);
        this.alternate_scan = this.bs.readBits(1);
        this.repeat_first_field = this.bs.readBits(1);
        this.chroma_420_type = this.bs.readBits(1);
        this.progressive_frame = this.bs.readBits(1);
        this.composite_display_flag = this.bs.readBits(1);
        if (this.composite_display_flag == 1) {
            this.v_axis = this.bs.readBits(1);
            this.field_sequence = this.bs.readBits(3);
            this.sub_carrier = this.bs.readBits(1);
            this.burst_amplitude = this.bs.readBits(7);
            this.sub_carrier_phase = this.bs.readBits(8);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.setUserObject(new KVP("Picture Coding Extension"));
        t.add(new DefaultMutableTreeNode(new KVP("f_code[0][0], forward horizontal", this.forward_horizontal_f_code, null)));
        t.add(new DefaultMutableTreeNode(new KVP("f_code[0][1], forward vertical", this.forward_vertical_f_code, null)));
        t.add(new DefaultMutableTreeNode(new KVP("f_code[1][0], backward horizontal", this.backward_horizontal_f_code, null)));
        t.add(new DefaultMutableTreeNode(new KVP("f_code[1][1], backward vertical", this.backward_vertical_f_code, null)));
        t.add(new DefaultMutableTreeNode(new KVP("intra_dc_precision", this.intra_dc_precision, 8 + this.intra_dc_precision + " bits")));
        t.add(new DefaultMutableTreeNode(new KVP("picture_structure", this.picture_structure, PictureCodingExtension.getPictureStructureString(this.picture_structure))));
        t.add(new DefaultMutableTreeNode(new KVP("top_field_first", this.top_field_first, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_pred_frame_dct", this.frame_pred_frame_dct, this.frame_pred_frame_dct == 1 ? "only frame-DCT and frame prediction are used" : "")));
        t.add(new DefaultMutableTreeNode(new KVP("concealment_motion_vectors", this.concealment_motion_vectors, this.concealment_motion_vectors == 1 ? "motion vectors are coded in intra macroblocks" : "no motion vectors are coded in intra macroblocks")));
        t.add(new DefaultMutableTreeNode(new KVP("q_scale_type", this.q_scale_type, null)));
        t.add(new DefaultMutableTreeNode(new KVP("intra_vlc_format", this.intra_vlc_format, null)));
        t.add(new DefaultMutableTreeNode(new KVP("alternate_scan", this.alternate_scan, null)));
        t.add(new DefaultMutableTreeNode(new KVP("repeat_first_field", this.repeat_first_field, null)));
        t.add(new DefaultMutableTreeNode(new KVP("chroma_420_type", this.chroma_420_type, null)));
        t.add(new DefaultMutableTreeNode(new KVP("progressive_frame", this.progressive_frame, this.progressive_frame == 1 ? "the two fields (of the frame) are from the same time instant as one another" : "the two fields of the frame are interlaced fields in which an interval of time of the field period exists between (corresponding spatial samples) of the two fields")));
        t.add(new DefaultMutableTreeNode(new KVP("composite_display_flag", this.composite_display_flag, null)));
        if (this.composite_display_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("v_axis", this.v_axis, null)));
            t.add(new DefaultMutableTreeNode(new KVP("field_sequence", this.field_sequence, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sub_carrier", this.sub_carrier, null)));
            t.add(new DefaultMutableTreeNode(new KVP("burst_amplitude", this.burst_amplitude, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sub_carrier_phase", this.sub_carrier_phase, null)));
        }
        return t;
    }

    public static String getPictureStructureString(int picture_structure) {
        switch (picture_structure) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "Top Field";
            }
            case 2: {
                return "Bottom Field";
            }
            case 3: {
                return "Frame picture";
            }
        }
        return "error";
    }
}

