/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;

public class PictureHeader
extends VideoMPEG2Section {
    private final int temporal_reference;
    private final int picture_coding_type;
    private final int vbv_delay;
    private int full_pel_forward_vector;
    private int forward_f_code;
    private int full_pel_backward_vector;
    private int backward_f_code;
    private final List<ExtraInformationPicture> extraPicture = new ArrayList<ExtraInformationPicture>();
    private final int extra_bit_picture;

    public PictureHeader(byte[] data, int offset) {
        super(data, offset);
        this.temporal_reference = this.bs.readBits(10);
        this.picture_coding_type = this.bs.readBits(3);
        this.vbv_delay = this.bs.readBits(16);
        if (this.picture_coding_type == 2 || this.picture_coding_type == 3) {
            this.full_pel_forward_vector = this.bs.readBits(1);
            this.forward_f_code = this.bs.readBits(3);
        }
        if (this.picture_coding_type == 3) {
            this.full_pel_backward_vector = this.bs.readBits(1);
            this.backward_f_code = this.bs.readBits(3);
        }
        int nextBits = this.bs.readBits(1);
        while (nextBits == 1) {
            ExtraInformationPicture p = new ExtraInformationPicture(nextBits, this.bs.readBits(8));
            this.extraPicture.add(p);
            nextBits = this.bs.readBits(1);
        }
        this.extra_bit_picture = nextBits;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("temporal_reference", this.temporal_reference, null)));
        t.add(new DefaultMutableTreeNode(new KVP("picture_coding_type", this.picture_coding_type, PictureHeader.getPictureCodingTypeString(this.picture_coding_type))));
        t.add(new DefaultMutableTreeNode(new KVP("vbv_delay", this.vbv_delay, null)));
        if (this.picture_coding_type == 2 || this.picture_coding_type == 3) {
            t.add(new DefaultMutableTreeNode(new KVP("full_pel_forward_vector", this.full_pel_forward_vector, null)));
            t.add(new DefaultMutableTreeNode(new KVP("forward_f_code", this.forward_f_code, null)));
        }
        if (this.picture_coding_type == 3) {
            t.add(new DefaultMutableTreeNode(new KVP("full_pel_backward_vector", this.full_pel_backward_vector, null)));
            t.add(new DefaultMutableTreeNode(new KVP("backward_f_code", this.backward_f_code, null)));
        }
        for (ExtraInformationPicture pic : this.extraPicture) {
            t.add(new DefaultMutableTreeNode(new KVP("extra_bit_picture", pic.getExtra_bit_picture(), null)));
            t.add(new DefaultMutableTreeNode(new KVP("extra_information_picture", pic.getExtra_information_picture(), null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("extra_bit_picture", this.extra_bit_picture, null)));
        return t;
    }

    public static String getPictureCodingTypeString(int startCode) {
        switch (startCode) {
            case 0: {
                return "forbidden";
            }
            case 1: {
                return "intra-coded (I)";
            }
            case 2: {
                return "predictive-coded (P)";
            }
            case 3: {
                return "bidirectionally-predictive-coded (B)";
            }
            case 4: {
                return "shall not be used (dc intra-coded (D) in ISO/IEC11172-2)";
            }
            case 5: {
                return "reserved";
            }
            case 6: {
                return "reserved";
            }
            case 7: {
                return "reserved";
            }
        }
        return "error";
    }

    public int getPicture_coding_type() {
        return this.picture_coding_type;
    }

    public String getPictureCodingTypeShortString() {
        switch (this.picture_coding_type) {
            case 0: {
                return "?";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "P";
            }
            case 3: {
                return "B";
            }
            case 4: {
                return "D";
            }
        }
        return "?";
    }

    public int getTemporal_reference() {
        return this.temporal_reference;
    }

    public int getVbv_delay() {
        return this.vbv_delay;
    }

    public static class ExtraInformationPicture {
        private int extra_bit_picture;
        private int extra_information_picture;

        public ExtraInformationPicture(int extra_bit_picture, int extra_information_picture) {
            this.extra_bit_picture = extra_bit_picture;
            this.extra_information_picture = extra_information_picture;
        }

        public int getExtra_bit_picture() {
            return this.extra_bit_picture;
        }

        public void setExtra_bit_picture(int extra_bit_picture) {
            this.extra_bit_picture = extra_bit_picture;
        }

        public int getExtra_information_picture() {
            return this.extra_information_picture;
        }

        public void setExtra_information_picture(int extra_information_picture) {
            this.extra_information_picture = extra_information_picture;
        }
    }
}

