/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.ExtensionHeader;

public class SequenceDisplayExtension
extends ExtensionHeader {
    private final int video_format;
    private final int colour_description;
    private int colour_primaries;
    private int transfer_characteristics;
    private int matrix_coefficients;
    private final int display_horizontal_size;
    private final int marker_bit;
    private final int display_vertical_size;

    public SequenceDisplayExtension(byte[] data, int offset) {
        super(data, offset);
        this.video_format = this.bs.readBits(3);
        this.colour_description = this.bs.readBits(1);
        if (this.colour_description == 1) {
            this.colour_primaries = this.bs.readBits(8);
            this.transfer_characteristics = this.bs.readBits(8);
            this.matrix_coefficients = this.bs.readBits(8);
        }
        this.display_horizontal_size = this.bs.readBits(14);
        this.marker_bit = this.bs.readBits(1);
        this.display_vertical_size = this.bs.readBits(14);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.setUserObject(new KVP("Sequence Display extension"));
        t.add(new DefaultMutableTreeNode(new KVP("video_format", this.video_format, SequenceDisplayExtension.getVideoFormatString(this.video_format))));
        t.add(new DefaultMutableTreeNode(new KVP("colour_description", this.colour_description, null)));
        if (this.colour_description == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("colour_primaries", this.colour_primaries, SequenceDisplayExtension.getColourPrimariesString(this.colour_primaries))));
            t.add(new DefaultMutableTreeNode(new KVP("transfer_characteristics", this.transfer_characteristics, SequenceDisplayExtension.getTransferCharacteristicsString(this.transfer_characteristics))));
            t.add(new DefaultMutableTreeNode(new KVP("matrix_coefficients", this.matrix_coefficients, SequenceDisplayExtension.getMatrixCoefficientsString(this.matrix_coefficients))));
        }
        t.add(new DefaultMutableTreeNode(new KVP("display_horizontal_size", this.display_horizontal_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("marker_bit", this.marker_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("display_vertical_size", this.display_vertical_size, null)));
        return t;
    }

    public static String getVideoFormatString(int videoFromat) {
        switch (videoFromat) {
            case 0: {
                return "component";
            }
            case 1: {
                return "PAL";
            }
            case 2: {
                return "NTSC";
            }
            case 3: {
                return "SECAM";
            }
            case 4: {
                return "MAC";
            }
            case 5: {
                return "Unspecified video format";
            }
        }
        return "reserved";
    }

    public static String getColourPrimariesString(int profile) {
        switch (profile) {
            case 0: {
                return "(forbidden)";
            }
            case 1: {
                return "Recommendation ITU-R BT.709";
            }
            case 2: {
                return "Unspecified Video";
            }
            case 3: {
                return "reserved";
            }
            case 4: {
                return "Recommendation ITU-R BT.470-2 System M";
            }
            case 5: {
                return "Recommendation ITU-R BT.470-2 System B, G";
            }
            case 6: {
                return "SMPTE 170M";
            }
            case 7: {
                return "SMPTE 240M (1987)";
            }
        }
        return "reserved";
    }

    public static String getTransferCharacteristicsString(int profile) {
        switch (profile) {
            case 0: {
                return "(forbidden)";
            }
            case 1: {
                return "Recommendation ITU-R BT.709";
            }
            case 2: {
                return "Unspecified Video";
            }
            case 3: {
                return "reserved";
            }
            case 4: {
                return "Recommendation ITU-R BT.470-2 System M";
            }
            case 5: {
                return "Recommendation ITU-R BT.470-2 System B, G";
            }
            case 6: {
                return "SMPTE 170M";
            }
            case 7: {
                return "SMPTE 240M (1987)";
            }
            case 8: {
                return "Linear transfer characteristics";
            }
        }
        return "reserved";
    }

    public static String getMatrixCoefficientsString(int profile) {
        switch (profile) {
            case 0: {
                return "(forbidden)";
            }
            case 1: {
                return "Recommendation ITU-R BT.709";
            }
            case 2: {
                return "Unspecified Video";
            }
            case 3: {
                return "reserved";
            }
            case 4: {
                return "FCC";
            }
            case 5: {
                return "Recommendation ITU-R BT.470-2 System B, G";
            }
            case 6: {
                return "SMPTE 170M";
            }
            case 7: {
                return "SMPTE 240M (1987)";
            }
        }
        return "reserved";
    }
}

