/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.ExtensionHeader;
import nl.digitalekabeltelevisie.util.Utils;

public class SequenceExtension
extends ExtensionHeader {
    private final int profile_and_level_indication;
    private final int progressive_sequence;
    private final int chroma_format;
    private final int horizontal_size_extension;
    private final int vertical_size_extension;
    private final int bit_rate_extension;
    private final int vbv_buffer_size_extension;
    private final int low_delay;
    private final int frame_rate_extension_n;
    private final int frame_rate_extension_d;

    public SequenceExtension(byte[] data, int offset) {
        super(data, offset);
        this.profile_and_level_indication = Utils.getInt(data, offset + 1, 2, 4080) >> 4;
        this.progressive_sequence = Utils.getInt(data, offset + 2, 1, 8) >> 3;
        this.chroma_format = Utils.getInt(data, offset + 2, 1, 6) >> 1;
        this.horizontal_size_extension = Utils.getInt(data, offset + 2, 2, 384) >> 7;
        this.vertical_size_extension = Utils.getInt(data, offset + 3, 1, 96) >> 5;
        this.bit_rate_extension = Utils.getInt(data, offset + 3, 2, 8190) >> 1;
        this.vbv_buffer_size_extension = Utils.getInt(data, offset + 5, 1, 255);
        this.low_delay = Utils.getInt(data, offset + 6, 1, 128) >> 8;
        this.frame_rate_extension_n = Utils.getInt(data, offset + 6, 1, 96) >> 5;
        this.frame_rate_extension_d = Utils.getInt(data, offset + 6, 1, 96);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.setUserObject(new KVP("Sequence extension"));
        t.add(new DefaultMutableTreeNode(new KVP("profile_and_level_indication", this.profile_and_level_indication, SequenceExtension.getProfileLevelString(this.profile_and_level_indication))));
        t.add(new DefaultMutableTreeNode(new KVP("progressive_sequence", this.progressive_sequence, this.progressive_sequence == 1 ? "video sequence contains only progressive framepictures" : "video sequence may contain both framepictures and field-pictures, and frame-picture may be progressive or interlaced frames")));
        t.add(new DefaultMutableTreeNode(new KVP("chroma_format", this.chroma_format, SequenceExtension.getChromaFormatString(this.chroma_format))));
        t.add(new DefaultMutableTreeNode(new KVP("horizontal_size_extension", this.horizontal_size_extension, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vertical_size_extension", this.vertical_size_extension, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bit_rate_extension", this.bit_rate_extension, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vbv_buffer_size_extension", this.vbv_buffer_size_extension, null)));
        t.add(new DefaultMutableTreeNode(new KVP("low_delay", this.low_delay, this.low_delay == 1 ? "sequence does not contain any B-pictures" : "sequence may contain B-pictures")));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_extension_n", this.frame_rate_extension_n, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_rate_extension_d", this.frame_rate_extension_d, null)));
        return t;
    }

    public static String getChromaFormatString(int startCode) {
        switch (startCode) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "4:2:0";
            }
            case 2: {
                return "4:2:2";
            }
            case 3: {
                return "4:4:4";
            }
        }
        return "error";
    }

    public static String getProfileLevelString(int profileLevel) {
        int escapeBit = (profileLevel & 0x80) >> 7;
        int profile = (profileLevel & 0x70) >> 4;
        int level = profileLevel & 0xF;
        StringBuilder b = new StringBuilder("Escape bit: ").append(escapeBit);
        b.append(", profile: ").append(SequenceExtension.getProfileString(profile));
        b.append(", level: ").append(SequenceExtension.getLevelString(level));
        return b.toString();
    }

    public static String getProfileString(int profile) {
        switch (profile) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "High";
            }
            case 2: {
                return "Spatially Scalable";
            }
            case 3: {
                return "SNR Scalable";
            }
            case 4: {
                return "Main";
            }
            case 5: {
                return "Simple";
            }
        }
        return "reserved";
    }

    public static String getLevelString(int level) {
        switch (level) {
            case 4: {
                return "High";
            }
            case 6: {
                return "High 1440";
            }
            case 8: {
                return "Main";
            }
            case 10: {
                return "Low";
            }
        }
        return "reserved";
    }
}

