/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.AuxiliaryData;
import nl.digitalekabeltelevisie.util.Utils;

public class UserData
extends VideoMPEG2Section {
    private final byte[] data;
    private final int offset;
    private final int len;
    private final AuxiliaryData auxData;

    public UserData(byte[] data, int offset) {
        super(data, offset);
        this.data = data;
        this.offset = offset;
        int end = Utils.indexOf(data, new byte[]{0, 0, 1}, offset + 1);
        this.len = end - offset - 1;
        this.auxData = new AuxiliaryData(data, offset + 1, this.len);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(this.auxData.getJTreeNode(modus));
        return t;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLen() {
        return this.len;
    }

    public int getOffset() {
        return this.offset;
    }

    public AuxiliaryData getAuxData() {
        return this.auxData;
    }
}

