/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.ExtensionHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.GroupOfPicturesHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.MpvDecoder;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.PictureCodingExtension;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.PictureHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.SequenceDisplayExtension;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.SequenceExtension;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.SequenceHeader;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.UserData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.VideoMPEG2Section;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;

public class VideoPESDataField
extends PesPacketData
implements TreeNode,
ImageSource {
    private final List<VideoMPEG2Section> sections = new ArrayList<VideoMPEG2Section>();
    private static final Logger logger = Logger.getLogger(VideoPESDataField.class.getName());

    public VideoPESDataField(PesPacketData pesPacket) {
        super(pesPacket);
        int i = this.pesDataStart;
        while (i < this.data.length && i >= 0) {
            VideoMPEG2Section section;
            if ((i = Utils.indexOf(this.data, new byte[]{0, 0, 1}, i)) < 0) continue;
            if (Byte.toUnsignedInt(this.data[i + 3]) == 0) {
                section = new PictureHeader(this.data, i + 3);
            } else if (Byte.toUnsignedInt(this.data[i + 3]) == 178) {
                section = new UserData(this.data, i + 3);
            } else if (Byte.toUnsignedInt(this.data[i + 3]) == 179) {
                section = new SequenceHeader(this.data, i + 3);
            } else if (Byte.toUnsignedInt(this.data[i + 3]) == 181) {
                int extensionStartCodeIdentifier = (Byte.toUnsignedInt(this.data[i + 4]) & 0xF0) >> 4;
                if (extensionStartCodeIdentifier == 1) {
                    section = new SequenceExtension(this.data, i + 3);
                } else if (extensionStartCodeIdentifier == 8) {
                    section = new PictureCodingExtension(this.data, i + 3);
                } else if (extensionStartCodeIdentifier == 2) {
                    section = new SequenceDisplayExtension(this.data, i + 3);
                } else {
                    section = new ExtensionHeader(this.data, i + 3);
                    logger.warning("Not implemented extendsion start code identifier:" + extensionStartCodeIdentifier + " (" + ExtensionHeader.getExtensionStartCodeIdentifierString(extensionStartCodeIdentifier) + ")");
                }
            } else {
                section = Byte.toUnsignedInt(this.data[i + 3]) == 184 ? new GroupOfPicturesHeader(this.data, i + 3) : new VideoMPEG2Section(this.data, i + 3);
            }
            this.sections.add(section);
            i += 3;
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        List<VideoMPEG2Section> picts = VideoPESDataField.findSectionInList(this.sections, 0);
        StringBuilder type = new StringBuilder();
        if (picts != null && picts.size() > 0) {
            type.append(" (Pictures ");
            for (VideoMPEG2Section section : picts) {
                type.append(((PictureHeader)section).getPictureCodingTypeShortString());
            }
            type.append(")");
        }
        DefaultMutableTreeNode s = super.getJTreeNode(modus, new KVP("Video PES Packet" + String.valueOf(type)).addImageSource(this, "Frame"));
        Utils.addListJTree(s, this.sections, modus, "Sections");
        return s;
    }

    public static String getStartCodeString(int startCode) {
        if (startCode >= 1 && startCode <= 175) {
            return "slice_start_code ";
        }
        switch (startCode) {
            case 0: {
                return "picture_start_code";
            }
            case 176: {
                return "reserved";
            }
            case 177: {
                return "reserved";
            }
            case 178: {
                return "user_data_start_code";
            }
            case 179: {
                return "sequence_header_code";
            }
            case 180: {
                return "sequence_error_code";
            }
            case 181: {
                return "extension_start_code";
            }
            case 182: {
                return "reserved";
            }
            case 183: {
                return "sequence_end_code";
            }
            case 184: {
                return "group_start_code";
            }
            case 185: {
                return "MPEG_program_stream_end (PS)";
            }
            case 186: {
                return "MPEG_pack_start (PS)";
            }
            case 187: {
                return "MPEG_system_header_start (PS)";
            }
        }
        return "unknown/error";
    }

    public static String getSectionTypeString(int startCode) {
        if (startCode >= 1 && startCode <= 175) {
            return "Slice " + startCode;
        }
        switch (startCode) {
            case 0: {
                return "Picture header";
            }
            case 176: {
                return "reserved";
            }
            case 177: {
                return "reserved";
            }
            case 178: {
                return "User Data";
            }
            case 179: {
                return "Sequence header";
            }
            case 180: {
                return "sequence_error_code";
            }
            case 181: {
                return "Extension data";
            }
            case 182: {
                return "reserved";
            }
            case 183: {
                return "sequence_end_code";
            }
            case 184: {
                return "Group Of Pictures";
            }
            case 185: {
                return "MPEG_program_stream_end (PS)";
            }
            case 186: {
                return "MPEG_pack_start (PS)";
            }
            case 187: {
                return "MPEG_system_header_start (PS)";
            }
        }
        return "unknown/error";
    }

    public static List<VideoMPEG2Section> findSectionInList(List<VideoMPEG2Section> sectionList, int startCode) {
        ArrayList<VideoMPEG2Section> result = new ArrayList<VideoMPEG2Section>();
        for (VideoMPEG2Section element : sectionList) {
            if (element.getStartCode() != startCode) continue;
            result.add(element);
        }
        return result;
    }

    public List<VideoMPEG2Section> getSections() {
        return this.sections;
    }

    @Override
    public BufferedImage getImage() {
        if (this.hasIFrame()) {
            MpvDecoder mpvDecoder = new MpvDecoder();
            mpvDecoder.decodeArray(this.data, false, false, false, 0);
            return mpvDecoder.getImage();
        }
        return null;
    }

    public BufferedImage getImage(int w, int h) {
        if (this.hasIFrame()) {
            MpvDecoder mpvDecoder = new MpvDecoder();
            mpvDecoder.decodeArray(this.data, false, false, false, 0);
            return mpvDecoder.getImage(w, h);
        }
        return null;
    }

    public boolean hasIFrame() {
        List<VideoMPEG2Section> picts = VideoPESDataField.findSectionInList(this.sections, 0);
        if (picts != null && picts.size() > 0) {
            for (VideoMPEG2Section section : picts) {
                if (((PictureHeader)section).getPicture_coding_type() != 1) continue;
                return true;
            }
        }
        return false;
    }
}

