/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.BarData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.CCData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.ST2094_10_Data;
import nl.digitalekabeltelevisie.util.Utils;

public class AuxiliaryData
implements TreeNode {
    private static final Logger logger = Logger.getLogger(AuxiliaryData.class.getName());
    private byte[] data = null;
    int offset = 0;
    int len = 0;
    byte[] user_identifier;
    private boolean isAFD;
    private int active_format_flag;
    private int reserved = 0;
    private int reserved2 = 0;
    private int active_format;
    private boolean isDVB1data;
    private int user_data_type_code;
    private byte[] user_data_type_structure;
    private BarData barData;
    private CCData ccData;
    private ST2094_10_Data st2094_10_data;

    public AuxiliaryData(byte[] data, int offset, int len) {
        this.data = data;
        this.offset = offset;
        this.len = len;
        this.user_identifier = Arrays.copyOfRange(data, offset, offset + 4);
        if (Utils.indexOf(data, new byte[]{68, 84, 71, 49}, offset) == offset) {
            this.isAFD = true;
            this.active_format_flag = Utils.getInt(data, offset + 4, 1, 64) >> 6;
            this.reserved = Utils.getInt(data, offset + 4, 1, 63);
            if (this.active_format_flag == 1) {
                this.reserved2 = Utils.getInt(data, offset + 5, 1, 240) >> 4;
                this.active_format = Utils.getInt(data, offset + 5, 1, 15);
            }
        }
        if (Utils.indexOf(data, new byte[]{71, 65, 57, 52}, offset) == offset) {
            this.isDVB1data = true;
            this.user_data_type_code = Utils.getInt(data, offset + 4, 1, 255);
            this.user_data_type_structure = Utils.getBytes(data, offset + 5, len - 5);
            if (this.user_data_type_code == 6) {
                this.barData = new BarData(this.user_data_type_structure, 0, len - 5);
            } else if (this.user_data_type_code == 3) {
                this.ccData = new CCData(this.user_data_type_structure, 0, len - 5);
            } else if (this.user_data_type_code == 9) {
                this.st2094_10_data = new ST2094_10_Data(this.user_data_type_structure, 0, len - 5);
            } else {
                logger.warning("Unsupported user_data_type_code:" + this.user_data_type_code + " (" + AuxiliaryData.getUserDataTypeString(this.user_data_type_code) + ")");
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Auxilary data", this.data, this.offset, this.len, this.isAFD ? "Active Format Description" : null));
        t.add(new DefaultMutableTreeNode(new KVP("user_identifier", this.user_identifier, null)));
        if (this.isAFD) {
            t.add(new DefaultMutableTreeNode(new KVP("active_format_flag", this.active_format_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved2, null)));
            t.add(new DefaultMutableTreeNode(new KVP("active_format", this.active_format, AuxiliaryData.getActiveFormatString(this.active_format))));
        }
        if (this.isDVB1data) {
            t.add(new DefaultMutableTreeNode(new KVP("user_data_type_code", this.user_data_type_code, AuxiliaryData.getUserDataTypeString(this.user_data_type_code))));
            t.add(new DefaultMutableTreeNode(new KVP("user_data_type_structure", this.user_data_type_structure, null)));
            if (this.user_data_type_code == 6) {
                t.add(this.barData.getJTreeNode(modus));
            } else if (this.user_data_type_code == 3) {
                t.add(this.ccData.getJTreeNode(modus));
            } else if (this.user_data_type_code == 9) {
                t.add(this.st2094_10_data.getJTreeNode(modus));
            }
        }
        return t;
    }

    public static String getUserDataTypeString(int user_data_type_code) {
        switch (user_data_type_code) {
            case 3: {
                return "CEA-708 captions\u00a0(cc data)";
            }
            case 4: {
                return "Additional 608 Data";
            }
            case 5: {
                return "Luma PAM";
            }
            case 6: {
                return "AFD (bar data)";
            }
            case 7: {
                return "multi_region_disparity";
            }
            case 9: {
                return "ST2094-10_data";
            }
        }
        if (user_data_type_code >= 0 && user_data_type_code <= 255) {
            return "DVB Reserved";
        }
        return "unknown/error";
    }

    public static String getActiveFormatString(int active_format) {
        switch (active_format) {
            case 0: {
                return "reserved";
            }
            case 1: {
                return "reserved";
            }
            case 2: {
                return "box 16:9 (top)";
            }
            case 3: {
                return "box 14:9 (top)";
            }
            case 4: {
                return "box > 16:9 (centre)";
            }
            case 5: {
                return "reserved";
            }
            case 6: {
                return "reserved";
            }
            case 7: {
                return "reserved";
            }
            case 8: {
                return "Active format is the same as the coded frame";
            }
            case 9: {
                return "4:3 (centre)";
            }
            case 10: {
                return "16:9 (centre)";
            }
            case 11: {
                return "14:9 (centre)";
            }
            case 12: {
                return "reserved";
            }
            case 13: {
                return "4:3 (with shoot & protect 14:9 centre)";
            }
            case 14: {
                return "16:9 (with shoot & protect 14:9 centre)";
            }
            case 15: {
                return "16:9 (with shoot & protect 4:3 centre)";
            }
        }
        return "unknown/error";
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLen() {
        return this.len;
    }

    public byte[] getUser_identifier() {
        return this.user_identifier;
    }

    public boolean isAFD() {
        return this.isAFD;
    }

    public int getActive_format_flag() {
        return this.active_format_flag;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getActive_format() {
        return this.active_format;
    }

    public boolean isDVB1data() {
        return this.isDVB1data;
    }

    public int getUser_data_type_code() {
        return this.user_data_type_code;
    }

    public byte[] getUser_data_type_structure() {
        return this.user_data_type_structure;
    }

    public BarData getBarData() {
        return this.barData;
    }

    public CCData getCcData() {
        return this.ccData;
    }
}

