/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.common.Cea608;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class Construct
implements TreeNode,
HTMLSource {
    private static final Logger logger = Logger.getLogger(Construct.class.getName());
    public static LookUpList cc_type_list = new LookUpList.Builder().add(0, "NTSC_CC_FIELD_1").add(1, "NTSC_CC_FIELD_2").add(2, "DTVCC_PACKET_DATA").add(3, "DTVCC_PACKET_START").build();
    public static LookUpList control_code_list = new LookUpList.Builder().add(0, "resume caption loading").add(1, "backspace").add(2, "alarm off").add(3, "alarm on").add(4, "delete to end of row").add(5, "roll up 2").add(6, "roll up 3").add(7, "roll up 4").add(8, "flashes captions on").add(9, "resume direct captioning").add(10, "text restart").add(11, "resume text display").add(12, "erase display memory").add(13, "carriage return").add(14, "erase non displayed memory").add(15, "end of caption").build();
    public static LookUpList row_list = new LookUpList.Builder().add(0, "Row 11").add(1, " -").add(2, "Row 1").add(3, "Row 2").add(4, "Row 3").add(5, "Row 4").add(10, "Row 5").add(11, "Row 6").add(12, "Row 7").add(13, "Row 8").add(14, "Row 9").add(15, "Row 10").add(6, "Row 12").add(7, "Row 13").add(8, "Row 14").add(9, "Row 15").build();
    public static LookUpList style_list = new LookUpList.Builder().add(0, "White").add(1, "Green").add(2, "Blue").add(3, "Cyan").add(4, "Red").add(5, "Yellow").add(6, "Magenta").add(7, "Italics").build();
    public static LookUpList xds_class_raw = new LookUpList.Builder().add(1, "Start Current").add(2, "Continue Current").add(3, "Start Future").add(4, "Continue Future").add(5, "Start Channel").add(6, "Continue Channel").add(7, "Start Miscellaneous").add(8, "Continue Miscellaneous").add(9, "Start Public Service").add(10, "Continue Public Service").add(11, "Start Reserved").add(12, "Continue Reserved").add(13, "Start Private Data").add(14, "Continue Private Data").add(15, "End ALL").build();
    public static LookUpList xds_class = new LookUpList.Builder().add(0, "Current").add(1, "Future").add(2, "Channel").add(3, "Miscellaneous").add(4, "Public Service").add(5, "Reserved").add(6, "Private Data").build();
    public static LookUpList current_type = new LookUpList.Builder().add(1, "Program Identification Number").add(2, "Length/Time-in-Show").add(3, "Program Name (Title) ").add(4, "Program Type").add(5, "Content Advisory").add(6, "Audio Services").add(7, "Caption Services").add(8, "Copy Generation Management System (Analog)").add(9, "Aspect Ratio Information").add(10, "-").add(11, "-").add(12, "Composite Packet-1").add(13, "Composite Packet-2").add(14, "-").add(15, "-").add(16, "Program Description Row 1").add(17, "Program Description Row 2").add(18, "Program Description Row 3").add(19, "Program Description Row 4").add(20, "Program Description Row 5").add(21, "Program Description Row 6").add(22, "Program Description Row 7").add(23, "Program Description Row 8").build();
    public static LookUpList future_type = new LookUpList.Builder().add(1, "Program Identification Number").add(2, "Length/Time-in-Show").add(3, "Program Name (Title) ").add(4, "Program Type").add(5, "Content Advisory").add(6, "Audio Services").add(7, "Caption Services").add(8, "Copy Generation Management System (Analog)").add(9, "Aspect Ratio Information").add(10, "-").add(11, "-").add(12, "Composite Packet-1").add(13, "Composite Packet-2").add(14, "-").add(15, "-").add(16, "Program Description Row 1").add(17, "Program Description Row 2").add(18, "Program Description Row 3").add(19, "Program Description Row 4").add(20, "Program Description Row 5").add(21, "Program Description Row 6").add(22, "Program Description Row 7").add(23, "Program Description Row 8").add(80, "Minor Channel Number").add(81, "Event Number").add(82, "Event Start Time").add(83, "Event Duration").add(84, "Program Title").add(85, "Program Type").add(86, "Content Advisory").add(87, "Audio Services").add(88, "Caption Services").add(96, "Multiple String Structure Control").add(97, "EIT Descriptor Information").add(98, 110, "Reserved").add(111, "Data Carriage Packet").build();
    public static LookUpList channel_type = new LookUpList.Builder().add(1, "Network Name (Affiliation)").add(2, "Call Letters (Station ID) and Native Channel").add(3, "Tape Delay").add(4, "Transmission Signal Identifier (TSID)").build();
    public static LookUpList misc_type = new LookUpList.Builder().add(1, "Time of Day").add(2, "Impulse Capture ID").add(3, "Supplemental Data Location").add(4, "Local Time Zone & DST Use").build();
    public static LookUpList public_service_type = new LookUpList.Builder().add(1, "National Weather Service Code (WRSAME)").add(2, "National Weather Service Message").build();
    static Map<Integer, LookUpList> lookupType = new TreeMap<Integer, LookUpList>();
    private int one_bit;
    private int reserved;
    private int cc_valid;
    private int cc_type;
    private int cc_data_1;
    private int cc_data_2;

    public static String getTypeDescription(int class1, int type) {
        LookUpList classLookup = lookupType.get(class1);
        if (classLookup == null) {
            return "unknown";
        }
        return classLookup.get(type, "unknown");
    }

    public int getCc_valid() {
        return this.cc_valid;
    }

    public int getCc_type() {
        return this.cc_type;
    }

    public int getCc_data_1() {
        return this.cc_data_1;
    }

    public int getCc_data_2() {
        return this.cc_data_2;
    }

    public Construct(byte[] data, int localOffset) {
        if (localOffset < data.length) {
            this.one_bit = Utils.getInt(data, localOffset, 1, 128) >> 7;
            this.reserved = Utils.getInt(data, localOffset, 1, 113) >> 3;
            this.cc_valid = Utils.getInt(data, localOffset, 1, 4) >> 2;
            this.cc_type = Utils.getInt(data, localOffset, 1, 3);
        }
        if (localOffset + 1 < data.length) {
            this.cc_data_1 = Utils.getInt(data, localOffset + 1, 1, 255);
        }
        if (localOffset + 2 < data.length) {
            this.cc_data_2 = Utils.getInt(data, localOffset + 2, 1, 255);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("construct");
        kvp.addHTMLSource(this, "Construct");
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        t.add(new DefaultMutableTreeNode(new KVP("one_bit", this.one_bit, "shall be '1' to maintain backwards compatibility with previous versions of CEA-708-C")));
        t.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cc_valid", this.cc_valid, this.cc_valid == 1 ? "the two closed caption data bytes that follow are valid" : "the two data bytes are invalid")));
        t.add(new DefaultMutableTreeNode(new KVP("cc_type", this.cc_type, cc_type_list.get(this.cc_type))));
        t.add(new DefaultMutableTreeNode(new KVP("cc_data_1", this.cc_data_1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cc_data_2", this.cc_data_2, null)));
        return t;
    }

    @Override
    public String getHTML() {
        String ccString = this.interpretCCDataBytes();
        return String.format("Type: %1$d [%2$s], cc_valid: %3$d, cc_data_1: %4$#04x, cc_data_2: %5$#04x, %6$s", this.cc_type, cc_type_list.get(this.cc_type), this.cc_valid, this.cc_data_1, this.cc_data_2, ccString);
    }

    public int getCC1WithoutParity() {
        return this.cc_data_1 & 0x7F;
    }

    public int getCC2WithoutParity() {
        return this.cc_data_2 & 0x7F;
    }

    private String interpretCCDataBytes() {
        if (this.cc_type >= 2) {
            return "";
        }
        if (this.isControl()) {
            int field = 1 + (this.cc_data_1 & 1);
            int controlCode = this.cc_data_2 & 0xF;
            return String.format("[Control Command, channel: %1$d, field%2$d ], code:  %3$d (%4$s)", this.getChannel(), field, controlCode, control_code_list.get(controlCode, "???"));
        }
        if (this.isTab()) {
            int tabOffset = this.cc_data_2 & 3;
            return String.format("[Tab Offset, channel: %1$d], offset:  %2$d ", this.getChannel(), tabOffset);
        }
        if (this.isRowPreambleStyle()) {
            return String.format("RowPreambleStyle: channel: %1$d, row: %2$d, next row down toggle: %3$d [%6$s], style: %4$d [%5$s], underline: %6$d", this.getChannel(), this.getRow(), this.getNextRowDownToggle(), this.getStyle(), style_list.get(this.getStyle()), this.getUnderline(), row_list.get(this.getRow() * 2 + this.getNextRowDownToggle(), "???"));
        }
        if (this.isRowPreambleAddress()) {
            return String.format("RowPreambleAddress: channel: %1$d, row: %2$d, next row down toggle: %3$d [%6$s], cursor:%4$d [%7$s] , underline: %5$d", this.getChannel(), this.getRow(), this.getNextRowDownToggle(), this.getCursor(), this.getUnderline(), row_list.get(this.getRow() * 2 + this.getNextRowDownToggle(), "?x?"), "Indent " + this.getCursor() * 4);
        }
        if (this.cc_data_1 == 128 && this.cc_data_2 == 128) {
            return "null pad";
        }
        if (this.isXDSControl()) {
            String res = "XDS metadata, class:" + xds_class_raw.get(this.getCC1WithoutParity());
            if (this.getCC1WithoutParity() == 1) {
                res = res + ",type:" + current_type.get(this.getCC2WithoutParity());
            }
            return res;
        }
        if (this.isMidRowStyleCode()) {
            return String.format("Mid Row Code: channel: %1$d, style: %2$d [%3$s], underline: %4$d", this.getChannel(), this.getStyle(), style_list.get(this.getStyle(), "??"), this.getUnderline());
        }
        if (this.isSpecialNorthAmericancharacter()) {
            return String.format("Special North American character: channel: %1$d, char: %2$c", this.getChannel(), Cea608.SPECIAL_CHARACTER_SET[this.cc_data_2 & 0xF]);
        }
        if (this.isStandardChar()) {
            return this.formatStandardChar();
        }
        String msg = String.format("Not implemented: cc_data_1: %1$#04x, cc_data_2: %2$#04x", this.getCC1WithoutParity(), this.getCC2WithoutParity());
        logger.warning(msg);
        return msg;
    }

    private boolean isStandardChar() {
        return (this.cc_data_1 & 0x60) != 0;
    }

    private String formatStandardChar() {
        int cc1WithoutParity = this.getCC1WithoutParity();
        int cc2WithoutParity = this.getCC2WithoutParity();
        if (cc2WithoutParity != 0 && cc2WithoutParity < 32) {
            String s = String.format("char less than 0x20, cc_data1: %1$#04x, cc_data1: %2$#04x", cc1WithoutParity, cc2WithoutParity);
            logger.warning(s);
            return s;
        }
        if (cc2WithoutParity != 0) {
            return String.format("%1$c %2$c", Cea608.BASIC_CHARACTER_SET[cc1WithoutParity - 32], Cea608.BASIC_CHARACTER_SET[cc2WithoutParity - 32]);
        }
        return String.format("%1$c [pad]", Cea608.BASIC_CHARACTER_SET[cc1WithoutParity - 32]);
    }

    int getUnderline() {
        return this.cc_data_2 & 1;
    }

    int getStyle() {
        return (this.cc_data_2 & 0xE) >>> 1;
    }

    int getCursor() {
        return (this.cc_data_2 & 6) >>> 1;
    }

    int getNextRowDownToggle() {
        return (this.cc_data_2 & 0x20) >>> 5;
    }

    int getRow() {
        return this.cc_data_1 & 7;
    }

    int getChannel() {
        return 1 + ((this.cc_data_1 & 8) >>> 3);
    }

    private boolean isSpecialNorthAmericancharacter() {
        return (this.cc_data_1 & 0x77) == 17 && (this.cc_data_2 & 0x70) == 48;
    }

    public boolean isMidRowStyleCode() {
        return (this.cc_data_1 & 0x77) == 17 && (this.cc_data_2 & 0x70) == 32;
    }

    public boolean isControl() {
        return (this.cc_data_1 & 0x76) == 20 && (this.cc_data_2 & 0x70) == 32;
    }

    public boolean isTab() {
        return (this.cc_data_1 & 0x77) == 23 && (this.cc_data_2 & 0x7C) == 32;
    }

    public boolean isRowPreambleStyle() {
        return (this.cc_data_1 & 0x70) == 16 && (this.cc_data_2 & 0x50) == 64;
    }

    public boolean isRowPreambleAddress() {
        return (this.cc_data_1 & 0x70) == 16 && (this.cc_data_2 & 0x50) == 80;
    }

    public boolean isXDSControl() {
        return this.cc_type == 1 && (this.cc_data_1 & 0x70) == 0;
    }

    static {
        lookupType.put(0, current_type);
        lookupType.put(1, future_type);
        lookupType.put(2, channel_type);
        lookupType.put(3, misc_type);
        lookupType.put(4, public_service_type);
    }
}

