/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.common;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class ST2094_10_Data
implements TreeNode {
    LookUpList ext_block_level_list = new LookUpList.Builder().add(0, "Reserved").add(1, "Level 1 Metadata - Content Range").add(2, "Level 2 Metadata - Trim Pass ").add(3, "Reserved").add(4, "Reserved").add(5, "Level 5 Metadata - Active Area").add(6, 255, "Reserved ").build();
    private int app_identifier;
    private int app_version;
    private int metadata_refresh_flag;
    private int num_ext_blocks;
    private List<ExtDmDataBlock> ext_dm_data_blockList = new ArrayList<ExtDmDataBlock>();

    public ST2094_10_Data(byte[] data, int offset, int len) {
        BitSource bitSource = new BitSource(data, offset);
        this.app_identifier = bitSource.ue();
        this.app_version = bitSource.ue();
        this.metadata_refresh_flag = bitSource.u(1);
        if (this.metadata_refresh_flag == 1) {
            this.num_ext_blocks = bitSource.ue();
            bitSource.skiptoByteBoundary();
            for (int i = 0; i < this.num_ext_blocks; ++i) {
                ExtDmDataBlock ext_dm_data_block = new ExtDmDataBlock(bitSource);
                this.ext_dm_data_blockList.add(ext_dm_data_block);
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ST2094-10_data()"));
        t.add(new DefaultMutableTreeNode(new KVP("app_identifier", this.app_identifier, null)));
        t.add(new DefaultMutableTreeNode(new KVP("app_version", this.app_version, null)));
        t.add(new DefaultMutableTreeNode(new KVP("metadata_refresh_flag", this.metadata_refresh_flag, null)));
        if (this.metadata_refresh_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("num_ext_blocks", this.num_ext_blocks, null)));
            Utils.addListJTree(t, this.ext_dm_data_blockList, modus, "CC ext_dm_data_block_list");
        }
        return t;
    }

    private class ExtDmDataBlock
    implements TreeNode {
        private int ext_block_length;
        private int ext_block_level;
        private int min_PQ;
        private int max_PQ;
        private int avg_PQ;
        private int target_max_PQ;
        private int trim_slope;
        private int trim_offset;
        private int trim_power;
        private int trim_chroma_weight;
        private int trim_saturation_gain;
        private int ms_weight;
        private int active_area_left_offset;
        private int active_area_right_offset;
        private int active_area_top_offset;
        private int active_area_bottom_offset;

        public ExtDmDataBlock(BitSource bitSource) {
            this.ext_block_length = bitSource.ue();
            this.ext_block_level = bitSource.u(8);
            int ext_block_len_bits = 8 * this.ext_block_length;
            int ext_block_use_bits = 0;
            if (this.ext_block_level == 1) {
                this.min_PQ = bitSource.u(12);
                this.max_PQ = bitSource.u(12);
                this.avg_PQ = bitSource.u(12);
                ext_block_use_bits += 36;
            }
            if (this.ext_block_level == 2) {
                this.target_max_PQ = bitSource.u(12);
                this.trim_slope = bitSource.u(12);
                this.trim_offset = bitSource.u(12);
                this.trim_power = bitSource.u(12);
                this.trim_chroma_weight = bitSource.u(12);
                this.trim_saturation_gain = bitSource.u(12);
                this.ms_weight = bitSource.i(13);
                ext_block_use_bits += 85;
            }
            if (this.ext_block_level == 5) {
                this.active_area_left_offset = bitSource.u(13);
                this.active_area_right_offset = bitSource.u(13);
                this.active_area_top_offset = bitSource.u(13);
                this.active_area_bottom_offset = bitSource.u(13);
                ext_block_use_bits += 52;
            }
            while (ext_block_use_bits++ < ext_block_len_bits) {
                int n = bitSource.f(1);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("ext_dm_data_block"));
            t.add(new DefaultMutableTreeNode(new KVP("ext_block_length", this.ext_block_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ext_block_level", this.ext_block_level, ST2094_10_Data.this.ext_block_level_list.get(this.ext_block_level))));
            if (this.ext_block_level == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("min_PQ", this.min_PQ, "minimum luminance value of current picture in 12-bit PQ encoding")));
                t.add(new DefaultMutableTreeNode(new KVP("max_PQ", this.max_PQ, "maximum luminance value of current picture in 12-bit PQ encoding")));
                t.add(new DefaultMutableTreeNode(new KVP("avg_PQ", this.avg_PQ, "midpoint luminance value of current picture in 12-bit PQ encoding")));
            }
            if (this.ext_block_level == 2) {
                t.add(new DefaultMutableTreeNode(new KVP("target_max_PQ", this.target_max_PQ, "maximum luminance value of a target display in 12-bit PQ encoding")));
                t.add(new DefaultMutableTreeNode(new KVP("trim_slope", this.trim_slope, "slope metadata")));
                t.add(new DefaultMutableTreeNode(new KVP("trim_offset", this.trim_offset, "offset metadata")));
                t.add(new DefaultMutableTreeNode(new KVP("trim_power", this.trim_power, "power metadata")));
                t.add(new DefaultMutableTreeNode(new KVP("trim_chroma_weight", this.trim_chroma_weight, " chroma weight metadata")));
                t.add(new DefaultMutableTreeNode(new KVP("trim_saturation_gain", this.trim_saturation_gain, "saturation gain metadata")));
                t.add(new DefaultMutableTreeNode(new KVP("ms_weight", this.ms_weight, "reserved for future specification")));
            }
            if (this.ext_block_level == 5) {
                t.add(new DefaultMutableTreeNode(new KVP("active_area_left_offset", this.active_area_left_offset, null)));
                t.add(new DefaultMutableTreeNode(new KVP("active_area_right_offset", this.active_area_right_offset, null)));
                t.add(new DefaultMutableTreeNode(new KVP("active_area_top_offset", this.active_area_top_offset, null)));
                t.add(new DefaultMutableTreeNode(new KVP("active_area_bottom_offset", this.active_area_bottom_offset, null)));
            }
            return t;
        }
    }
}

