/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video.jpegxs;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.mpeg.JpegXsVideoDescriptor;
import nl.digitalekabeltelevisie.util.BitSource;

public class JpegXsDataField
extends PesPacketData {
    private final long jxes_length;
    private final long jxes_box_code;
    private final long brat;
    private final long frat;
    private final long schar;
    private final long ppih;
    private final long plev;
    private final long color_primaries;
    private final long transfer_characteristics;
    private final long matrix_coefficients;
    private final int video_full_range_flag;
    private final long tcod;

    public JpegXsDataField(PesPacketData pesPacket) {
        super(pesPacket);
        BitSource reader = new BitSource(this.data, this.pesDataStart);
        this.jxes_length = reader.readBitsLong(32);
        this.jxes_box_code = reader.readBitsLong(32);
        this.brat = reader.readBitsLong(32);
        this.frat = reader.readBitsLong(32);
        this.schar = reader.readBitsLong(16);
        this.ppih = reader.readBitsLong(16);
        this.plev = reader.readBitsLong(16);
        this.color_primaries = reader.readBitsLong(8);
        this.transfer_characteristics = reader.readBitsLong(8);
        this.matrix_coefficients = reader.readBitsLong(8);
        this.video_full_range_flag = reader.readBits(1);
        reader.skiptoByteBoundary();
        this.tcod = reader.readBitsLong(4);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP jxes_node = new KVP("JPEG-XS payload");
        jxes_node.add(new KVP("JXES Length", this.jxes_length));
        jxes_node.add(new KVP("JXES Box Code", this.jxes_box_code).setDescription("\"jxes\""));
        jxes_node.add(new KVP("brat", this.brat, "Bit Rate (MBits/s)"));
        jxes_node.add(JpegXsVideoDescriptor.buildFratNode(this.frat));
        jxes_node.add(JpegXsVideoDescriptor.buildScharNode(this.schar));
        jxes_node.add(JpegXsVideoDescriptor.buildPpihNode(this.ppih));
        jxes_node.add(JpegXsVideoDescriptor.buildPlevNode(this.plev));
        jxes_node.add(new KVP("colour_primaries", this.color_primaries));
        jxes_node.add(new KVP("transfer_characteristics", this.transfer_characteristics));
        jxes_node.add(new KVP("matrix_coefficients", this.matrix_coefficients));
        jxes_node.add(new KVP("video_full_range_flag", this.video_full_range_flag));
        jxes_node.add(new KVP("tcod", this.tcod));
        DefaultMutableTreeNode parent_node = super.getJTreeNode(modus, new KVP("JPEG-XS PES Packet"));
        parent_node.add(jxes_node);
        return parent_node;
    }
}

