/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class HrdParameters
implements TreeNode {
    private int cpb_cnt_minus1;
    private int bit_rate_scale;
    private int cpb_size_scale;
    private List<CPB> cpbs = new ArrayList<CPB>();
    private int initial_cpb_removal_delay_length_minus1;
    private int cpb_removal_delay_length_minus1;
    private int dpb_output_delay_length_minus1;
    private int time_offset_length;

    public HrdParameters(BitSource bitSource) {
        this.cpb_cnt_minus1 = bitSource.ue();
        this.bit_rate_scale = bitSource.u(4);
        this.cpb_size_scale = bitSource.u(4);
        for (int schedSelIdx = 0; schedSelIdx <= this.cpb_cnt_minus1; ++schedSelIdx) {
            CPB cpb = new CPB(bitSource);
            this.cpbs.add(cpb);
        }
        this.initial_cpb_removal_delay_length_minus1 = bitSource.u(5);
        this.cpb_removal_delay_length_minus1 = bitSource.u(5);
        this.dpb_output_delay_length_minus1 = bitSource.u(5);
        this.time_offset_length = bitSource.u(5);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("hrd_parameters"));
        t.add(new DefaultMutableTreeNode(new KVP("cpb_cnt_minus1", this.cpb_cnt_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bit_rate_scale", this.bit_rate_scale, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cpb_size_scale", this.cpb_size_scale, null)));
        Utils.addListJTree(t, this.cpbs, modus, "CPBs");
        t.add(new DefaultMutableTreeNode(new KVP("initial_cpb_removal_delay_length_minus1", this.initial_cpb_removal_delay_length_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("cpb_removal_delay_length_minus1", this.cpb_removal_delay_length_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("dpb_output_delay_length_minus1", this.dpb_output_delay_length_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("time_offset_length", this.time_offset_length, null)));
        return t;
    }

    public static class CPB
    implements TreeNode {
        private int bit_rate_value_minus1;
        private int cpb_size_value_minus1;
        private int cbr_flag;

        private CPB(BitSource bitSource) {
            this.bit_rate_value_minus1 = bitSource.ue();
            this.cpb_size_value_minus1 = bitSource.ue();
            this.cbr_flag = bitSource.u(1);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("CPB"));
            t.add(new DefaultMutableTreeNode(new KVP("bit_rate_value_minus1", this.bit_rate_value_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("cpb_size_value_minus1", this.cpb_size_value_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("cbr_flag", this.cbr_flag, null)));
            return t;
        }
    }
}

