/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Access_unit_delimiter_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.End_of_sequence_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.NalUnitHeaderMvcExtension;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Pic_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Slice_layer_extension_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Slice_layer_without_partitioning_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Subset_seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractNALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Filler_data_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;

public class NALUnit
extends AbstractNALUnit
implements TreeNode {
    private final int forbidden_zero_bit;
    private final int nal_ref_idc;
    private final int nal_unit_type;
    private int svc_extension_flag;
    private int avc_3d_extension_flag;
    NalUnitHeaderMvcExtension nalUnitHeaderMvcExtension;

    public NALUnit(byte[] bytes, int offset, int len) {
        super(bytes, offset, len);
        this.forbidden_zero_bit = this.bs.readBits(1);
        this.nal_ref_idc = this.bs.readBits(2);
        this.nal_unit_type = this.bs.readBits(5);
        if (this.nal_unit_type == 14 || this.nal_unit_type == 20 || this.nal_unit_type == 21) {
            if (this.nal_unit_type != 21) {
                this.svc_extension_flag = this.bs.u(1);
            } else {
                this.avc_3d_extension_flag = this.bs.u(1);
            }
            if (this.svc_extension_flag == 1) {
                logger.warning("Not implemented nal_unit_header_svc_extension");
                this.bs.readBits(24);
            } else if (this.avc_3d_extension_flag == 1) {
                logger.warning("Not implemented al_unit_header_3davc_extension");
                this.bs.readBits(16);
            } else {
                this.nalUnitHeaderMvcExtension = new NalUnitHeaderMvcExtension(this.bs);
            }
        }
        this.readRBSPBytes();
        this.createRBSP();
    }

    @Override
    protected void createRBSP() {
        if (this.nal_unit_type == 1) {
            this.rbsp = new Slice_layer_without_partitioning_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 5) {
            this.rbsp = new Slice_layer_without_partitioning_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 6) {
            this.rbsp = new Sei_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 7) {
            this.rbsp = new Seq_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 8) {
            this.rbsp = new Pic_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 9) {
            this.rbsp = new Access_unit_delimiter_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 10) {
            this.rbsp = new End_of_sequence_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 12) {
            this.rbsp = new Filler_data_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 15) {
            this.rbsp = new Subset_seq_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
        } else if (this.nal_unit_type == 20) {
            this.rbsp = new Slice_layer_extension_rbsp(this.rbsp_byte, this.numBytesInRBSP, this.svc_extension_flag, this.avc_3d_extension_flag);
        } else {
            logger.warning("not implemented nal_unit_type: " + this.nal_unit_type + " (" + this.getNALUnitTypeString(this.nal_unit_type) + ")");
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("NALUnit (" + this.getNALUnitTypeString(this.nal_unit_type) + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("bytes", this.bytes, this.offset, this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("numBytesInNALunit", this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("forbidden_zero_bit", this.forbidden_zero_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nal_ref_idc", this.nal_ref_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nal_unit_type", this.nal_unit_type, this.getNALUnitTypeString(this.nal_unit_type))));
        if (this.nal_unit_type == 14 || this.nal_unit_type == 20 || this.nal_unit_type == 21) {
            if (this.nal_unit_type != 21) {
                t.add(new DefaultMutableTreeNode(new KVP("svc_extension_flag", this.svc_extension_flag, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("avc_3d_extension_flag", this.avc_3d_extension_flag, null)));
            }
            if (this.svc_extension_flag == 1) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("nal_unit_header_svc_extension()")));
            } else if (this.avc_3d_extension_flag == 1) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("nal_unit_header_3davc_extension()")));
            } else {
                t.add(this.nalUnitHeaderMvcExtension.getJTreeNode(modus));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("rbsp_byte", this.rbsp_byte, 0, this.numBytesInRBSP, null)));
        t.add(new DefaultMutableTreeNode(new KVP("NumBytesInRBSP", this.numBytesInRBSP, null)));
        if (this.rbsp != null) {
            t.add(this.rbsp.getJTreeNode(modus));
        }
        return t;
    }

    @Override
    public String getNALUnitTypeString(int nal_unit_type) {
        switch (nal_unit_type) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Coded slice of a non-IDR picture";
            }
            case 2: {
                return "Coded slice data partition A";
            }
            case 3: {
                return "Coded slice data partition B";
            }
            case 4: {
                return "Coded slice data partition C";
            }
            case 5: {
                return "Coded slice of an IDR picture";
            }
            case 6: {
                return "Supplemental enhancement information (SEI)";
            }
            case 7: {
                return "Sequence parameter set";
            }
            case 8: {
                return "Picture parameter set";
            }
            case 9: {
                return "Access unit delimiter";
            }
            case 10: {
                return "End of sequence";
            }
            case 11: {
                return "End of stream";
            }
            case 12: {
                return "Filler data";
            }
            case 13: {
                return "Sequence parameter set extension";
            }
            case 14: {
                return "Prefix NAL unit";
            }
            case 15: {
                return "Subset sequence parameter set";
            }
            case 16: {
                return "Depth parameter set";
            }
            case 19: {
                return "Coded slice of an auxiliary coded picture without partitioning";
            }
            case 20: {
                return "Coded slice extension";
            }
            case 21: {
                return "Coded slice extension for a depth view component or a 3D-AVC texture view component";
            }
            case 24: {
                return "Single-time aggregation packet without DON (STAP-A) RFC 6184";
            }
            case 25: {
                return "Single-time aggregation packet including DON (STAP-B) RFC 6184";
            }
            case 26: {
                return "Multi-time aggregation packet (MTAP16) RFC 6184";
            }
            case 27: {
                return "Multi-time aggregation packet (MTAP24) RFC 6184";
            }
            case 28: {
                return "Fragmentation unit (FU-A) RFC 6184";
            }
            case 29: {
                return "Fragmentation unit (FU-B) RFC 6184";
            }
        }
        return "reserved";
    }

    public int getForbidden_zero_bit() {
        return this.forbidden_zero_bit;
    }

    public int getNal_ref_idc() {
        return this.nal_ref_idc;
    }

    public int getNal_unit_type() {
        return this.nal_unit_type;
    }
}

