/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.VuiParameters;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.BitSource;

public class Seq_parameter_set_data {
    private static final Logger logger = Logger.getLogger(Seq_parameter_set_data.class.getName());
    private int bit_depth_chroma_minus8;
    private int bit_depth_luma_minus8;
    private int chroma_format_idc;
    private final int constraint_set0_flag;
    private final int constraint_set1_flag;
    private final int constraint_set2_flag;
    private final int constraint_set3_flag;
    private final int constraint_set4_flag;
    private final int constraint_set5_flag;
    private final int[][] delta_scale = new int[8][];
    private final int[] deltas_read = new int[8];
    private final int direct_8x8_inference_flag;
    private int frame_crop_bottom_offset;
    private int frame_crop_left_offset;
    private int frame_crop_right_offset;
    private int frame_crop_top_offset;
    private final int frame_cropping_flag;
    private final int frame_mbs_only_flag;
    private final int gaps_in_frame_num_value_allowed_flag;
    private final int level_idc;
    private final int log2_max_frame_num_minus4;
    private int log2_max_pic_order_cnt_lsb_minus4;
    private final int max_num_ref_frames;
    private int mb_adaptive_frame_field_flag;
    private final int pic_height_in_map_units_minus1;
    private final int pic_order_cnt_type;
    private final int pic_width_in_mbs_minus1;
    private final int profile_idc;
    private int qpprime_y_zero_transform_bypass_flag;
    private final int reserved_zero_2bits;
    private int separate_colour_plane_flag;
    private final int seq_parameter_set_id;
    private final int[] seq_scaling_list_present_flag = new int[8];
    private int seq_scaling_matrix_present_flag;
    private VuiParameters vui_parameters;
    private final int vui_parameters_present_flag;

    public Seq_parameter_set_data(BitSource bitSource) {
        this.profile_idc = bitSource.u(8);
        this.constraint_set0_flag = bitSource.u(1);
        this.constraint_set1_flag = bitSource.u(1);
        this.constraint_set2_flag = bitSource.u(1);
        this.constraint_set3_flag = bitSource.u(1);
        this.constraint_set4_flag = bitSource.u(1);
        this.constraint_set5_flag = bitSource.u(1);
        this.reserved_zero_2bits = bitSource.u(2);
        this.level_idc = bitSource.u(8);
        this.seq_parameter_set_id = bitSource.ue();
        if (this.profile_idc == 100 || this.profile_idc == 110 || this.profile_idc == 122 || this.profile_idc == 144 || this.profile_idc == 44 || this.profile_idc == 83 || this.profile_idc == 86 || this.profile_idc == 118 || this.profile_idc == 128) {
            this.chroma_format_idc = bitSource.ue();
            if (this.chroma_format_idc == 3) {
                this.separate_colour_plane_flag = bitSource.u(1);
            }
            this.bit_depth_luma_minus8 = bitSource.ue();
            this.bit_depth_chroma_minus8 = bitSource.ue();
            this.qpprime_y_zero_transform_bypass_flag = bitSource.u(1);
            this.seq_scaling_matrix_present_flag = bitSource.u(1);
            if (this.seq_scaling_matrix_present_flag == 1) {
                for (int i = 0; i < (this.chroma_format_idc != 3 ? 8 : 12); ++i) {
                    this.seq_scaling_list_present_flag[i] = bitSource.u(1);
                    if (this.seq_scaling_list_present_flag[i] == 0) continue;
                    if (i < 6) {
                        this.delta_scale[i] = new int[16];
                        this.deltas_read[i] = RBSP.scaling_list(this.delta_scale[i], 16, bitSource);
                        continue;
                    }
                    this.delta_scale[i] = new int[64];
                    this.deltas_read[i] = RBSP.scaling_list(this.delta_scale[i], 64, bitSource);
                }
            }
        }
        this.log2_max_frame_num_minus4 = bitSource.ue();
        this.pic_order_cnt_type = bitSource.ue();
        if (this.pic_order_cnt_type == 0) {
            this.log2_max_pic_order_cnt_lsb_minus4 = bitSource.ue();
        } else if (this.pic_order_cnt_type == 1) {
            logger.warning(" pic_order_cnt_type == 1 not implemented");
        }
        this.max_num_ref_frames = bitSource.ue();
        this.gaps_in_frame_num_value_allowed_flag = bitSource.u(1);
        this.pic_width_in_mbs_minus1 = bitSource.ue();
        this.pic_height_in_map_units_minus1 = bitSource.ue();
        this.frame_mbs_only_flag = bitSource.u(1);
        if (this.frame_mbs_only_flag == 0) {
            this.mb_adaptive_frame_field_flag = bitSource.u(1);
        }
        this.direct_8x8_inference_flag = bitSource.u(1);
        this.frame_cropping_flag = bitSource.u(1);
        if (this.frame_cropping_flag != 0) {
            this.frame_crop_left_offset = bitSource.ue();
            this.frame_crop_right_offset = bitSource.ue();
            this.frame_crop_top_offset = bitSource.ue();
            this.frame_crop_bottom_offset = bitSource.ue();
        }
        this.vui_parameters_present_flag = bitSource.u(1);
        if (this.vui_parameters_present_flag != 0) {
            this.vui_parameters = new VuiParameters(bitSource);
        }
    }

    public void addToJTree(DefaultMutableTreeNode t, int modus) {
        t.add(new DefaultMutableTreeNode(new KVP("profile_idc", this.profile_idc, Seq_parameter_set_data.getProfileIdcString(this.profile_idc))));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set0_flag", this.constraint_set0_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set1_flag", this.constraint_set1_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set2_flag", this.constraint_set2_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set3_flag", this.constraint_set3_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set4_flag", this.constraint_set4_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("constraint_set5_flag", this.constraint_set5_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_2bits", this.reserved_zero_2bits, null)));
        t.add(new DefaultMutableTreeNode(new KVP("level_idc", this.level_idc, null)));
        t.add(new DefaultMutableTreeNode(new KVP("seq_parameter_set_id", this.seq_parameter_set_id, null)));
        if (this.profile_idc == 100 || this.profile_idc == 110 || this.profile_idc == 122 || this.profile_idc == 244 || this.profile_idc == 44 || this.profile_idc == 83 || this.profile_idc == 86 || this.profile_idc == 118 || this.profile_idc == 128) {
            t.add(new DefaultMutableTreeNode(new KVP("chroma_format_idc", this.chroma_format_idc, RBSP.getChroma_format_idcString(this.chroma_format_idc))));
            if (this.chroma_format_idc == 3) {
                t.add(new DefaultMutableTreeNode(new KVP("separate_colour_plane_flag", this.separate_colour_plane_flag, null)));
            }
            t.add(new DefaultMutableTreeNode(new KVP("bit_depth_luma_minus8", this.bit_depth_luma_minus8, null)));
            t.add(new DefaultMutableTreeNode(new KVP("bit_depth_chroma_minus8", this.bit_depth_chroma_minus8, null)));
            t.add(new DefaultMutableTreeNode(new KVP("qpprime_y_zero_transform_bypass_flag", this.qpprime_y_zero_transform_bypass_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("seq_scaling_matrix_present_flag", this.seq_scaling_matrix_present_flag, null)));
            if (this.seq_scaling_matrix_present_flag == 1) {
                for (int i = 0; i < (this.chroma_format_idc != 3 ? 8 : 12); ++i) {
                    t.add(new DefaultMutableTreeNode(new KVP("seq_scaling_list_present_flag[" + i + "]", this.seq_scaling_list_present_flag[i], null)));
                    if (this.seq_scaling_list_present_flag[i] == 0) continue;
                    if (i < 6) {
                        t.add(RBSP.getScalingListJTree(this.delta_scale[i], i, 16, this.deltas_read[i]));
                        continue;
                    }
                    t.add(RBSP.getScalingListJTree(this.delta_scale[i], i, 64, this.deltas_read[i]));
                }
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("log2_max_frame_num_minus4", this.log2_max_frame_num_minus4, "MaxFrameNum=" + BitSource.powerOf2[this.log2_max_frame_num_minus4 + 4])));
        t.add(new DefaultMutableTreeNode(new KVP("pic_order_cnt_type", this.pic_order_cnt_type, null)));
        if (this.pic_order_cnt_type == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("log2_max_pic_order_cnt_lsb_minus4", this.log2_max_pic_order_cnt_lsb_minus4, null)));
        } else if (this.pic_order_cnt_type == 1) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("pic_order_cnt_type == 1")));
        }
        t.add(new DefaultMutableTreeNode(new KVP("max_num_ref_frames", this.max_num_ref_frames, null)));
        t.add(new DefaultMutableTreeNode(new KVP("gaps_in_frame_num_value_allowed_flag", this.gaps_in_frame_num_value_allowed_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_width_in_mbs_minus1", this.pic_width_in_mbs_minus1, "PicWidthInSamples=" + 16 * (this.pic_width_in_mbs_minus1 + 1))));
        t.add(new DefaultMutableTreeNode(new KVP("pic_height_in_map_units_minus1", this.pic_height_in_map_units_minus1, "PicHeightInSamples=" + (2 - this.frame_mbs_only_flag) * (this.pic_height_in_map_units_minus1 + 1) * 16)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_mbs_only_flag", this.frame_mbs_only_flag, this.frame_mbs_only_flag == 0 ? "coded pictures of the coded video sequence may either be coded fields or coded frames" : "every coded picture of the coded video sequence is a coded frame containing only frame macroblocks")));
        if (this.frame_mbs_only_flag == 0) {
            t.add(new DefaultMutableTreeNode(new KVP("mb_adaptive_frame_field_flag", this.mb_adaptive_frame_field_flag, this.mb_adaptive_frame_field_flag == 0 ? "no switching between frame and field macroblocks within a picture" : "possible use of switching between frame and field macroblocks within frames")));
        }
        t.add(new DefaultMutableTreeNode(new KVP("direct_8x8_inference_flag", this.direct_8x8_inference_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("frame_cropping_flag", this.frame_cropping_flag, null)));
        if (this.frame_cropping_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("frame_crop_left_offset", this.frame_crop_left_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("frame_crop_right_offset", this.frame_crop_right_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("frame_crop_top_offset", this.frame_crop_top_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("frame_crop_bottom_offset", this.frame_crop_bottom_offset, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("vui_parameters_present_flag", this.vui_parameters_present_flag, null)));
        if (this.vui_parameters_present_flag != 0) {
            t.add(this.vui_parameters.getJTreeNode(modus));
        }
    }

    public int getProfile_idc() {
        return this.profile_idc;
    }

    public int getConstraint_set0_flag() {
        return this.constraint_set0_flag;
    }

    public int getConstraint_set1_flag() {
        return this.constraint_set1_flag;
    }

    public int getConstraint_set2_flag() {
        return this.constraint_set2_flag;
    }

    public int getConstraint_set3_flag() {
        return this.constraint_set3_flag;
    }

    public int getConstraint_set4_flag() {
        return this.constraint_set4_flag;
    }

    public int getConstraint_set5_flag() {
        return this.constraint_set5_flag;
    }

    public int getReserved_zero_2bits() {
        return this.reserved_zero_2bits;
    }

    public int getLevel_idc() {
        return this.level_idc;
    }

    public int getSeq_parameter_set_id() {
        return this.seq_parameter_set_id;
    }

    public int getChroma_format_idc() {
        return this.chroma_format_idc;
    }

    public int getSeparate_colour_plane_flag() {
        return this.separate_colour_plane_flag;
    }

    public int getBit_depth_luma_minus8() {
        return this.bit_depth_luma_minus8;
    }

    public int getBit_depth_chroma_minus8() {
        return this.bit_depth_chroma_minus8;
    }

    public int getQpprime_y_zero_transform_bypass_flag() {
        return this.qpprime_y_zero_transform_bypass_flag;
    }

    public int getSeq_scaling_matrix_present_flag() {
        return this.seq_scaling_matrix_present_flag;
    }

    public int[] getSeq_scaling_list_present_flag() {
        return this.seq_scaling_list_present_flag;
    }

    public int[][] getDelta_scale() {
        return this.delta_scale;
    }

    public int[] getDeltas_read() {
        return this.deltas_read;
    }

    public int getLog2_max_frame_num_minus4() {
        return this.log2_max_frame_num_minus4;
    }

    public int getPic_order_cnt_type() {
        return this.pic_order_cnt_type;
    }

    public int getLog2_max_pic_order_cnt_lsb_minus4() {
        return this.log2_max_pic_order_cnt_lsb_minus4;
    }

    public int getMax_num_ref_frames() {
        return this.max_num_ref_frames;
    }

    public int getGaps_in_frame_num_value_allowed_flag() {
        return this.gaps_in_frame_num_value_allowed_flag;
    }

    public int getPic_width_in_mbs_minus1() {
        return this.pic_width_in_mbs_minus1;
    }

    public int getPic_height_in_map_units_minus1() {
        return this.pic_height_in_map_units_minus1;
    }

    public int getFrame_mbs_only_flag() {
        return this.frame_mbs_only_flag;
    }

    public int getMb_adaptive_frame_field_flag() {
        return this.mb_adaptive_frame_field_flag;
    }

    public int getDirect_8x8_inference_flag() {
        return this.direct_8x8_inference_flag;
    }

    public int getFrame_cropping_flag() {
        return this.frame_cropping_flag;
    }

    public int getFrame_crop_left_offset() {
        return this.frame_crop_left_offset;
    }

    public int getFrame_crop_right_offset() {
        return this.frame_crop_right_offset;
    }

    public int getFrame_crop_top_offset() {
        return this.frame_crop_top_offset;
    }

    public int getFrame_crop_bottom_offset() {
        return this.frame_crop_bottom_offset;
    }

    public int getVui_parameters_present_flag() {
        return this.vui_parameters_present_flag;
    }

    public VuiParameters getVui_parameters() {
        return this.vui_parameters;
    }

    public static String getProfileIdcString(int profile_idc) {
        switch (profile_idc) {
            case 66: {
                return "Baseline profile";
            }
            case 77: {
                return "Main profile";
            }
            case 88: {
                return "Extended profile";
            }
            case 100: {
                return "High profile";
            }
            case 110: {
                return "High 10 profile";
            }
            case 122: {
                return "High 4:2:2 profile";
            }
            case 44: {
                return "CAVLC 4:4:4 Intra profile";
            }
            case 144: {
                return "High 4:4:4 Predictive profile";
            }
            case 83: {
                return "Scalable Constrained High profile (SVC)";
            }
            case 86: {
                return "Scalable High Intra profile (SVC)";
            }
            case 118: {
                return "Stereo High profile (MVC)";
            }
            case 128: {
                return "Multiview High profile (MVC)";
            }
            case 138: {
                return "Multiview Depth High profile (MVCD)";
            }
            case 244: {
                return "High444 Predictive profile";
            }
            case 139: {
                return "Enhanced Multiview Depth High profile (MVCD)";
            }
        }
        return "unknown";
    }
}

