/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video264;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Access_unit_delimiter_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.NALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Pic_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Slice_header;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Slice_layer_extension_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Slice_layer_without_partitioning_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Video14496PESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Filler_data_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.H26xHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class Video14496Handler
extends H26xHandler<Video14496PESDataField, NALUnit>
implements ImageSource {
    @Override
    public BufferedImage getImage() {
        ArrayList<int[]> frameSize = new ArrayList<int[]>();
        ArrayList<ChartLabel> labels = new ArrayList<ChartLabel>();
        int[] accessUnitData = new int[6];
        int count = 0;
        H26xHandler.NALUnitIterator nalIter = new H26xHandler.NALUnitIterator(this);
        NALUnit unit = (NALUnit)nalIter.next();
        while (unit != null) {
            RBSP rbsp = unit.getRbsp();
            if (rbsp != null) {
                if (rbsp instanceof Access_unit_delimiter_rbsp || rbsp instanceof Seq_parameter_set_rbsp || rbsp instanceof Pic_parameter_set_rbsp || rbsp instanceof Sei_rbsp) {
                    count = Video14496Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
                    accessUnitData = new int[6];
                } else if (rbsp instanceof Slice_layer_without_partitioning_rbsp) {
                    Slice_layer_without_partitioning_rbsp slice_layer_without_partitioning_rbsp = (Slice_layer_without_partitioning_rbsp)rbsp;
                    Slice_header header = slice_layer_without_partitioning_rbsp.getSlice_header();
                    slice_type = header.getSlice_type();
                    size = unit.getNumBytesInRBSP();
                    int n = slice_type % 5;
                    accessUnitData[n] = accessUnitData[n] + size;
                } else if (rbsp instanceof Slice_layer_extension_rbsp) {
                    Slice_layer_extension_rbsp slice_layer_extension_rbsp = (Slice_layer_extension_rbsp)rbsp;
                    Slice_header header = slice_layer_extension_rbsp.getSlice_header();
                    if (header != null) {
                        slice_type = header.getSlice_type();
                        size = unit.getNumBytesInRBSP();
                        int n = slice_type % 5;
                        accessUnitData[n] = accessUnitData[n] + size;
                    }
                } else if (rbsp instanceof Filler_data_rbsp) {
                    int size = unit.getNumBytesInRBSP();
                    accessUnitData[5] = accessUnitData[5] + size;
                }
            }
            unit = (NALUnit)nalIter.next();
        }
        Video14496Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
        DefaultKeyedValues2DDataset dataset = new DefaultKeyedValues2DDataset();
        for (int i = 0; i < 6; ++i) {
            String type = Video14496Handler.getSlice_typeString(i);
            Iterator frameSizeIter = frameSize.iterator();
            for (ChartLabel l : labels) {
                if (!frameSizeIter.hasNext()) continue;
                int[] v = (int[])frameSizeIter.next();
                dataset.setValue(v[i], (Comparable)((Object)type), (Comparable)l);
            }
        }
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.0);
        renderer.setSeriesPaint(0, Color.BLUE);
        renderer.setSeriesPaint(1, Color.GREEN);
        renderer.setSeriesPaint(2, Color.RED);
        renderer.setSeriesPaint(3, Color.YELLOW);
        renderer.setSeriesPaint(4, Color.PINK);
        renderer.setSeriesPaint(5, Color.GRAY);
        CategoryAxis categoryAxis = new CategoryAxis("time");
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        NumberAxis valueAxis = new NumberAxis("frame size (bytes)");
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
        String title = String.valueOf(this.getPID().getLabelMaker()) + " (Access Units, Transmission Order)";
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        return chart.createBufferedImage(frameSize.size() * 18 + 100, 640);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("H.264 PES Data").addImageSource(this, "Frames"));
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        this.addCCDataToTree(modus, s);
        return s;
    }

    @Override
    protected Video14496PESDataField createH26xPESDataField(PesPacketData pesData) {
        return new Video14496PESDataField(pesData);
    }

    private static String getSlice_typeString(int slice_type) {
        switch (slice_type) {
            case 0: {
                return "P";
            }
            case 1: {
                return "B";
            }
            case 2: {
                return "I";
            }
            case 3: {
                return "SP";
            }
            case 4: {
                return "SI";
            }
            case 5: {
                return "Filler Data";
            }
        }
        return "??";
    }
}

