/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PesPacketData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Access_unit_delimiter_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265NALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.NALUnitType;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Pic_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Slice_segment_layer_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Video265PESDataField;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Video_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Filler_data_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.H26xHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.general.DefaultKeyedValues2DDataset;

public class H265Handler
extends H26xHandler<Video265PESDataField, H265NALUnit>
implements ImageSource {
    private static final int MAX_NAL_TYPES = 64;

    @Override
    protected void processPesDataBytes(PesPacketData pesData) {
        this.pesPackets.add(new Video265PESDataField(pesData));
    }

    @Override
    public BufferedImage getImage() {
        ArrayList<int[]> frameSize = new ArrayList<int[]>();
        ArrayList<ChartLabel> labels = new ArrayList<ChartLabel>();
        int[] accessUnitData = new int[64];
        boolean[] typeUsed = new boolean[64];
        int count = 0;
        H26xHandler.NALUnitIterator nalIter = new H26xHandler.NALUnitIterator(this);
        H265NALUnit unit = (H265NALUnit)nalIter.next();
        while (unit != null) {
            RBSP rbsp = unit.getRbsp();
            if (rbsp != null) {
                if (unit.getNuh_layer_id() == 0 && (rbsp instanceof Access_unit_delimiter_rbsp || rbsp instanceof Seq_parameter_set_rbsp || rbsp instanceof Pic_parameter_set_rbsp || rbsp instanceof Video_parameter_set_rbsp || rbsp instanceof Sei_rbsp)) {
                    count = H265Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
                    accessUnitData = new int[64];
                } else if (rbsp instanceof Slice_segment_layer_rbsp) {
                    int slice_type = unit.getNal_unit_type().getType();
                    int size = unit.getNumBytesInRBSP();
                    int n = slice_type;
                    accessUnitData[n] = accessUnitData[n] + size;
                    typeUsed[slice_type] = true;
                } else if (rbsp instanceof Filler_data_rbsp) {
                    int sliceType;
                    int size = unit.getNumBytesInRBSP();
                    int n = sliceType = NALUnitType.FD_NUT.getType();
                    accessUnitData[n] = accessUnitData[n] + size;
                    typeUsed[sliceType] = true;
                }
            }
            unit = (H265NALUnit)nalIter.next();
        }
        H265Handler.drawBarAccessUnit(frameSize, labels, accessUnitData, count);
        DefaultKeyedValues2DDataset dataset = new DefaultKeyedValues2DDataset();
        for (int i = 0; i < 64; ++i) {
            NALUnitType nalType = NALUnitType.getByType(i);
            if (nalType == null || !typeUsed[i]) continue;
            String typeName = nalType.name();
            Iterator frameSizeIter = frameSize.iterator();
            for (ChartLabel l : labels) {
                if (!frameSizeIter.hasNext()) continue;
                int[] v = (int[])frameSizeIter.next();
                dataset.setValue(v[i], (Comparable)((Object)typeName), (Comparable)l);
            }
        }
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.0);
        CategoryAxis categoryAxis = new CategoryAxis("time");
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
        NumberAxis valueAxis = new NumberAxis("frame size (bytes)");
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, valueAxis, renderer);
        String title = String.valueOf(this.getPID().getLabelMaker()) + " (Access Units, Transmission Order)";
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        return chart.createBufferedImage(frameSize.size() * 18 + 100, 640);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = new DefaultMutableTreeNode(new KVP("H.265 PES Data").addImageSource(this, "Frames"));
        Utils.addListJTree(s, this.pesPackets, modus, "PES Packets");
        this.addCCDataToTree(modus, s);
        return s;
    }

    @Override
    protected Video265PESDataField createH26xPESDataField(PesPacketData pesData) {
        return new Video265PESDataField(pesData);
    }
}

