/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Access_unit_delimiter_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.NALUnitType;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Pic_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Seq_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Slice_segment_layer_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.Video_parameter_set_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.AbstractNALUnit;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Filler_data_rbsp;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.Sei_rbsp;

public class H265NALUnit
extends AbstractNALUnit
implements TreeNode {
    private final int forbidden_zero_bit;
    private final NALUnitType nal_unit_type;
    private final int nuh_layer_id;
    private final int nuh_temporal_id_plus1;

    public H265NALUnit(byte[] bytes, int offset, int len) {
        super(bytes, offset, len);
        this.forbidden_zero_bit = this.bs.readBits(1);
        this.nal_unit_type = NALUnitType.getByType(this.bs.readBits(6));
        this.nuh_layer_id = this.bs.readBits(6);
        this.nuh_temporal_id_plus1 = this.bs.readBits(3);
        this.readRBSPBytes();
        this.createRBSP();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("NALUnit (" + this.nal_unit_type.name() + " " + this.nal_unit_type.getDescription() + ")"));
        t.add(new DefaultMutableTreeNode(new KVP("bytes", this.bytes, this.offset, this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("numBytesInNALunit", this.numBytesInNALunit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("forbidden_zero_bit", this.forbidden_zero_bit, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nal_unit_type", this.nal_unit_type.getType(), this.nal_unit_type.getDescription())));
        t.add(new DefaultMutableTreeNode(new KVP("nuh_layer_id", this.nuh_layer_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("nuh_temporal_id_plus1", this.nuh_temporal_id_plus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("rbsp_byte", this.rbsp_byte, 0, this.numBytesInRBSP, null)));
        t.add(new DefaultMutableTreeNode(new KVP("NumBytesInRBSP", this.numBytesInRBSP, null)));
        if (this.rbsp != null) {
            t.add(this.rbsp.getJTreeNode(modus));
        }
        return t;
    }

    @Override
    public String getNALUnitTypeString(int nal_unit_type) {
        return NALUnitType.getDescription(nal_unit_type);
    }

    @Override
    protected void createRBSP() {
        try {
            switch (this.nal_unit_type) {
                case VPS_NUT: {
                    this.rbsp = new Video_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
                    break;
                }
                case SPS_NUT: {
                    this.rbsp = new Seq_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
                    break;
                }
                case PPS_NUT: {
                    this.rbsp = new Pic_parameter_set_rbsp(this.rbsp_byte, this.numBytesInRBSP);
                    break;
                }
                case AUD_NUT: {
                    this.rbsp = new Access_unit_delimiter_rbsp(this.rbsp_byte, this.numBytesInRBSP);
                    break;
                }
                case PREFIX_SEI_NUT: 
                case SUFFIX_SEI_NUT: {
                    this.rbsp = new Sei_rbsp(this.rbsp_byte, this.numBytesInRBSP);
                    break;
                }
                case TRAIL_N: 
                case TRAIL_R: 
                case TSA_N: 
                case TSA_R: 
                case STSA_N: 
                case STSA_R: 
                case RADL_N: 
                case RADL_R: 
                case RASL_N: 
                case RASL_R: 
                case BLA_W_LP: 
                case BLA_W_RADL: 
                case BLA_N_LP: 
                case IDR_W_RADL: 
                case IDR_N_LP: 
                case CRA_NUT: {
                    this.rbsp = new Slice_segment_layer_rbsp(this.rbsp_byte, this.numBytesInRBSP, this.nal_unit_type);
                    break;
                }
                case FD_NUT: {
                    this.rbsp = new Filler_data_rbsp(this.rbsp_byte, this.forbidden_zero_bit);
                    break;
                }
                default: {
                    logger.info("unimplemented nal_unit_type:" + this.nal_unit_type.getType() + ", " + this.nal_unit_type.getDescription());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warning("H265: Create NALUnit failed:  nal_unit_type:" + String.valueOf((Object)this.nal_unit_type) + ",exception=" + String.valueOf(e) + ", msg: " + e.getMessage());
        }
    }

    public int getForbidden_zero_bit() {
        return this.forbidden_zero_bit;
    }

    public NALUnitType getNal_unit_type() {
        return this.nal_unit_type;
    }

    public int getNuh_layer_id() {
        return this.nuh_layer_id;
    }

    public int getNuh_temporal_id_plus1() {
        return this.nuh_temporal_id_plus1;
    }
}

