/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;

public class ScalingListData
implements TreeNode {
    int[][] scaling_list_pred_mode_flag = new int[4][6];
    int[][] scaling_list_pred_matrix_id_delta = new int[4][6];
    int[][] scaling_list_dc_coef_minus8 = new int[4][6];
    int[][][] scalingList = new int[4][6][64];
    DefaultMutableTreeNode result = new DefaultMutableTreeNode(new KVP("scaling_list_data"));

    public ScalingListData(BitSource bs) {
        for (int sizeId = 0; sizeId < 4; ++sizeId) {
            for (int matrixId = 0; matrixId < 6; matrixId += sizeId == 3 ? 3 : 1) {
                int u;
                this.scaling_list_pred_mode_flag[sizeId][matrixId] = u = bs.u(1);
                this.result.add(new DefaultMutableTreeNode(new KVP("scaling_list_pred_mode_flag[" + sizeId + "][" + matrixId + "]", u, null)));
                if (this.scaling_list_pred_mode_flag[sizeId][matrixId] == 0) {
                    int ue;
                    this.scaling_list_pred_matrix_id_delta[sizeId][matrixId] = ue = bs.ue();
                    this.result.add(new DefaultMutableTreeNode(new KVP("scaling_list_pred_matrix_id_delta[" + sizeId + "][" + matrixId + "]", ue, null)));
                    continue;
                }
                int nextCoef = 8;
                int coefNum = Math.min(64, 1 << 4 + (sizeId << 1));
                if (sizeId > 1) {
                    int se;
                    this.scaling_list_dc_coef_minus8[sizeId - 2][matrixId] = se = bs.se();
                    this.result.add(new DefaultMutableTreeNode(new KVP("scaling_list_dc_coef_minus8[" + (sizeId - 2) + "][" + matrixId + "]", se, null)));
                    nextCoef = this.scaling_list_dc_coef_minus8[sizeId - 2][matrixId] + 8;
                }
                for (int i = 0; i < coefNum; ++i) {
                    int se;
                    int scaling_list_delta_coef = se = bs.se();
                    this.result.add(new DefaultMutableTreeNode(new KVP("scaling_list_delta_coef", se, "(sizeId:" + sizeId + ", matrixId:" + matrixId + ", i:" + i + ")")));
                    this.scalingList[sizeId][matrixId][i] = nextCoef = (nextCoef + scaling_list_delta_coef + 256) % 256;
                }
            }
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        return this.result;
    }
}

