/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video265;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265VuiParameters;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.ProfileTierLevel;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.ScalingListData;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.StRefPicSet;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Utils;

public class Seq_parameter_set_rbsp
extends RBSP {
    private static final Logger logger = Logger.getLogger(Seq_parameter_set_rbsp.class.getName());
    private final int sps_video_parameter_set_id;
    private final int sps_max_sub_layers_minus1;
    private final int sps_temporal_id_nesting_flag;
    private final ProfileTierLevel profile_tier_level;
    private final int sps_seq_parameter_set_id;
    private final int chroma_format_idc;
    private int separate_colour_plane_flag;
    private final int pic_width_in_luma_samples;
    private final int pic_height_in_luma_samples;
    private final int conformance_window_flag;
    private int conf_win_left_offset;
    private int conf_win_right_offset;
    private int conf_win_top_offset;
    private int conf_win_bottom_offset;
    private final int bit_depth_luma_minus8;
    private final int bit_depth_chroma_minus8;
    private final int log2_max_pic_order_cnt_lsb_minus4;
    private final int sps_sub_layer_ordering_info_present_flag;
    private final int[] sps_max_dec_pic_buffering_minus1;
    private final int[] sps_max_num_reorder_pics;
    private final int[] sps_max_latency_increase_plus1;
    private final int log2_min_luma_coding_block_size_minus3;
    private final int log2_diff_max_min_luma_coding_block_size;
    private final int log2_min_luma_transform_block_size_minus2;
    private final int log2_diff_max_min_luma_transform_block_size;
    private final int max_transform_hierarchy_depth_inter;
    private final int max_transform_hierarchy_depth_intra;
    private final int scaling_list_enabled_flag;
    private int sps_scaling_list_data_present_flag;
    private ScalingListData sps_scaling_list_data;
    private final int amp_enabled_flag;
    private final int sample_adaptive_offset_enabled_flag;
    private final int pcm_enabled_flag;
    private int pcm_sample_bit_depth_luma_minus1;
    private int pcm_sample_bit_depth_chroma_minus1;
    private int log2_min_pcm_luma_coding_block_size_minus3;
    private int log2_diff_max_min_pcm_luma_coding_block_size;
    private int pcm_loop_filter_disabled_flag;
    private final int num_short_term_ref_pic_sets;
    private List<StRefPicSet> stRefPicSetList = new ArrayList<StRefPicSet>();
    private int long_term_ref_pics_present_flag;
    private int num_long_term_ref_pics_sps;
    private int sps_temporal_mvp_enabled_flag;
    private int strong_intra_smoothing_enabled_flag;
    private int vui_parameters_present_flag;
    private H265VuiParameters vui_parameters;
    private int sps_extension_present_flag;
    private int sps_range_extension_flag;
    private int sps_multilayer_extension_flag;
    private int sps_3d_extension_flag;
    private int sps_scc_extension_flag;
    private int sps_extension_4bits;

    public Seq_parameter_set_rbsp(byte[] rbsp_bytes, int numBytesInRBSP) {
        super(rbsp_bytes, numBytesInRBSP);
        int i;
        this.sps_video_parameter_set_id = this.bitSource.u(4);
        this.sps_max_sub_layers_minus1 = this.bitSource.u(3);
        this.sps_temporal_id_nesting_flag = this.bitSource.u(1);
        this.profile_tier_level = new ProfileTierLevel(1, this.sps_max_sub_layers_minus1, this.bitSource);
        this.sps_seq_parameter_set_id = this.bitSource.ue();
        this.chroma_format_idc = this.bitSource.ue();
        if (this.chroma_format_idc == 3) {
            this.separate_colour_plane_flag = this.bitSource.u(1);
        }
        this.pic_width_in_luma_samples = this.bitSource.ue();
        this.pic_height_in_luma_samples = this.bitSource.ue();
        this.conformance_window_flag = this.bitSource.u(1);
        if (this.conformance_window_flag == 1) {
            this.conf_win_left_offset = this.bitSource.ue();
            this.conf_win_right_offset = this.bitSource.ue();
            this.conf_win_top_offset = this.bitSource.ue();
            this.conf_win_bottom_offset = this.bitSource.ue();
        }
        this.bit_depth_luma_minus8 = this.bitSource.ue();
        this.bit_depth_chroma_minus8 = this.bitSource.ue();
        this.log2_max_pic_order_cnt_lsb_minus4 = this.bitSource.ue();
        this.sps_sub_layer_ordering_info_present_flag = this.bitSource.u(1);
        this.sps_max_dec_pic_buffering_minus1 = new int[this.sps_max_sub_layers_minus1 + 1];
        this.sps_max_num_reorder_pics = new int[this.sps_max_sub_layers_minus1 + 1];
        this.sps_max_latency_increase_plus1 = new int[this.sps_max_sub_layers_minus1 + 1];
        int n = i = this.sps_sub_layer_ordering_info_present_flag == 1 ? 0 : this.sps_max_sub_layers_minus1;
        while (i <= this.sps_max_sub_layers_minus1) {
            this.sps_max_dec_pic_buffering_minus1[i] = this.bitSource.ue();
            this.sps_max_num_reorder_pics[i] = this.bitSource.ue();
            this.sps_max_latency_increase_plus1[i] = this.bitSource.ue();
            ++i;
        }
        this.log2_min_luma_coding_block_size_minus3 = this.bitSource.ue();
        this.log2_diff_max_min_luma_coding_block_size = this.bitSource.ue();
        this.log2_min_luma_transform_block_size_minus2 = this.bitSource.ue();
        this.log2_diff_max_min_luma_transform_block_size = this.bitSource.ue();
        this.max_transform_hierarchy_depth_inter = this.bitSource.ue();
        this.max_transform_hierarchy_depth_intra = this.bitSource.ue();
        this.scaling_list_enabled_flag = this.bitSource.u(1);
        if (this.scaling_list_enabled_flag == 1) {
            this.sps_scaling_list_data_present_flag = this.bitSource.u(1);
            if (this.sps_scaling_list_data_present_flag == 1) {
                this.sps_scaling_list_data = new ScalingListData(this.bitSource);
            }
        }
        this.amp_enabled_flag = this.bitSource.u(1);
        this.sample_adaptive_offset_enabled_flag = this.bitSource.u(1);
        this.pcm_enabled_flag = this.bitSource.u(1);
        if (this.pcm_enabled_flag == 1) {
            this.pcm_sample_bit_depth_luma_minus1 = this.bitSource.u(4);
            this.pcm_sample_bit_depth_chroma_minus1 = this.bitSource.u(4);
            this.log2_min_pcm_luma_coding_block_size_minus3 = this.bitSource.ue();
            this.log2_diff_max_min_pcm_luma_coding_block_size = this.bitSource.ue();
            this.pcm_loop_filter_disabled_flag = this.bitSource.u(1);
        }
        this.num_short_term_ref_pic_sets = this.bitSource.ue();
        if (this.num_short_term_ref_pic_sets != 0) {
            for (i = 0; i < this.num_short_term_ref_pic_sets; ++i) {
                StRefPicSet st_ref_pic_set = new StRefPicSet(i, this.num_short_term_ref_pic_sets, this.bitSource);
                if (st_ref_pic_set.notImplemented) {
                    return;
                }
                this.stRefPicSetList.add(st_ref_pic_set);
            }
        }
        this.long_term_ref_pics_present_flag = this.bitSource.u(1);
        if (this.long_term_ref_pics_present_flag == 1) {
            this.num_long_term_ref_pics_sps = this.bitSource.ue();
            logger.warning("long_term_ref_pics_present==1 not implemented");
        }
        this.sps_temporal_mvp_enabled_flag = this.bitSource.u(1);
        this.strong_intra_smoothing_enabled_flag = this.bitSource.u(1);
        this.vui_parameters_present_flag = this.bitSource.u(1);
        if (this.vui_parameters_present_flag == 1) {
            this.vui_parameters = new H265VuiParameters(this.sps_max_sub_layers_minus1, this.bitSource);
        }
        this.sps_extension_present_flag = this.bitSource.u(1);
        if (this.sps_extension_present_flag != 0) {
            this.sps_range_extension_flag = this.bitSource.u(1);
            this.sps_multilayer_extension_flag = this.bitSource.u(1);
            this.sps_3d_extension_flag = this.bitSource.u(1);
            this.sps_scc_extension_flag = this.bitSource.u(1);
            this.sps_extension_4bits = this.bitSource.u(6);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int i;
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("seq_parameter_set_rbsp"));
        t.add(new DefaultMutableTreeNode(new KVP("sps_video_parameter_set_id", this.sps_video_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sps_max_sub_layers_minus1", this.sps_max_sub_layers_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sps_temporal_id_nesting_flag", this.sps_temporal_id_nesting_flag, null)));
        t.add(this.profile_tier_level.getJTreeNode(modus));
        t.add(new DefaultMutableTreeNode(new KVP("sps_seq_parameter_set_id", this.sps_seq_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("chroma_format_idc", this.chroma_format_idc, Seq_parameter_set_rbsp.getChroma_format_idcString(this.chroma_format_idc))));
        if (this.chroma_format_idc == 3) {
            t.add(new DefaultMutableTreeNode(new KVP("separate_colour_plane_flag", this.separate_colour_plane_flag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("pic_width_in_luma_samples", this.pic_width_in_luma_samples, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pic_height_in_luma_samples", this.pic_height_in_luma_samples, null)));
        t.add(new DefaultMutableTreeNode(new KVP("conformance_window_flag", this.conformance_window_flag, null)));
        if (this.conformance_window_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("conf_win_left_offset", this.conf_win_left_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("conf_win_right_offset", this.conf_win_right_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("conf_win_top_offset", this.conf_win_top_offset, null)));
            t.add(new DefaultMutableTreeNode(new KVP("conf_win_bottom_offset", this.conf_win_bottom_offset, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("bit_depth_luma_minus8", this.bit_depth_luma_minus8, null)));
        t.add(new DefaultMutableTreeNode(new KVP("bit_depth_chroma_minus8", this.bit_depth_chroma_minus8, null)));
        t.add(new DefaultMutableTreeNode(new KVP("log2_max_pic_order_cnt_lsb_minus4", this.log2_max_pic_order_cnt_lsb_minus4, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sps_sub_layer_ordering_info_present_flag", this.sps_sub_layer_ordering_info_present_flag, null)));
        int n = i = this.sps_sub_layer_ordering_info_present_flag == 1 ? 0 : this.sps_max_sub_layers_minus1;
        while (i <= this.sps_max_sub_layers_minus1) {
            t.add(new DefaultMutableTreeNode(new KVP("sps_max_dec_pic_buffering_minus1[" + i + "]", this.sps_max_dec_pic_buffering_minus1[i], null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_max_num_reorder_pics[" + i + "]", this.sps_max_num_reorder_pics[i], null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_max_latency_increase_plus1[" + i + "]", this.sps_max_latency_increase_plus1[i], null)));
            ++i;
        }
        t.add(new DefaultMutableTreeNode(new KVP("log2_min_luma_coding_block_size_minus3", this.log2_min_luma_coding_block_size_minus3, null)));
        t.add(new DefaultMutableTreeNode(new KVP("log2_diff_max_min_luma_coding_block_size", this.log2_diff_max_min_luma_coding_block_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("log2_min_luma_transform_block_size_minus2", this.log2_min_luma_transform_block_size_minus2, null)));
        t.add(new DefaultMutableTreeNode(new KVP("log2_diff_max_min_luma_transform_block_size", this.log2_diff_max_min_luma_transform_block_size, null)));
        t.add(new DefaultMutableTreeNode(new KVP("max_transform_hierarchy_depth_inter", this.max_transform_hierarchy_depth_inter, null)));
        t.add(new DefaultMutableTreeNode(new KVP("max_transform_hierarchy_depth_intra", this.max_transform_hierarchy_depth_intra, null)));
        t.add(new DefaultMutableTreeNode(new KVP("scaling_list_enabled_flag", this.scaling_list_enabled_flag, null)));
        if (this.scaling_list_enabled_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("sps_scaling_list_data_present_flag_present_flag", this.sps_scaling_list_data_present_flag, null)));
            if (this.sps_scaling_list_data_present_flag == 1) {
                t.add(this.sps_scaling_list_data.getJTreeNode(modus));
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("amp_enabled_flag", this.amp_enabled_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("sample_adaptive_offset_enabled_flag", this.sample_adaptive_offset_enabled_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("pcm_enabled_flag", this.pcm_enabled_flag, null)));
        if (this.pcm_enabled_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("pcm_sample_bit_depth_luma_minus1", this.pcm_sample_bit_depth_luma_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("pcm_sample_bit_depth_chroma_minus1", this.pcm_sample_bit_depth_chroma_minus1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_min_pcm_luma_coding_block_size_minus3", this.log2_min_pcm_luma_coding_block_size_minus3, null)));
            t.add(new DefaultMutableTreeNode(new KVP("log2_diff_max_min_pcm_luma_coding_block_size", this.log2_diff_max_min_pcm_luma_coding_block_size, null)));
            t.add(new DefaultMutableTreeNode(new KVP("pcm_loop_filter_disabled_flag", this.pcm_loop_filter_disabled_flag, null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("num_short_term_ref_pic_sets", this.num_short_term_ref_pic_sets, null)));
        if (this.num_short_term_ref_pic_sets != 0) {
            Utils.addListJTree(t, this.stRefPicSetList, modus, "st_ref_pic_sets");
        }
        t.add(new DefaultMutableTreeNode(new KVP("long_term_ref_pics_present_flag", this.long_term_ref_pics_present_flag, null)));
        if (this.long_term_ref_pics_present_flag == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("num_long_term_ref_pics_sps", this.num_long_term_ref_pics_sps, null)));
            if (this.num_long_term_ref_pics_sps != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("num_long_term_ref_pics_sps!=0")));
                return t;
            }
        }
        t.add(new DefaultMutableTreeNode(new KVP("sps_temporal_mvp_enabled_flag", this.sps_temporal_mvp_enabled_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("strong_intra_smoothing_enabled_flag", this.strong_intra_smoothing_enabled_flag, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vui_parameters_present_flag", this.vui_parameters_present_flag, null)));
        if (this.vui_parameters_present_flag == 1) {
            t.add(this.vui_parameters.getJTreeNode(modus));
        }
        t.add(new DefaultMutableTreeNode(new KVP("sps_extension_present_flag", this.sps_extension_present_flag, null)));
        if (this.sps_extension_present_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("sps_range_extension_flag", this.sps_range_extension_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_multilayer_extension_flag", this.sps_multilayer_extension_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_3d_extension_flag", this.sps_3d_extension_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_scc_extension_flag", this.sps_scc_extension_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("sps_extension_4bits", this.sps_extension_4bits, null)));
            if (this.sps_range_extension_flag != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("sps_range_extension()")));
                return t;
            }
            if (this.sps_multilayer_extension_flag != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("sps_multilayer_extension()")));
                return t;
            }
            if (this.sps_3d_extension_flag != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("sps_3d_extension()")));
                return t;
            }
            if (this.sps_scc_extension_flag != 0) {
                t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("sps_scc_extension()")));
                return t;
            }
        }
        return t;
    }
}

