/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;

public class PictureHeaderStructure
implements TreeNode {
    private int ph_gdr_or_irap_pic_flag;
    private int ph_non_ref_pic_flag;
    private int ph_gdr_pic_flag;
    private int ph_inter_slice_allowed_flag;
    private int ph_intra_slice_allowed_flag;
    private int ph_pic_parameter_set_id;

    public PictureHeaderStructure(BitSource bitSource) {
        this.ph_gdr_or_irap_pic_flag = bitSource.u(1);
        this.ph_non_ref_pic_flag = bitSource.u(1);
        if (this.ph_gdr_or_irap_pic_flag != 0) {
            this.ph_gdr_pic_flag = bitSource.u(1);
        }
        this.ph_inter_slice_allowed_flag = bitSource.u(1);
        if (this.ph_inter_slice_allowed_flag != 0) {
            this.ph_intra_slice_allowed_flag = bitSource.u(1);
        }
        this.ph_pic_parameter_set_id = bitSource.ue();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("picture_header_structure"));
        t.add(new DefaultMutableTreeNode(new KVP("ph_gdr_or_irap_pic_flag", this.ph_gdr_or_irap_pic_flag, this.ph_gdr_or_irap_pic_flag == 1 ? "current picture is a GDR or IRAP picture" : "current picture is not a GDR")));
        t.add(new DefaultMutableTreeNode(new KVP("ph_non_ref_pic_flag", this.ph_non_ref_pic_flag, this.ph_non_ref_pic_flag == 1 ? "current picture is never used as a reference picture" : "current picture might or might not be used as a reference picture")));
        if (this.ph_gdr_or_irap_pic_flag != 0) {
            t.add(new DefaultMutableTreeNode(new KVP("ph_gdr_pic_flag", this.ph_gdr_pic_flag, this.ph_gdr_pic_flag == 1 ? "current picture is a GDR picture" : "current picture is not a GDR picture")));
        }
        DefaultMutableTreeNode ph_inter_slice_allowed_flag_node = new DefaultMutableTreeNode(new KVP("ph_inter_slice_allowed_flag", this.ph_inter_slice_allowed_flag, this.ph_inter_slice_allowed_flag == 0 ? "all coded slices of the picture have sh_slice_type equal to 2." : "there might or might not be one or more coded slices in the picture that have sh_slice_type equal to 0 or 1"));
        t.add(ph_inter_slice_allowed_flag_node);
        if (this.ph_inter_slice_allowed_flag != 0) {
            ph_inter_slice_allowed_flag_node.add(new DefaultMutableTreeNode(new KVP("ph_intra_slice_allowed_flag", this.ph_intra_slice_allowed_flag, this.ph_intra_slice_allowed_flag == 0 ? "all coded slices of the picture have sh_slice_type equal to 0 or 1" : "there might or might not be one or more coded slices in the picture that have sh_slice_type equal to 2")));
        }
        t.add(new DefaultMutableTreeNode(new KVP("ph_pic_parameter_set_id", this.ph_pic_parameter_set_id, null)));
        return t;
    }
}

