/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video266;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.ProfileTierLevel;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.RBSP;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.Utils;

public class Video_parameter_set_rbsp
extends RBSP {
    private static final Logger logger = Logger.getLogger(Video_parameter_set_rbsp.class.getName());
    private int vps_video_parameter_set_id;
    private int vps_max_layers_minus1;
    private int vps_max_sublayers_minus1;
    private int vps_default_ptl_dpb_hrd_max_tid_flag = 1;
    private int vps_all_independent_layers_flag = 1;
    private int[] vps_layer_id;
    private int[] vps_independent_layer_flag;
    private int[] vps_max_tid_ref_present_flag;
    private int[][] vps_direct_ref_layer_flag;
    private int[][] vps_max_tid_il_ref_pics_plus1;
    private int vps_each_layer_is_an_ols_flag;
    private int vps_ols_mode_idc = 2;
    private int vps_num_output_layer_sets_minus2;
    private int[][] vps_ols_output_layer_flag;
    private int vps_num_ptls_minus1;
    private int[] vps_pt_present_flag;
    private int[] vps_ptl_max_tid;
    private List<ProfileTierLevel> profile_tier_level_list = new ArrayList<ProfileTierLevel>();
    private int[] vps_ols_ptl_idx;
    private int TotalNumOlss;
    private int vps_num_dpb_params_minus1;
    private int vps_sublayer_dpb_params_present_flag;
    private int[] vps_dpb_max_tid;
    private int VpsNumDpbParams;
    private int vps_extension_data_flag;

    protected Video_parameter_set_rbsp(byte[] rbsp_bytes, int numBytesInRBSP) {
        super(rbsp_bytes, numBytesInRBSP);
        int j;
        int i;
        this.vps_video_parameter_set_id = this.bitSource.u(4);
        this.vps_max_layers_minus1 = this.bitSource.u(6);
        this.vps_max_sublayers_minus1 = this.bitSource.u(3);
        if (this.vps_max_layers_minus1 > 0 && this.vps_max_sublayers_minus1 > 0) {
            this.vps_default_ptl_dpb_hrd_max_tid_flag = this.bitSource.u(1);
        }
        if (this.vps_max_layers_minus1 > 0) {
            this.vps_all_independent_layers_flag = this.bitSource.u(1);
        }
        this.vps_layer_id = new int[this.vps_max_layers_minus1 + 1];
        this.vps_independent_layer_flag = new int[this.vps_max_layers_minus1 + 1];
        this.vps_max_tid_ref_present_flag = new int[this.vps_max_layers_minus1 + 1];
        this.vps_direct_ref_layer_flag = new int[this.vps_max_layers_minus1 + 1][this.vps_max_layers_minus1 + 1];
        this.vps_max_tid_il_ref_pics_plus1 = new int[this.vps_max_layers_minus1 + 1][this.vps_max_layers_minus1 + 1];
        for (i = 0; i <= this.vps_max_layers_minus1; ++i) {
            this.vps_layer_id[i] = this.bitSource.u(6);
            if (i <= 0 || this.vps_all_independent_layers_flag != 0) continue;
            this.vps_independent_layer_flag[i] = this.bitSource.u(1);
            if (this.vps_independent_layer_flag[i] != 0) continue;
            this.vps_max_tid_ref_present_flag[i] = this.bitSource.u(1);
            for (j = 0; j < i; ++j) {
                this.vps_direct_ref_layer_flag[i][j] = this.bitSource.u(1);
                if (this.vps_max_tid_ref_present_flag[i] == 0 || this.vps_direct_ref_layer_flag[i][j] == 0) continue;
                this.vps_max_tid_il_ref_pics_plus1[i][j] = this.bitSource.u(3);
            }
        }
        if (this.vps_max_layers_minus1 == 0) {
            this.vps_each_layer_is_an_ols_flag = 1;
        } else if (this.vps_all_independent_layers_flag == 0) {
            this.vps_each_layer_is_an_ols_flag = 1;
        }
        if (this.vps_max_layers_minus1 > 0) {
            if (this.vps_all_independent_layers_flag != 0) {
                this.vps_each_layer_is_an_ols_flag = this.bitSource.u(1);
            }
            if (this.vps_each_layer_is_an_ols_flag == 0) {
                if (this.vps_all_independent_layers_flag == 0) {
                    this.vps_ols_mode_idc = this.bitSource.u(2);
                }
                if (this.vps_ols_mode_idc == 2) {
                    this.vps_num_output_layer_sets_minus2 = this.bitSource.u(8);
                    this.vps_ols_output_layer_flag = new int[this.vps_num_output_layer_sets_minus2 + 2][this.vps_max_layers_minus1 + 1];
                    for (i = 1; i <= this.vps_num_output_layer_sets_minus2 + 1; ++i) {
                        for (j = 0; j <= this.vps_max_layers_minus1; ++j) {
                            this.vps_ols_output_layer_flag[i][j] = this.bitSource.u(1);
                        }
                    }
                }
            }
            this.vps_num_ptls_minus1 = this.bitSource.u(8);
        }
        this.vps_pt_present_flag = new int[this.vps_num_ptls_minus1 + 1];
        this.vps_pt_present_flag[0] = 1;
        this.vps_ptl_max_tid = new int[this.vps_num_ptls_minus1 + 1];
        if (this.vps_default_ptl_dpb_hrd_max_tid_flag == 1) {
            Arrays.fill(this.vps_ptl_max_tid, this.vps_max_sublayers_minus1);
        }
        for (i = 0; i <= this.vps_num_ptls_minus1; ++i) {
            if (i > 0) {
                this.vps_pt_present_flag[i] = this.bitSource.u(1);
            }
            if (this.vps_default_ptl_dpb_hrd_max_tid_flag != 0) continue;
            this.vps_ptl_max_tid[i] = this.bitSource.u(3);
        }
        this.bitSource.skiptoByteBoundary();
        for (int i2 = 0; i2 <= this.vps_num_ptls_minus1; ++i2) {
            ProfileTierLevel profile_tier_level = new ProfileTierLevel(this.vps_pt_present_flag[i2], this.vps_ptl_max_tid[i2], this.bitSource);
            this.profile_tier_level_list.add(profile_tier_level);
        }
        int olsModeIdc = this.calculateHelperOlsModeIdc();
        this.TotalNumOlss = this.calculateHelperTotalNumOlss(olsModeIdc);
        this.vps_ols_ptl_idx = new int[this.TotalNumOlss];
        if (this.vps_default_ptl_dpb_hrd_max_tid_flag == 1) {
            Arrays.fill(this.vps_ols_ptl_idx, this.vps_max_sublayers_minus1);
        }
        for (int i3 = 0; i3 < this.TotalNumOlss; ++i3) {
            if (this.vps_num_ptls_minus1 <= 0 || this.vps_num_ptls_minus1 + 1 == this.TotalNumOlss) continue;
            this.vps_ols_ptl_idx[i3] = this.bitSource.u(8);
        }
        if (this.vps_each_layer_is_an_ols_flag == 0) {
            logger.info("if(!vps_each_layer_is_an_ols_flag) Not implemented");
        } else {
            this.vps_extension_data_flag = this.bitSource.u(1);
        }
    }

    private int calculateHelperVpsNumDpbParams() {
        int VpsNumDpbParams = this.vps_each_layer_is_an_ols_flag != 0 ? 0 : this.vps_num_dpb_params_minus1 + 1;
        return VpsNumDpbParams;
    }

    private int calculateHelperTotalNumOlss(int olsModeIdc) {
        if (olsModeIdc == 4 || olsModeIdc == 0 || olsModeIdc == 1) {
            return this.vps_max_layers_minus1 + 1;
        }
        if (olsModeIdc == 2) {
            return this.vps_num_output_layer_sets_minus2 + 2;
        }
        return 0;
    }

    private int calculateHelperOlsModeIdc() {
        if (this.vps_each_layer_is_an_ols_flag == 0) {
            return this.vps_ols_mode_idc;
        }
        return 4;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        int j;
        int i;
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("video_parameter_set_rbsp"));
        t.add(new DefaultMutableTreeNode(new KVP("vps_video_parameter_set_id", this.vps_video_parameter_set_id, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_max_layers_minus1", this.vps_max_layers_minus1, null)));
        t.add(new DefaultMutableTreeNode(new KVP("vps_max_sublayers_minus1", this.vps_max_sublayers_minus1, null)));
        if (this.vps_max_layers_minus1 > 0 && this.vps_max_sublayers_minus1 > 0) {
            t.add(new DefaultMutableTreeNode(new KVP("vps_default_ptl_dpb_hrd_max_tid_flag", this.vps_default_ptl_dpb_hrd_max_tid_flag, null)));
        }
        if (this.vps_max_layers_minus1 > 0) {
            t.add(new DefaultMutableTreeNode(new KVP("vps_all_independent_layers_flag", this.vps_all_independent_layers_flag, null)));
        }
        for (i = 0; i <= this.vps_max_layers_minus1; ++i) {
            DefaultMutableTreeNode vps_layer_id_node = new DefaultMutableTreeNode(new KVP("vps_layer_id[" + i + "]", this.vps_layer_id[i], null));
            t.add(vps_layer_id_node);
            if (i <= 0 || this.vps_all_independent_layers_flag != 0) continue;
            vps_layer_id_node.add(new DefaultMutableTreeNode(new KVP("vps_independent_layer_flag[" + i + "]", this.vps_independent_layer_flag[i], null)));
            if (this.vps_independent_layer_flag[i] != 0) continue;
            vps_layer_id_node.add(new DefaultMutableTreeNode(new KVP("vps_max_tid_ref_present_flag[" + i + "]", this.vps_max_tid_ref_present_flag[i], null)));
            for (j = 0; j < i; ++j) {
                vps_layer_id_node.add(new DefaultMutableTreeNode(new KVP("vps_direct_ref_layer_flag[" + i + "][" + j + "]", this.vps_direct_ref_layer_flag[i][j], null)));
                if (this.vps_max_tid_ref_present_flag[i] == 0 || this.vps_direct_ref_layer_flag[i][j] == 0) continue;
                vps_layer_id_node.add(new DefaultMutableTreeNode(new KVP("vps_max_tid_il_ref_pics_plus1[" + i + "][" + j + "]", this.vps_max_tid_il_ref_pics_plus1[i][j], null)));
            }
        }
        if (this.vps_max_layers_minus1 > 0) {
            if (this.vps_all_independent_layers_flag != 0) {
                t.add(new DefaultMutableTreeNode(new KVP("vps_each_layer_is_an_ols_flag", this.vps_each_layer_is_an_ols_flag, null)));
            }
            if (this.vps_each_layer_is_an_ols_flag == 0) {
                if (this.vps_all_independent_layers_flag == 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("vps_ols_mode_idc", this.vps_ols_mode_idc, null)));
                }
                if (this.vps_ols_mode_idc == 2) {
                    DefaultMutableTreeNode vps_num_output_layer_sets_minus2_node = new DefaultMutableTreeNode(new KVP("vps_num_output_layer_sets_minus2", this.vps_num_output_layer_sets_minus2, null));
                    t.add(vps_num_output_layer_sets_minus2_node);
                    for (int i2 = 1; i2 <= this.vps_num_output_layer_sets_minus2 + 1; ++i2) {
                        for (j = 0; j <= this.vps_max_layers_minus1; ++j) {
                            vps_num_output_layer_sets_minus2_node.add(new DefaultMutableTreeNode(new KVP("vps_ols_output_layer_flag[" + i2 + "][" + j + "]", this.vps_ols_output_layer_flag[i2][j], null)));
                        }
                    }
                }
            }
            t.add(new DefaultMutableTreeNode(new KVP("vps_num_ptls_minus1", this.vps_num_ptls_minus1, null)));
        }
        for (i = 0; i <= this.vps_num_ptls_minus1; ++i) {
            if (i > 0) {
                t.add(new DefaultMutableTreeNode(new KVP("vps_pt_present_flag[" + i + "]", this.vps_pt_present_flag[i], null)));
            }
            if (this.vps_default_ptl_dpb_hrd_max_tid_flag != 0) continue;
            t.add(new DefaultMutableTreeNode(new KVP("vps_ptl_max_tid[" + i + "]", this.vps_ptl_max_tid[i], null)));
        }
        Utils.addListJTree(t, this.profile_tier_level_list, modus, "profile_tier_level(s)");
        for (i = 0; i < this.TotalNumOlss; ++i) {
            if (this.vps_num_ptls_minus1 <= 0 || this.vps_num_ptls_minus1 + 1 == this.TotalNumOlss) continue;
            t.add(new DefaultMutableTreeNode(new KVP("vps_ols_ptl_idx[" + i + "]", this.vps_ols_ptl_idx[i], null)));
        }
        t.add(new DefaultMutableTreeNode(new KVP("vps_each_layer_is_an_ols_flag", this.vps_each_layer_is_an_ols_flag, null)));
        if (this.vps_each_layer_is_an_ols_flag == 0) {
            t.add(new DefaultMutableTreeNode(GuiUtils.getNotImplementedKVP("if(!vps_each_layer_is_an_ols_flag)")));
            return t;
        }
        t.add(new DefaultMutableTreeNode(new KVP("vps_extension_data_flag", this.vps_extension_data_flag, null)));
        return t;
    }
}

