/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.Sei_message;
import nl.digitalekabeltelevisie.util.BitSource;

public class MasteringDisplayColourVolumeSei_message
extends Sei_message {
    private int[] display_primaries_x = new int[3];
    private int[] display_primaries_y = new int[3];
    private int white_point_x;
    private int white_point_y;
    private int max_display_mastering_luminance;
    private int min_display_mastering_luminance;

    public MasteringDisplayColourVolumeSei_message(BitSource bitSource) {
        super(bitSource);
        BitSource bitSourcePayload = new BitSource(this.payload, 0);
        for (int c = 0; c < 3; ++c) {
            this.display_primaries_x[c] = bitSourcePayload.u(16);
            this.display_primaries_y[c] = bitSourcePayload.u(16);
        }
        this.white_point_x = bitSourcePayload.u(16);
        this.white_point_y = bitSourcePayload.u(16);
        this.max_display_mastering_luminance = bitSourcePayload.u(32);
        this.min_display_mastering_luminance = bitSourcePayload.u(32);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode s = super.getJTreeNode(modus);
        for (int c = 0; c < 3; ++c) {
            s.add(new DefaultMutableTreeNode(new KVP("display_primaries_x[" + c + "]", this.display_primaries_x[c], MasteringDisplayColourVolumeSei_message.getCdm2x(this.display_primaries_x[c]))));
            s.add(new DefaultMutableTreeNode(new KVP("display_primaries_y[" + c + "]", this.display_primaries_y[c], MasteringDisplayColourVolumeSei_message.getCdm2y(this.display_primaries_y[c]))));
        }
        s.add(new DefaultMutableTreeNode(new KVP("white_point_x", this.white_point_x, MasteringDisplayColourVolumeSei_message.getCdm2x(this.white_point_x))));
        s.add(new DefaultMutableTreeNode(new KVP("white_point_y", this.white_point_y, MasteringDisplayColourVolumeSei_message.getCdm2y(this.white_point_y))));
        s.add(new DefaultMutableTreeNode(new KVP("max_display_mastering_luminance", this.max_display_mastering_luminance, this.getMax_display_mastering_luminanceString(this.max_display_mastering_luminance))));
        s.add(new DefaultMutableTreeNode(new KVP("min_display_mastering_luminance", this.min_display_mastering_luminance, this.getMin_display_mastering_luminance(this.min_display_mastering_luminance))));
        return s;
    }

    private String getMin_display_mastering_luminance(int min_display_mastering_luminance) {
        if (min_display_mastering_luminance >= 1 && min_display_mastering_luminance <= 50000) {
            return String.format("%.4f cd/m\u00b2", 1.0E-4 * (double)min_display_mastering_luminance);
        }
        return "unknown";
    }

    private String getMax_display_mastering_luminanceString(int max_display_mastering_luminance) {
        if (max_display_mastering_luminance >= 50000 && max_display_mastering_luminance <= 100000000) {
            return String.format("%.4f cd/m\u00b2", 1.0E-4 * (double)max_display_mastering_luminance);
        }
        return "unknown";
    }

    private static String getCdm2x(int i) {
        if (i >= 5 && i <= 37000) {
            return String.format("%.4f", (double)i * 2.0E-5);
        }
        return "unknown";
    }

    private static String getCdm2y(int i) {
        if (i >= 5 && i <= 42000) {
            return String.format("%.4f", (double)i * 2.0E-5);
        }
        return "unknown";
    }
}

