/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.AlternativeTransferCharacteristicsSei_message;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.ContentLightLevelInformationSei_message;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.MasteringDisplayColourVolumeSei_message;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.Sei_message;
import nl.digitalekabeltelevisie.data.mpeg.pes.video26x.sei.UserDataRegisteredItuT35Sei_message;
import nl.digitalekabeltelevisie.util.BitSource;

public class Sei_messageFactory {
    private static final Logger logger = Logger.getLogger(Sei_messageFactory.class.getName());
    private static List<Sei_message> sei_messages;

    public static List<Sei_message> buildSei_messageList(BitSource bitSource) {
        sei_messages = new ArrayList<Sei_message>();
        while (bitSource.available() >= 8 && bitSource.nextBits(8) != 128) {
            int nextPayloadType = bitSource.nextBits(8);
            try {
                sei_messages.add(switch (nextPayloadType) {
                    case 4 -> new UserDataRegisteredItuT35Sei_message(bitSource);
                    case 137 -> new MasteringDisplayColourVolumeSei_message(bitSource);
                    case 144 -> new ContentLightLevelInformationSei_message(bitSource);
                    case 147 -> new AlternativeTransferCharacteristicsSei_message(bitSource);
                    default -> new Sei_message(bitSource);
                });
            }
            catch (RuntimeException iae) {
                logger.warning("Fall back for sei_message:" + nextPayloadType + " (" + Sei_message.getPayloadTypeString(nextPayloadType) + "), RuntimeException:" + String.valueOf(iae));
            }
        }
        return sei_messages;
    }
}

