/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Payload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPacket;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class BasebandFramePayload
extends Payload {
    private static LookUpList stream_type_list = new LookUpList.Builder().add(0, "Generic Packetized Stream (GFPS)").add(1, "Generic Continuous Stream (GCS)").add(2, "Generic Encapsulated Stream (GSE)").add(3, "Transport Stream (TS)").build();

    public BasebandFramePayload(byte[] data) {
        super(data);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode payloadNode = new DefaultMutableTreeNode(new KVP("payload"));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("frame_idx", this.getFrameIdx(), null)));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("plp_id", this.getPlpId(), null)));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("intl_frame_start", this.getIntlFrameStart(), null)));
        DefaultMutableTreeNode bbframeNode = new DefaultMutableTreeNode(new KVP("BBFRAME"));
        DefaultMutableTreeNode matypeNode = new DefaultMutableTreeNode(new KVP("MATYPE", this.getMATYPE(), null));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("StreamType TS/GS", this.getTSGS(), stream_type_list.get(this.getTSGS()))));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("SingleInputStream SIS/MIS", this.getSISMIS(), this.getSISMIS() == 1 ? "single" : "multiple")));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("ConstantCodingAndModulation CCM/ACM ", this.getCCMACM(), this.getCCMACM() == 1 ? "CCM" : "ACM")));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("InputStreamSyncIndicator ISSYI", this.getISSYI(), this.getISSYI() == 1 ? "active" : "not-active")));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("NullPacketDeletion NPD", this.getNPD(), this.getNPD() == 1 ? "active" : "not-active")));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("RO", this.getRO(), null)));
        matypeNode.add(new DefaultMutableTreeNode(new KVP("MAT2 (ISI/PLP_ID)", this.getMATYPE2(), null)));
        bbframeNode.add(matypeNode);
        bbframeNode.add(new DefaultMutableTreeNode(new KVP("UPL", this.getUPL(), "User Packet Length " + T2miPacket.getLenInBytes(this.getUPL()))));
        bbframeNode.add(new DefaultMutableTreeNode(new KVP("DFL", this.getDFL(), "Data Field Length " + T2miPacket.getLenInBytes(this.getDFL()))));
        bbframeNode.add(new DefaultMutableTreeNode(new KVP("SYNC", this.getSYNC(), "copy of the User Packet Sync-byte")));
        bbframeNode.add(new DefaultMutableTreeNode(new KVP("SYNCD", this.getSYNCD(), "distance in bits from the beginning of the DATA FIELD and the first UP from this frame" + T2miPacket.getLenInBytes(this.getSYNCD()))));
        bbframeNode.add(new DefaultMutableTreeNode(new KVP("CRC-8 MODE", this.getCRC8(), null)));
        payloadNode.add(bbframeNode);
        return payloadNode;
    }

    public int getIntlFrameStart() {
        return (Byte.toUnsignedInt(this.data[8]) & 0x80) >> 7;
    }

    public int getMATYPE() {
        return Utils.getInt(this.data, 9, 2, 65535);
    }

    public int getMATYPE1() {
        return Utils.getInt(this.data, 9, 1, 255);
    }

    public int getMATYPE2() {
        return Utils.getInt(this.data, 10, 1, 255);
    }

    public int getTSGS() {
        return (this.getMATYPE1() & 0xC0) >> 6;
    }

    public int getSISMIS() {
        return (this.getMATYPE1() & 0x20) >> 5;
    }

    public int getCCMACM() {
        return (this.getMATYPE1() & 0x10) >> 4;
    }

    public int getISSYI() {
        return (this.getMATYPE1() & 8) >> 3;
    }

    public int getNPD() {
        return (this.getMATYPE1() & 4) >> 2;
    }

    public int getRO() {
        return this.getMATYPE1() & 3;
    }

    public int getUPL() {
        return Utils.getInt(this.data, 11, 2, 65535);
    }

    public int getDFL() {
        return Utils.getInt(this.data, 13, 2, 65535);
    }

    public int getSYNC() {
        return Utils.getInt(this.data, 15, 1, 255);
    }

    public int getSYNCD() {
        return Utils.getInt(this.data, 16, 2, 65535);
    }

    public int getCRC8() {
        return Utils.getInt(this.data, 18, 1, 255);
    }

    public int getDFLinBytes() {
        return (this.getDFL() + 7) / 8;
    }
}

