/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.L1PreSignallingData;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.Utils;

public class Configurable1PostSignalling
implements TreeNode {
    private int sub_slices_per_frame;
    private int num_plp;
    private int num_aux;
    private int aux_config_rfu;
    private List<Frequency> frequencyList = new ArrayList<Frequency>();
    private L1PreSignallingData l1PreSignallingData;
    private int fef_type;
    private int fef_length;
    private int fef_interval;
    private List<PLP> plpList = new ArrayList<PLP>();
    private int fef_length_msb;
    private int reserved_2;
    private List<AUX> auxList = new ArrayList<AUX>();

    public Configurable1PostSignalling(BitSource bs, L1PreSignallingData l1PreSignallingData) {
        int i;
        this.l1PreSignallingData = l1PreSignallingData;
        this.sub_slices_per_frame = bs.readBits(15);
        this.num_plp = bs.readBits(8);
        this.num_aux = bs.readBits(4);
        this.aux_config_rfu = bs.readBits(8);
        int num_rf = l1PreSignallingData.getNum_rf();
        for (i = 0; i < num_rf; ++i) {
            this.frequencyList.add(new Frequency(this, bs));
        }
        if ((l1PreSignallingData.getS2() & 1) == 1) {
            this.fef_type = bs.readBits(4);
            this.fef_length = bs.readBits(22);
            this.fef_interval = bs.readBits(8);
        }
        for (i = 0; i < this.num_plp; ++i) {
            PLP plp = new PLP(this, bs);
            this.plpList.add(plp);
        }
        this.fef_length_msb = bs.readBits(2);
        this.reserved_2 = bs.readBits(30);
        for (i = 0; i < this.num_aux; ++i) {
            AUX aux = new AUX(this, bs);
            this.auxList.add(aux);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Configurable L1-post signalling"));
        t.add(new DefaultMutableTreeNode(new KVP("sub_slices_per_frame", this.sub_slices_per_frame, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_plp", this.num_plp, null)));
        t.add(new DefaultMutableTreeNode(new KVP("num_aux", this.num_aux, null)));
        t.add(new DefaultMutableTreeNode(new KVP("aux_config_rfu", this.aux_config_rfu, null)));
        Utils.addListJTree(t, this.frequencyList, modus, "Frequencies");
        if ((this.l1PreSignallingData.getS2() & 1) == 1) {
            t.add(new DefaultMutableTreeNode(new KVP("fef_type", this.fef_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("fef_length", this.fef_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("fef_interval", this.fef_interval, null)));
        }
        Utils.addListJTree(t, this.plpList, modus, "PLPs");
        t.add(new DefaultMutableTreeNode(new KVP("fef_length_msb", this.fef_length_msb, null)));
        t.add(new DefaultMutableTreeNode(new KVP("reserved_2", this.reserved_2, null)));
        Utils.addListJTree(t, this.auxList, modus, "AUXs");
        return t;
    }

    public int getSub_slices_per_frame() {
        return this.sub_slices_per_frame;
    }

    public int getNum_plp() {
        return this.num_plp;
    }

    public int getNum_aux() {
        return this.num_aux;
    }

    public int getAux_config_rfu() {
        return this.aux_config_rfu;
    }

    public List<Frequency> getFrequencyList() {
        return this.frequencyList;
    }

    public L1PreSignallingData getL1PreSignallingData() {
        return this.l1PreSignallingData;
    }

    public int getFef_type() {
        return this.fef_type;
    }

    public int getFef_length() {
        return this.fef_length;
    }

    public int getFef_interval() {
        return this.fef_interval;
    }

    public List<PLP> getPlpList() {
        return this.plpList;
    }

    public int getFef_length_msb() {
        return this.fef_length_msb;
    }

    public int getReserved_2() {
        return this.reserved_2;
    }

    public List<AUX> getAuxList() {
        return this.auxList;
    }

    public class Frequency
    implements TreeNode {
        private int rf_idx;
        private int frequency;

        public Frequency(Configurable1PostSignalling this$0, BitSource bs) {
            this.rf_idx = bs.readBits(3);
            this.frequency = bs.readBits(32);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("rf_idx:" + this.rf_idx + ", frequency:" + this.frequency));
            t.add(new DefaultMutableTreeNode(new KVP("rf_idx", this.rf_idx, null)));
            t.add(new DefaultMutableTreeNode(new KVP("frequency", this.frequency, null)));
            return t;
        }

        public int getRf_idx() {
            return this.rf_idx;
        }

        public int getFrequency() {
            return this.frequency;
        }
    }

    public class PLP
    implements TreeNode {
        private int plp_id;
        private int plp_type;
        private int plp_payload_type;
        private int ff_flag;
        private int first_rf_idx;
        private int first_frame_idx;
        private int plp_group_id;
        private int plp_cod;
        private int plp_mod;
        private int plp_rotation;
        private int plp_fec_type;
        private int plp_num_blocks_max;
        private int frame_interval;
        private int time_il_length;
        private int time_il_type;
        private int in_band_a_flag;
        private int in_band_b_flag;
        private int reserved_1;
        private int plp_mode;
        private int static_flag;
        private int static_padding_flag;

        public PLP(Configurable1PostSignalling this$0, BitSource bs) {
            this.plp_id = bs.readBits(8);
            this.plp_type = bs.readBits(3);
            this.plp_payload_type = bs.readBits(5);
            this.ff_flag = bs.readBits(1);
            this.first_rf_idx = bs.readBits(3);
            this.first_frame_idx = bs.readBits(8);
            this.plp_group_id = bs.readBits(8);
            this.plp_cod = bs.readBits(3);
            this.plp_mod = bs.readBits(3);
            this.plp_rotation = bs.readBits(1);
            this.plp_fec_type = bs.readBits(2);
            this.plp_num_blocks_max = bs.readBits(10);
            this.frame_interval = bs.readBits(8);
            this.time_il_length = bs.readBits(8);
            this.time_il_type = bs.readBits(1);
            this.in_band_a_flag = bs.readBits(1);
            this.in_band_b_flag = bs.readBits(1);
            this.reserved_1 = bs.readBits(11);
            this.plp_mode = bs.readBits(2);
            this.static_flag = bs.readBits(1);
            this.static_padding_flag = bs.readBits(1);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("PLP"));
            t.add(new DefaultMutableTreeNode(new KVP("plp_id", this.plp_id, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_type", this.plp_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_payload_type", this.plp_payload_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("ff_flag", this.ff_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("first_rf_idx", this.first_rf_idx, null)));
            t.add(new DefaultMutableTreeNode(new KVP("first_frame_idx", this.first_frame_idx, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_group_id", this.plp_group_id, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_cod", this.plp_cod, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_mod", this.plp_mod, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_rotation", this.plp_rotation, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_fec_type", this.plp_fec_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_num_blocks_max", this.plp_num_blocks_max, null)));
            t.add(new DefaultMutableTreeNode(new KVP("frame_interval", this.frame_interval, null)));
            t.add(new DefaultMutableTreeNode(new KVP("time_il_length", this.time_il_length, null)));
            t.add(new DefaultMutableTreeNode(new KVP("time_il_type", this.time_il_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("in_band_a_flag", this.in_band_a_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("in_band_b_flag", this.in_band_b_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("reserved_1", this.reserved_1, null)));
            t.add(new DefaultMutableTreeNode(new KVP("plp_mode", this.plp_mode, null)));
            t.add(new DefaultMutableTreeNode(new KVP("static_flag", this.static_flag, null)));
            t.add(new DefaultMutableTreeNode(new KVP("static_padding_flag", this.static_padding_flag, null)));
            return t;
        }

        public int getPlp_id() {
            return this.plp_id;
        }

        public int getPlp_type() {
            return this.plp_type;
        }

        public int getPlp_payload_type() {
            return this.plp_payload_type;
        }

        public int getFf_flag() {
            return this.ff_flag;
        }

        public int getFirst_rf_idx() {
            return this.first_rf_idx;
        }

        public int getFirst_frame_idx() {
            return this.first_frame_idx;
        }

        public int getPlp_group_id() {
            return this.plp_group_id;
        }

        public int getPlp_cod() {
            return this.plp_cod;
        }

        public int getPlp_mod() {
            return this.plp_mod;
        }

        public int getPlp_rotation() {
            return this.plp_rotation;
        }

        public int getPlp_fec_type() {
            return this.plp_fec_type;
        }

        public int getPlp_num_blocks_max() {
            return this.plp_num_blocks_max;
        }

        public int getFrame_interval() {
            return this.frame_interval;
        }

        public int getTime_il_length() {
            return this.time_il_length;
        }

        public int getTime_il_type() {
            return this.time_il_type;
        }

        public int getIn_band_a_flag() {
            return this.in_band_a_flag;
        }

        public int getIn_band_b_flag() {
            return this.in_band_b_flag;
        }

        public int getReserved_1() {
            return this.reserved_1;
        }

        public int getPlp_mode() {
            return this.plp_mode;
        }

        public int getStatic_flag() {
            return this.static_flag;
        }

        public int getStatic_padding_flag() {
            return this.static_padding_flag;
        }
    }

    public class AUX
    implements TreeNode {
        private int aux_stream_type;
        private int aux_private_conf;

        public AUX(Configurable1PostSignalling this$0, BitSource bs) {
            this.aux_stream_type = bs.readBits(4);
            this.aux_private_conf = bs.readBits(28);
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AUX"));
            t.add(new DefaultMutableTreeNode(new KVP("aux_stream_type", this.aux_stream_type, null)));
            t.add(new DefaultMutableTreeNode(new KVP("aux_private_conf", this.aux_private_conf, null)));
            return t;
        }

        public int getAux_stream_type() {
            return this.aux_stream_type;
        }

        public int getAux_private_conf() {
            return this.aux_private_conf;
        }
    }
}

