/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.Payload;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class IndividualAddressingPayload
extends Payload {
    private static final LookUpList function_type_list = new LookUpList.Builder().add(0, "Transmitter time offset").add(1, "Transmitter frequency offset").add(2, "Transmitter power").add(3, "Private data").add(4, "Cell id").add(5, "Enable").add(6, "Bandwidth").add(16, "ACE-PAPR").add(17, "Transmitter MISO group").add(18, "TR-PAPR").add(19, "L1-ACE-PAPR").add(20, "TX-SIG FEF: Sequence Numbers").add(21, "TX-SIG Aux stream: Transmitter ID").add(22, "Frequency").build();
    private int individual_addressing_length = this.getIndividualAddressingLength();
    List<IndividualAddressingData> individualAddressingDataList;

    public IndividualAddressingPayload(byte[] data) {
        super(data);
        BitSource bs1 = new BitSource(data, 8, data.length - 4);
        this.individualAddressingDataList = new ArrayList<IndividualAddressingData>();
        while (bs1.available() > 0) {
            IndividualAddressingData individualAddressingData = new IndividualAddressingData(this, bs1);
            this.individualAddressingDataList.add(individualAddressingData);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode payloadNode = new DefaultMutableTreeNode(new KVP("payload"));
        payloadNode.add(new DefaultMutableTreeNode(new KVP("individual_addressing_length", this.individual_addressing_length, null)));
        Utils.addListJTree(payloadNode, this.individualAddressingDataList, modus, "Individual addressing");
        return payloadNode;
    }

    public int getIndividualAddressingLength() {
        return Utils.getInt(this.data, 7, 1, 255);
    }

    public class IndividualAddressingData
    implements TreeNode {
        private int tx_identifier;
        private int function_loop_length;
        private List<Function> functionList = new ArrayList<Function>();

        public IndividualAddressingData(IndividualAddressingPayload this$0, BitSource bs) {
            Function f;
            this.tx_identifier = bs.readBits(16);
            this.function_loop_length = bs.readBits(8);
            for (int bytesRead = 0; bytesRead < this.function_loop_length; bytesRead += f.getFunction_length()) {
                f = new Function(this, bs);
                this.functionList.add(f);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("IndividualAddressingData"));
            t.add(new DefaultMutableTreeNode(new KVP("tx_identifier", this.tx_identifier, null)));
            t.add(new DefaultMutableTreeNode(new KVP("function_loop_length", this.function_loop_length, null)));
            Utils.addListJTree(t, this.functionList, modus, "Functions");
            return t;
        }

        public class Function
        implements TreeNode {
            private int function_tag;
            private int function_length;
            private byte[] body;

            public Function(IndividualAddressingData this$1, BitSource bs) {
                this.function_tag = bs.readBits(8);
                this.function_length = bs.readBits(8);
                this.body = bs.readBytes(this.function_length - 2);
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Function"));
                t.add(new DefaultMutableTreeNode(new KVP("function_tag", this.function_tag, function_type_list.get(this.function_tag))));
                t.add(new DefaultMutableTreeNode(new KVP("function_length", this.function_length, " defines the total length of the function() in bytes, including the function_tag, function_length and function_body() fields")));
                if (this.body != null) {
                    t.add(new DefaultMutableTreeNode(new KVP("body", this.body, null)));
                }
                return t;
            }

            public void setFunction_tag(int function_tag) {
                this.function_tag = function_tag;
            }

            public void setFunction_length(int function_length) {
                this.function_length = function_length;
            }

            public void setBody(byte[] body) {
                this.body = body;
            }

            public int getFunction_tag() {
                return this.function_tag;
            }

            public int getFunction_length() {
                return this.function_length;
            }

            public byte[] getBody() {
                return this.body;
            }
        }
    }
}

