/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.util.BitSource;
import nl.digitalekabeltelevisie.util.LookUpList;

public class L1PreSignallingData
implements TreeNode {
    private static LookUpList type_list = new LookUpList.Builder().add(0, "Transport Stream (TS) only").add(1, "Generic Stream (GSE and/or GFPS and/or GCS) but not TS").add(2, "Both TS and Generic Stream").add(3, 255, "Reserved for future use ").build();
    private static LookUpList guard_interval_list = new LookUpList.Builder().add(0, "1/32").add(1, "1/16").add(2, "1/8").add(3, "1/4").add(4, "1/128").add(5, "19/128").add(6, "19/256").add(7, "Reserved for future use").build();
    private int type;
    private int bwt_ext;
    private int s1;
    private int s2;
    private int l1_repetition_flag;
    private int guard_interval;
    private int papr;
    private int l1_mod;
    private int l1_cod;
    private int l1_fec_type;
    private int l1_post_size;
    private int l1_post_info_size;
    private int pilot_pattern;
    private int tx_id_availability;
    private int cell_id;
    private int network_id;
    private int t2_system_id;
    private int num_t2_frames;
    private int num_data_symbols;
    private int regen_flag;
    private int l1_post_extension;
    private int num_rf;
    private int current_rf_idx;
    private int t2_version;
    private int l1_post_scrambled;
    private int t2_base_lite;
    private int reserved;

    public L1PreSignallingData(BitSource bs) {
        this.type = bs.readBits(8);
        this.bwt_ext = bs.readBits(1);
        this.s1 = bs.readBits(3);
        this.s2 = bs.readBits(4);
        this.l1_repetition_flag = bs.readBits(1);
        this.guard_interval = bs.readBits(3);
        this.papr = bs.readBits(4);
        this.l1_mod = bs.readBits(4);
        this.l1_cod = bs.readBits(2);
        this.l1_fec_type = bs.readBits(2);
        this.l1_post_size = bs.readBits(18);
        this.l1_post_info_size = bs.readBits(18);
        this.pilot_pattern = bs.readBits(4);
        this.tx_id_availability = bs.readBits(8);
        this.cell_id = bs.readBits(16);
        this.network_id = bs.readBits(16);
        this.t2_system_id = bs.readBits(16);
        this.num_t2_frames = bs.readBits(8);
        this.num_data_symbols = bs.readBits(12);
        this.regen_flag = bs.readBits(3);
        this.l1_post_extension = bs.readBits(1);
        this.num_rf = bs.readBits(3);
        this.current_rf_idx = bs.readBits(3);
        this.t2_version = bs.readBits(4);
        this.l1_post_scrambled = bs.readBits(1);
        this.t2_base_lite = bs.readBits(1);
        this.reserved = bs.readBits(4);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode l1cpre = new DefaultMutableTreeNode(new KVP("L1-Pre Signalling data "));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("type", this.type, type_list.get(this.type))));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("bwt_ext", this.bwt_ext, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("s1", this.s1, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("s2", this.s2, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_repetition_flag", this.l1_repetition_flag, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("guard_interval", this.guard_interval, guard_interval_list.get(this.guard_interval))));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("papr", this.papr, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_mod", this.l1_mod, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_cod", this.l1_cod, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_fec_type", this.l1_fec_type, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_post_size", this.l1_post_size, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_post_info_size", this.l1_post_info_size, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("pilot_pattern", this.pilot_pattern, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("tx_id_availability", this.tx_id_availability, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cell_id, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("network_id", this.network_id, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("t2_system_id", this.t2_system_id, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("num_t2_frames", this.num_t2_frames, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("num_data_symbols", this.num_data_symbols, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("regen_flag", this.regen_flag, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_post_extension", this.l1_post_extension, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("num_rf", this.num_rf, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("current_rf_idx", this.current_rf_idx, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("t2_version", this.t2_version, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("l1_post_scrambled", this.l1_post_scrambled, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("t2_base_lite", this.t2_base_lite, null)));
        l1cpre.add(new DefaultMutableTreeNode(new KVP("reserved", this.reserved, null)));
        return l1cpre;
    }

    public int getType() {
        return this.type;
    }

    public int getBwt_ext() {
        return this.bwt_ext;
    }

    public int getS1() {
        return this.s1;
    }

    public int getS2() {
        return this.s2;
    }

    public int getL1_repetition_flag() {
        return this.l1_repetition_flag;
    }

    public int getGuard_interval() {
        return this.guard_interval;
    }

    public int getPapr() {
        return this.papr;
    }

    public int getL1_mod() {
        return this.l1_mod;
    }

    public int getL1_cod() {
        return this.l1_cod;
    }

    public int getL1_fec_type() {
        return this.l1_fec_type;
    }

    public int getL1_post_size() {
        return this.l1_post_size;
    }

    public int getL1_post_info_size() {
        return this.l1_post_info_size;
    }

    public int getPilot_pattern() {
        return this.pilot_pattern;
    }

    public int getTx_id_availability() {
        return this.tx_id_availability;
    }

    public int getCell_id() {
        return this.cell_id;
    }

    public int getNetwork_id() {
        return this.network_id;
    }

    public int getT2_system_id() {
        return this.t2_system_id;
    }

    public int getNum_t2_frames() {
        return this.num_t2_frames;
    }

    public int getNum_data_symbols() {
        return this.num_data_symbols;
    }

    public int getRegen_flag() {
        return this.regen_flag;
    }

    public int getL1_post_extension() {
        return this.l1_post_extension;
    }

    public int getNum_rf() {
        return this.num_rf;
    }

    public int getCurrent_rf_idx() {
        return this.current_rf_idx;
    }

    public int getT2_version() {
        return this.t2_version;
    }

    public int getL1_post_scrambled() {
        return this.l1_post_scrambled;
    }

    public int getT2_base_lite() {
        return this.t2_base_lite;
    }

    public int getReserved() {
        return this.reserved;
    }
}

