/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.BasebandFramePayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPacket;
import nl.digitalekabeltelevisie.gui.SaveAble;

public class PlpHandler
implements SaveAble {
    private static final Logger logger = Logger.getLogger(PlpHandler.class.getName());
    private static final int T2_BBHEADER_SIZE = 10;
    private static final int PKT_SIZE = 188;
    private byte[] buffer = new byte[0];
    private int bufferStart = 0;
    private int bufferEnd = 0;
    private int packetsProduced = 0;
    private int pid;
    private int plpId;
    private List<T2miPacket> plpPackets;
    private Iterator<T2miPacket> plpIter;
    private boolean first_packet = true;

    public PlpHandler(int pid, int plpId, List<T2miPacket> plpPackets) {
        this.pid = pid;
        this.plpId = plpId;
        this.plpPackets = plpPackets;
        this.plpIter = plpPackets.iterator();
    }

    public void reset() {
        this.buffer = new byte[0];
        this.bufferStart = 0;
        this.bufferEnd = 0;
        this.packetsProduced = 0;
        this.plpIter = this.plpPackets.iterator();
    }

    public TSPacket getTsPacket() {
        if (this.bufferEnd - this.bufferStart >= 188) {
            TSPacket packet = new TSPacket(Arrays.copyOfRange(this.buffer, this.bufferStart, this.bufferStart + 188), this.packetsProduced++, null);
            this.bufferStart += 188;
            return packet;
        }
        this.processT2miPackets(188);
        if (this.bufferEnd - this.bufferStart >= 188) {
            TSPacket packet = new TSPacket(Arrays.copyOfRange(this.buffer, this.bufferStart, this.bufferStart + 188), this.packetsProduced++, null);
            this.bufferStart += 188;
            return packet;
        }
        return null;
    }

    private void processT2miPackets(int requestedBytes) {
        while (this.plpIter.hasNext() && this.bufferEnd - this.bufferStart < requestedBytes) {
            T2miPacket newT2miPacket = this.plpIter.next();
            BasebandFramePayload payLoad = (BasebandFramePayload)newT2miPacket.getPayload();
            if (payLoad.getTSGS() != 3) {
                return;
            }
            int size = payLoad.data.length - 9;
            int npd = payLoad.getNPD();
            int dfl = payLoad.getDFLinBytes();
            int syncd = payLoad.getSYNCD();
            int dataStart = 19;
            if (dfl > (size -= 10)) {
                dfl = size;
            }
            if (syncd == 65535) {
                this.append(payLoad.data, dataStart, size);
                continue;
            }
            syncd = Math.min(syncd / 8, dfl);
            if (!this.first_packet && syncd > 0) {
                if ((this.bufferEnd - this.bufferStart) % 188 == 0) {
                    this.append(new byte[]{71}, 0, 1);
                }
                this.append(payLoad.data, dataStart, syncd - npd);
            }
            this.first_packet = false;
            dataStart += syncd;
            dfl -= syncd;
            while (dfl >= 187) {
                this.append(new byte[]{71}, 0, 1);
                this.append(payLoad.data, dataStart, 187);
                dataStart += 187;
                dfl -= 187;
            }
            if (dfl <= 0) continue;
            this.append(new byte[]{71}, 0, 1);
            this.append(payLoad.data, dataStart, dfl);
        }
    }

    private void append(byte[] data, int dataStart, int size) {
        int currentLen = this.bufferEnd - this.bufferStart;
        int newLen = currentLen + size;
        byte[] newBuffer = new byte[newLen];
        System.arraycopy(this.buffer, this.bufferStart, newBuffer, 0, currentLen);
        System.arraycopy(data, dataStart, newBuffer, currentLen, size);
        this.buffer = newBuffer;
        this.bufferStart = 0;
        this.bufferEnd = newLen;
    }

    public boolean hasMoreTsPackets() {
        if (this.bufferEnd - this.bufferStart >= 188) {
            return true;
        }
        this.processT2miPackets(188);
        return this.bufferEnd - this.bufferStart >= 188;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public int getPlpId() {
        return this.plpId;
    }

    public void setPlpId(int plpId) {
        this.plpId = plpId;
    }

    public List<T2miPacket> getPlpPackets() {
        return this.plpPackets;
    }

    public void setPlpPackets(List<T2miPacket> plpPackets) {
        this.plpPackets = plpPackets;
    }

    @Override
    public void save(File file) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.reset();
            while (this.hasMoreTsPackets()) {
                TSPacket packet = this.getTsPacket();
                out.write(packet.getBuffer());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "could not write file", e);
        }
    }
}

