/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.pid.t2mi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.BasebandFramePayload;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.PlpHandler;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPacket;
import nl.digitalekabeltelevisie.util.Utils;

public class T2miPidHandler
extends GeneralPidHandler {
    private static final Logger LOGGER = Logger.getLogger(T2miPidHandler.class.getName());
    private List<T2miPacket> t2miPackets = new ArrayList<T2miPacket>();
    private byte[] currentPacketData;
    private byte[] header = new byte[6];
    private int dataBytesRead = 0;
    private int headerBytesRead = 0;
    private boolean packetStarted = false;
    private Map<Integer, List<T2miPacket>> plps = new HashMap<Integer, List<T2miPacket>>();

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("T2MI"));
        Utils.addListJTree(t, this.t2miPackets, modus, "T2MI Packets");
        DefaultMutableTreeNode plpsTree = new DefaultMutableTreeNode(new KVP("PLPs"));
        for (Integer plpId : new TreeSet<Integer>(this.plps.keySet())) {
            List<T2miPacket> itemList = this.plps.get(plpId);
            if (itemList == null || itemList.size() == 0) continue;
            KVP kvp = new KVP("plp:" + plpId + ": " + itemList.size() + " entries");
            DefaultMutableTreeNode plpListNode = new DefaultMutableTreeNode(kvp);
            JMenuItem objectMenu = new JMenuItem("Save embedded TS as...");
            objectMenu.setActionCommand("t2mi");
            kvp.setSubMenuAndOwner(objectMenu, new PlpHandler(this.pid.getPid(), plpId, itemList));
            Utils.addToList(plpListNode, itemList, modus);
            plpsTree.add(plpListNode);
        }
        t.add(plpsTree);
        return t;
    }

    @Override
    public void processTSPacket(TSPacket packet) {
        this.initialized = true;
        byte[] data = packet.getData();
        int packetNo = packet.getPacketNo();
        if (packet.isPayloadUnitStartIndicator()) {
            if (!this.packetStarted) {
                this.packetStarted = true;
                this.readBytes(data, Byte.toUnsignedInt(data[0]) + 1, packetNo);
            } else {
                this.readBytes(data, 1, packetNo);
            }
        } else if (this.packetStarted) {
            this.readBytes(data, 0, packetNo);
        }
    }

    private void readBytes(byte[] data, int offsetIn, int packetNo) {
        int offset = offsetIn;
        int bytesLeft = data.length - offset;
        while (bytesLeft > 0) {
            if (this.headerBytesRead < 6) {
                int toRead = Math.min(6 - this.headerBytesRead, bytesLeft);
                System.arraycopy(data, offset, this.header, this.headerBytesRead, toRead);
                offset += toRead;
                this.headerBytesRead += toRead;
                bytesLeft -= toRead;
            }
            if (bytesLeft == 0) {
                return;
            }
            int payloadLenInBits = 256 * Byte.toUnsignedInt(this.header[4]) + Byte.toUnsignedInt(this.header[5]);
            int payloadLenInBytes = (payloadLenInBits + 7) / 8 + 4;
            if (this.currentPacketData == null) {
                this.currentPacketData = new byte[payloadLenInBytes];
            }
            if (this.dataBytesRead < payloadLenInBytes) {
                int toRead = Math.min(payloadLenInBytes - this.dataBytesRead, bytesLeft);
                System.arraycopy(data, offset, this.currentPacketData, this.dataBytesRead, toRead);
                offset += toRead;
                this.dataBytesRead += toRead;
                bytesLeft -= toRead;
            }
            if (this.dataBytesRead != payloadLenInBytes) continue;
            byte[] result = new byte[6 + payloadLenInBytes];
            System.arraycopy(this.header, 0, result, 0, 6);
            System.arraycopy(this.currentPacketData, 0, result, 6, payloadLenInBytes);
            T2miPacket packet = new T2miPacket(result, packetNo);
            this.headerBytesRead = 0;
            this.dataBytesRead = 0;
            this.currentPacketData = null;
            if (packet.getCRCresult() != 0L) {
                LOGGER.warning("CRC check failed, T2MI packet started at TS Packet:" + packetNo);
                this.packetStarted = false;
                return;
            }
            this.handleT2miPacket(packet);
            if (bytesLeft != 0) continue;
            this.packetStarted = false;
            return;
        }
    }

    private void handleT2miPacket(T2miPacket packet) {
        this.t2miPackets.add(packet);
        if (packet.getPacketType() == 0) {
            int plpId = ((BasebandFramePayload)packet.getPayload()).getPlpId();
            List plpList = this.plps.computeIfAbsent(plpId, k -> new ArrayList());
            plpList.add(packet);
        }
    }
}

