/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AITsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.util.Utils;

public class AIT
extends AbstractPSITabel {
    private final Map<Integer, AITsection[]> aits = new HashMap<Integer, AITsection[]>();
    private int pid = 0;

    public AIT(PSI parent) {
        super(parent);
    }

    public void update(AITsection section) {
        this.pid = section.getParentPID().getPid();
        int key = section.getApplication_type();
        AITsection[] sections = this.aits.computeIfAbsent(key, k -> new AITsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            AITsection last = sections[section.getSectionNumber()];
            AIT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("AIT (Application Information Table) PID=" + this.pid));
        for (Integer type : new TreeSet<Integer>(this.aits.keySet())) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("AIT", type, Utils.getAppTypeIDString(type)));
            for (AITsection tsection : this.aits.get(type)) {
                if (tsection == null) continue;
                AIT.addSectionVersionsToJTree(n, tsection, modus);
            }
            t.add(n);
        }
        return t;
    }
}

