/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.BouquetNameDescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.BATsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.TransportStream;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class BAT
extends AbstractPSITabel {
    private final Map<Integer, BATsection[]> networks = new HashMap<Integer, BATsection[]>();

    public BAT(PSI parent) {
        super(parent);
    }

    public void update(BATsection section) {
        int key = section.getBouqetID();
        BATsection[] sections = this.networks.computeIfAbsent(key, k -> new BATsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            BATsection last = sections[section.getSectionNumber()];
            BAT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvpBat = new KVP("BAT");
        if (!this.networks.isEmpty()) {
            kvpBat.addTableSource(this::getTableModel, "BAT");
        }
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvpBat);
        for (int bouquetNo : new TreeSet<Integer>(this.networks.keySet())) {
            BATsection[] sections;
            KVP kvp = new KVP("bouquet_id", bouquetNo, Utils.getBouquetIDString(bouquetNo));
            if (this.hasTransportStreams(bouquetNo)) {
                kvp.addTableSource(() -> this.getTableForBouqetID(bouquetNo), "bouquet_id " + bouquetNo);
            }
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(kvp);
            for (BATsection tsection : sections = this.networks.get(bouquetNo)) {
                if (tsection == null) continue;
                if (!Utils.simpleModus(modus)) {
                    n.add(tsection.getJTreeNode(modus));
                    continue;
                }
                BATsection batSection = tsection;
                Utils.addListJTree(n, batSection.getNetworkDescriptorList(), modus, "network_descriptors");
                Utils.addListJTree(n, batSection.getTransportStreamList(), modus, "transport_stream_loop");
            }
            t.add(n);
        }
        return t;
    }

    static TableHeader<BATsection, TransportStream> buildBatTableHeader() {
        return new TableHeaderBuilder().addRequiredBaseColumn("bouquet id", b -> b.getBouqetID(), Integer.class).addRequiredBaseColumn("bouquet id name", b -> Utils.getBouquetIDString(b.getBouqetID()), String.class).addOptionalBaseColumn("bouquet name descriptor", bat -> Descriptor.findDescriptorApplyFunc(bat.getNetworkDescriptorList(), BouquetNameDescriptor.class, bnd -> bnd.getBouquetName().toString()), String.class).addOptionalRowColumn("tsid", ts -> ts.transport_stream_id(), Integer.class).addOptionalRowColumn("onid", ts -> ts.original_network_id(), Integer.class).addOptionalRowColumn("original network name", ts -> Utils.getOriginalNetworkIDString(ts.original_network_id()), String.class).build();
    }

    private boolean hasTransportStreams(int bouqetNo) {
        BATsection[] sections;
        for (BATsection tsection : sections = this.networks.get(bouqetNo)) {
            if (tsection == null || tsection.getTransportStreamList().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private TableModel getTableForBouqetID(int bouqetNo) {
        BATsection[] sections;
        FlexTableModel<BATsection, TransportStream> tableModel = new FlexTableModel<BATsection, TransportStream>(BAT.buildBatTableHeader());
        for (BATsection tsection : sections = this.networks.get(bouqetNo)) {
            if (tsection == null) continue;
            tableModel.addData(tsection, tsection.getTransportStreamList());
        }
        tableModel.process();
        return tableModel;
    }

    public TableModel getTableModel() {
        FlexTableModel<BATsection, TransportStream> tableModel = new FlexTableModel<BATsection, TransportStream>(BAT.buildBatTableHeader());
        for (BATsection[] batSections : this.networks.values()) {
            for (BATsection tsection : batSections) {
                if (tsection == null) continue;
                tableModel.addData(tsection, tsection.getTransportStreamList());
            }
        }
        tableModel.process();
        return tableModel;
    }
}

