/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.CADescriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.CAsection;
import nl.digitalekabeltelevisie.util.Utils;
import nl.digitalekabeltelevisie.util.tablemodel.FlexTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeaderBuilder;

public class CAT
extends AbstractPSITabel {
    private CAsection[] cat = null;

    public List<Descriptor> getDescriptorList() {
        ArrayList<Descriptor> l = new ArrayList<Descriptor>();
        if (this.cat != null) {
            for (CAsection element : this.cat) {
                if (element == null) continue;
                l.addAll(element.getDescriptorList());
            }
        }
        return l;
    }

    public CAT(PSI parent) {
        super(parent);
    }

    public void update(CAsection section) {
        if (this.cat == null) {
            this.cat = new CAsection[section.getSectionLastNumber() + 1];
        }
        if (this.cat[section.getSectionNumber()] == null) {
            this.cat[section.getSectionNumber()] = section;
        } else {
            CAsection last = this.cat[section.getSectionNumber()];
            CAT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        KVP kvp = new KVP("CAT");
        if (this.hasCADescriptors()) {
            kvp.addTableSource(this::getTableModel, "cat");
        }
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(kvp);
        if (this.cat != null) {
            for (CAsection element : this.cat) {
                if (element == null) continue;
                CAT.addSectionVersionsToJTree(t, element, modus);
            }
        }
        return t;
    }

    static TableHeader<CAsection, CADescriptor> buildCatTableHeader() {
        return new TableHeaderBuilder().addOptionalRowColumn("ca system id", CADescriptor::getCaSystemID, Integer.class).addOptionalRowColumn("ca pid", CADescriptor::getCaPID, Integer.class).addOptionalRowColumn("ca system specifier", p -> Utils.getCASystemIDString(p.getCaSystemID()), String.class).build();
    }

    public TableModel getTableModel() {
        FlexTableModel<CAsection, CADescriptor> tableModel = new FlexTableModel<CAsection, CADescriptor>(CAT.buildCatTableHeader());
        if (this.cat != null) {
            for (CAsection element : this.cat) {
                if (element == null) continue;
                tableModel.addData(element, Descriptor.findGenericDescriptorsInList(element.getDescriptorList(), CADescriptor.class));
            }
        }
        tableModel.process();
        return tableModel;
    }

    private boolean hasCADescriptors() {
        if (this.cat != null) {
            for (CAsection caSection : this.cat) {
                if (caSection == null || caSection.getDescriptorList().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

