/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class DFITSection
extends TableSectionExtendedSyntax {
    private final int font_id_extension;
    private final int font_id;
    private final List<FontInfo> fontInfoList = new ArrayList<FontInfo>();

    public DFITSection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        byte[] sectionData = raw_data.getData();
        this.font_id_extension = Utils.getInt(sectionData, 3, 2, 65408) >> 7;
        this.font_id = Utils.getInt(sectionData, 4, 1, 127);
        int offset = 8;
        while (offset < this.sectionLength - 5 - 4) {
            int font_info_type = Utils.getInt(sectionData, offset++, 1, 255);
            FontInfo fi = new FontInfo(font_info_type);
            this.fontInfoList.add(fi);
            if (font_info_type == 0) {
                int font_style = Utils.getInt(sectionData, offset, 1, 224) >> 5;
                int font_weight = Utils.getInt(sectionData, offset, 1, 30) >> 1;
                int reserved_zero_future_use = Utils.getInt(sectionData, offset++, 1, 1);
                fi.setFont_style(font_style);
                fi.setFont_weight(font_weight);
                fi.setReserved_zero_future_use(reserved_zero_future_use);
                continue;
            }
            if (font_info_type == 1) {
                int reserved_zero_future_use = Utils.getInt(sectionData, offset, 1, 240) >> 4;
                int font_file_format = Utils.getInt(sectionData, offset++, 1, 15);
                int uri_length = Utils.getInt(sectionData, offset++, 1, 255);
                byte[] uri_char = Utils.getBytes(sectionData, offset, uri_length);
                offset += uri_length;
                fi.setReserved_zero_future_use(reserved_zero_future_use);
                fi.setFont_file_format(font_file_format);
                fi.setUri_length(uri_length);
                fi.setUri_char(uri_char);
                continue;
            }
            if (font_info_type == 2) {
                int font_size = Utils.getInt(sectionData, offset, 2, 65535);
                offset += 2;
                fi.setFont_size(font_size);
                continue;
            }
            int font_info_length = Utils.getInt(sectionData, offset++, 1, 255);
            byte[] text_char = Utils.getBytes(sectionData, offset, font_info_length);
            offset += font_info_length;
            fi.setFont_info_length(font_info_length);
            fi.setText_char(text_char);
        }
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "font_id_extension (9) / font_id (7)";
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("font_id_extension", this.font_id_extension, null)));
        t.add(new DefaultMutableTreeNode(new KVP("font_id", this.font_id, null)));
        Utils.addListJTree(t, this.fontInfoList, modus, "Font Info List");
        return t;
    }

    public int getFont_id_extension() {
        return this.font_id_extension;
    }

    public int getFont_id() {
        return this.font_id;
    }

    public static class FontInfo
    implements TreeNode {
        final LookUpList fontInfoTypeList = new LookUpList.Builder().add(0, "font_style_weight").add(1, "font file URI").add(2, "font_size").add(3, "font_family").add(4, 255, "reserved").build();
        final LookUpList fontStyleList = new LookUpList.Builder().add(0, "undefined").add(1, "normal").add(2, "italic").add(3, "oblique").add(4, 7, "reserved for future use").build();
        final LookUpList fontWeightList = new LookUpList.Builder().add(0, "undefined").add(1, "normal").add(2, "bold").add(3, 15, "reserved for future use").build();
        final LookUpList fontFileFormatList = new LookUpList.Builder().add(0, "Open Font Format").add(1, "Web Open Font Format").add(2, 15, "reserved for future use").build();
        private int font_info_type;
        private int font_style;
        private int font_weight;
        private int reserved_zero_future_use;
        private int font_file_format;
        private int uri_length;
        private byte[] uri_char;
        private int font_size;
        int font_info_length;
        byte[] text_char;

        public FontInfo(int font_info_type) {
            this.font_info_type = font_info_type;
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Font Info"));
            t.add(new DefaultMutableTreeNode(new KVP("font_info_type", this.font_info_type, this.fontInfoTypeList.get(this.font_info_type))));
            if (this.font_info_type == 0) {
                t.add(new DefaultMutableTreeNode(new KVP("font_style", this.font_style, this.fontStyleList.get(this.font_style))));
                t.add(new DefaultMutableTreeNode(new KVP("font_weight", this.font_weight, this.fontWeightList.get(this.font_weight))));
                t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use, null)));
            } else if (this.font_info_type == 1) {
                t.add(new DefaultMutableTreeNode(new KVP("reserved_zero_future_use", this.reserved_zero_future_use, null)));
                t.add(new DefaultMutableTreeNode(new KVP("font_file_format", this.font_file_format, this.fontFileFormatList.get(this.font_file_format))));
                t.add(new DefaultMutableTreeNode(new KVP("uri_length", this.uri_length, null)));
                t.add(new DefaultMutableTreeNode(new KVP("uri_char", this.uri_char, null)));
            } else if (this.font_info_type == 2) {
                t.add(new DefaultMutableTreeNode(new KVP("font_size", this.font_size, null)));
            } else {
                t.add(new DefaultMutableTreeNode(new KVP("font_info_length", this.font_info_length, null)));
                t.add(new DefaultMutableTreeNode(new KVP("text_char", this.text_char, null)));
            }
            return t;
        }

        public int getFont_info_type() {
            return this.font_info_type;
        }

        public void setFont_info_type(int font_info_type) {
            this.font_info_type = font_info_type;
        }

        public int getFont_style() {
            return this.font_style;
        }

        public void setFont_style(int font_style) {
            this.font_style = font_style;
        }

        public int getFont_weight() {
            return this.font_weight;
        }

        public void setFont_weight(int font_weight) {
            this.font_weight = font_weight;
        }

        public int getReserved_zero_future_use() {
            return this.reserved_zero_future_use;
        }

        public void setReserved_zero_future_use(int reserved_zero_future_use) {
            this.reserved_zero_future_use = reserved_zero_future_use;
        }

        public int getFont_file_format() {
            return this.font_file_format;
        }

        public void setFont_file_format(int font_file_format) {
            this.font_file_format = font_file_format;
        }

        public int getUri_length() {
            return this.uri_length;
        }

        public void setUri_length(int uri_length) {
            this.uri_length = uri_length;
        }

        public byte[] getUri_char() {
            return this.uri_char;
        }

        public void setUri_char(byte[] uri_char) {
            this.uri_char = uri_char;
        }

        public int getFont_size() {
            return this.font_size;
        }

        public void setFont_size(int font_size) {
            this.font_size = font_size;
        }

        public int getFont_info_length() {
            return this.font_info_length;
        }

        public void setFont_info_length(int font_info_length) {
            this.font_info_length = font_info_length;
        }

        public byte[] getText_char() {
            return this.text_char;
        }

        public void setText_char(byte[] text_char) {
            this.text_char = text_char;
        }
    }
}

