/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFIT;
import nl.digitalekabeltelevisie.data.mpeg.psi.DFITSection;

public class DFITs
extends AbstractPSITabel {
    private final Map<Integer, DFIT> dfits = new TreeMap<Integer, DFIT>();

    public DFITs(PSI parentPSI) {
        super(parentPSI);
    }

    public void update(DFITSection section) {
        int pid = section.getParentPID().getPid();
        DFIT dfit = this.dfits.computeIfAbsent(pid, p -> new DFIT(this.parentPSI));
        dfit.update(section);
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("DFITs (Downloadable Font Information Tables)"));
        for (Map.Entry<Integer, DFIT> dfitEntry : this.dfits.entrySet()) {
            t.add(dfitEntry.getValue().getJTreeNode(modus));
        }
        return t;
    }
}

