/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.PSI;
import nl.digitalekabeltelevisie.data.mpeg.psi.AbstractPSITabel;
import nl.digitalekabeltelevisie.data.mpeg.psi.INTsection;
import nl.digitalekabeltelevisie.util.Utils;

public class INT
extends AbstractPSITabel {
    private final Map<Integer, INTsection[]> networks = new HashMap<Integer, INTsection[]>();

    public INT(PSI parent) {
        super(parent);
    }

    public void update(INTsection section) {
        int key = section.getPlatformID();
        INTsection[] sections = this.networks.computeIfAbsent(key, k -> new INTsection[section.getSectionLastNumber() + 1]);
        if (sections[section.getSectionNumber()] == null) {
            sections[section.getSectionNumber()] = section;
        } else {
            INTsection last = sections[section.getSectionNumber()];
            INT.updateSectionVersion(section, last);
        }
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("INT (IP/MAC Notification Table)"));
        TreeSet<Integer> s = new TreeSet<Integer>(this.networks.keySet());
        for (Integer platformID : s) {
            INTsection[] sections = this.networks.get(platformID);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(new KVP("platform_id", platformID, Utils.getPlatformIDString(platformID)));
            for (INTsection tsection : sections) {
                if (tsection == null) continue;
                INT.addSectionVersionsToJTree(n, tsection, modus);
            }
            t.add(n);
        }
        return t;
    }
}

