/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.Descriptor;
import nl.digitalekabeltelevisie.data.mpeg.descriptors.DescriptorFactory;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSectionExtendedSyntax;
import nl.digitalekabeltelevisie.util.Utils;

public class INTsection
extends TableSectionExtendedSyntax {
    private final List<Descriptor> platformdescriptorList;
    private final List<TargetLoop> targetLoopList;
    private final int action_type;
    private final int platform_id_hash;
    private final int platformID;
    private final int processing_order;
    private final int platform_descriptor_loop_length;

    public INTsection(PsiSectionData raw_data, PID parent) {
        super(raw_data, parent);
        this.action_type = Utils.getInt(raw_data.getData(), 3, 1, 255);
        this.platform_id_hash = Utils.getInt(raw_data.getData(), 4, 1, 255);
        this.platformID = Utils.getInt(raw_data.getData(), 8, 3, 0xFFFFFF);
        this.processing_order = Utils.getInt(raw_data.getData(), 11, 1, 255);
        this.platform_descriptor_loop_length = Utils.getInt(raw_data.getData(), 12, 2, 4095);
        this.platformdescriptorList = DescriptorFactory.buildDescriptorList(raw_data.getData(), 14, this.platform_descriptor_loop_length, this);
        this.targetLoopList = this.buildTargetLoopList(raw_data.getData(), 14 + this.platform_descriptor_loop_length, this.sectionLength - this.platform_descriptor_loop_length - 18);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("INTsection section=");
        b.append(this.getSectionNumber()).append(", lastSection=").append(this.getSectionLastNumber()).append(", tableType=").append(INTsection.getTableType(this.tableId)).append(", ");
        return b.toString();
    }

    private List<TargetLoop> buildTargetLoopList(byte[] data, int i, int programInfoLength) {
        TargetLoop c;
        ArrayList<TargetLoop> r = new ArrayList<TargetLoop>();
        for (int t = 0; t < programInfoLength; t += 2 + c.getOperational_descriptor_loop_length()) {
            c = new TargetLoop();
            c.setTarget_descriptor_loop_length(Utils.getInt(data, i + t, 2, 4095));
            c.setTarget_descriptor_loop(DescriptorFactory.buildDescriptorList(data, i + t + 2, c.getTarget_descriptor_loop_length(), this));
            c.setOperational_descriptor_loop_length(Utils.getInt(data, i + (t += 2 + c.getTarget_descriptor_loop_length()), 2, 4095));
            c.setOperational_descriptor_loop(DescriptorFactory.buildDescriptorList(data, i + t + 2, c.getOperational_descriptor_loop_length(), this));
            r.add(c);
        }
        return r;
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = super.getJTreeNode(modus);
        t.add(new DefaultMutableTreeNode(new KVP("action_type", this.action_type, Utils.getActionTypeString(this.action_type))));
        t.add(new DefaultMutableTreeNode(new KVP("platform_id_hash", this.platform_id_hash, null)));
        t.add(new DefaultMutableTreeNode(new KVP("platform_id", this.platformID, Utils.getPlatformIDString(this.platformID))));
        t.add(new DefaultMutableTreeNode(new KVP("processing_order", this.processing_order, null)));
        t.add(new DefaultMutableTreeNode(new KVP("platform_descriptor_loop_length", this.platform_descriptor_loop_length, null)));
        Utils.addListJTree(t, this.platformdescriptorList, modus, "platform_descriptor_loop");
        Utils.addListJTree(t, this.targetLoopList, modus, "target_loop");
        return t;
    }

    @Override
    protected String getTableIdExtensionLabel() {
        return "action_type (8) / platform_id_hash (8)";
    }

    public int getPlatformID() {
        return this.platformID;
    }

    public int getAction_type() {
        return this.action_type;
    }

    public static class TargetLoop
    implements TreeNode {
        private int target_descriptor_loop_length;
        private int operational_descriptor_loop_length;
        private List<Descriptor> target_descriptor_loop;
        private List<Descriptor> operational_descriptor_loop;

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("target"));
            t.add(new DefaultMutableTreeNode(new KVP("target_descriptor_loop_length", this.target_descriptor_loop_length, null)));
            Utils.addListJTree(t, this.target_descriptor_loop, modus, "target_descriptor_loop");
            t.add(new DefaultMutableTreeNode(new KVP("operational_descriptor_loop_length", this.operational_descriptor_loop_length, null)));
            Utils.addListJTree(t, this.operational_descriptor_loop, modus, "operational_descriptor_loop");
            return t;
        }

        public List<Descriptor> getOperational_descriptor_loop() {
            return this.operational_descriptor_loop;
        }

        public void setOperational_descriptor_loop(List<Descriptor> operational_descriptor_loop) {
            this.operational_descriptor_loop = operational_descriptor_loop;
        }

        public int getOperational_descriptor_loop_length() {
            return this.operational_descriptor_loop_length;
        }

        public void setOperational_descriptor_loop_length(int operational_descriptor_loop_length) {
            this.operational_descriptor_loop_length = operational_descriptor_loop_length;
        }

        public List<Descriptor> getTarget_descriptor_loop() {
            return this.target_descriptor_loop;
        }

        public void setTarget_descriptor_loop(List<Descriptor> target_descriptor_loop) {
            this.target_descriptor_loop = target_descriptor_loop;
        }

        public int getTarget_descriptor_loop_length() {
            return this.target_descriptor_loop_length;
        }

        public void setTarget_descriptor_loop_length(int target_descriptor_loop_length) {
            this.target_descriptor_loop_length = target_descriptor_loop_length;
        }
    }
}

