/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.data.mpeg.psi;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.TreeNode;
import nl.digitalekabeltelevisie.data.mpeg.TSPacket;
import nl.digitalekabeltelevisie.util.LookUpList;
import nl.digitalekabeltelevisie.util.Utils;

public class MegaFrameInitializationPacket
implements TreeNode {
    private LookUpList txFunctionType = new LookUpList.Builder().add(0, "tx_time_offset_function").add(1, "tx_frequency_offset_function").add(2, "tx_power_function").add(3, "private_data_function").add(4, "cell_id_function").add(5, "enable_function").add(6, "bandwidth_function").add(7, 255, "Future_use").build();
    private byte[] data;
    private int individual_addressing_length;
    private byte[] individual_addressing_byte;
    private List<TxFunctions> txFunctionsList = new ArrayList<TxFunctions>();

    public MegaFrameInitializationPacket(TSPacket tsPack) {
        TxFunctions txFunctions;
        this.data = tsPack.getData();
        this.individual_addressing_length = Utils.getInt(this.data, 16, 1, 255);
        this.individual_addressing_byte = Arrays.copyOfRange(this.data, 17, 17 + this.individual_addressing_length);
        for (int start = 0; start < this.individual_addressing_length; start += 3 + txFunctions.getFunction_loop_length()) {
            txFunctions = new TxFunctions(this.individual_addressing_byte, start);
            this.txFunctionsList.add(txFunctions);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("MegaFrameInitializationPacket");
        return b.toString();
    }

    @Override
    public DefaultMutableTreeNode getJTreeNode(int modus) {
        DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Mega-frame Initialization Packet"));
        t.add(new DefaultMutableTreeNode(new KVP("synchronization_id", this.getSynchronizationId(), this.getSynchronizationId() == 0 ? "SFN synchronization" : "Future use")));
        t.add(new DefaultMutableTreeNode(new KVP("section_length", this.getSectionLength(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("pointer", this.getPointer(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("periodic_flag", this.getPeriodicFlag(), this.getPeriodicFlag() == 0 ? "aperiodic mode" : "periodic mode")));
        t.add(new DefaultMutableTreeNode(new KVP("future_use", this.getFutureUse(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("synchronization_time_stamp", this.getSynchronizationTimeStamp(), (double)this.getSynchronizationTimeStamp() / 10000.0 + " ms")));
        t.add(new DefaultMutableTreeNode(new KVP("maximum_delay", this.getMaximumDelay(), (double)this.getMaximumDelay() / 10000.0 + " ms")));
        DefaultMutableTreeNode tps = new DefaultMutableTreeNode(new KVP("tps_mip", this.getTPS_MIP(), null));
        t.add(tps);
        tps.add(new DefaultMutableTreeNode(new KVP("constellation", this.getConstellation(), MegaFrameInitializationPacket.getConstellationString(this.getConstellation()))));
        tps.add(new DefaultMutableTreeNode(new KVP("hierarchy", this.getHierarchy(), MegaFrameInitializationPacket.getHierarchyString(this.getHierarchy()))));
        tps.add(new DefaultMutableTreeNode(new KVP("code_rate", this.getCodeRate(), MegaFrameInitializationPacket.getCodeRateString(this.getCodeRate()))));
        tps.add(new DefaultMutableTreeNode(new KVP("guard_interval", this.getGuardInterval(), MegaFrameInitializationPacket.getGuardIntervalString(this.getGuardInterval()))));
        tps.add(new DefaultMutableTreeNode(new KVP("transmission_mode", this.getTransmissionMode(), MegaFrameInitializationPacket.getTransmissionModeString(this.getTransmissionMode()))));
        tps.add(new DefaultMutableTreeNode(new KVP("bandwidth_channel", this.getBandwidthChannel(), MegaFrameInitializationPacket.getBandwidthChannelString(this.getBandwidthChannel()))));
        tps.add(new DefaultMutableTreeNode(new KVP("priority", this.getPriority(), this.getPriority() == 0 ? "Low Priority TS" : "Non-hierarchical or High Priority TS")));
        tps.add(new DefaultMutableTreeNode(new KVP("DVB-H signalling", this.getDVBHSignalling(), MegaFrameInitializationPacket.getDVBHSignallingString(this.getDVBHSignalling()))));
        tps.add(new DefaultMutableTreeNode(new KVP("reserved", this.getReserved(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("individual_addressing_length", this.getIndividualAddressingLength(), null)));
        t.add(new DefaultMutableTreeNode(new KVP("individual_addressing_byte", this.individual_addressing_byte, null)));
        Utils.addListJTree(t, this.txFunctionsList, modus, "TxFunctions");
        return t;
    }

    public int getSynchronizationId() {
        return Utils.getInt(this.data, 0, 1, 255);
    }

    public int getSectionLength() {
        return Utils.getInt(this.data, 1, 1, 255);
    }

    public int getPointer() {
        return Utils.getInt(this.data, 2, 2, 65535);
    }

    public int getPeriodicFlag() {
        return Utils.getInt(this.data, 4, 1, 128) >> 7;
    }

    public int getFutureUse() {
        return Utils.getInt(this.data, 4, 2, Short.MAX_VALUE);
    }

    public int getSynchronizationTimeStamp() {
        return Utils.getInt(this.data, 6, 3, 0xFFFFFF);
    }

    public int getMaximumDelay() {
        return Utils.getInt(this.data, 9, 3, 0xFFFFFF);
    }

    public long getTPS_MIP() {
        return Utils.getLong(this.data, 12, 4, -1L);
    }

    public int getConstellation() {
        return Utils.getInt(this.data, 12, 1, 192) >> 6;
    }

    public static String getConstellationString(int c) {
        switch (c) {
            case 0: {
                return "QPSK";
            }
            case 1: {
                return "16-QAM";
            }
            case 2: {
                return "64-QAM";
            }
            case 3: {
                return "Reserved";
            }
        }
        return "Illegal value";
    }

    private int getHierarchy() {
        return Utils.getInt(this.data, 12, 1, 56) >> 3;
    }

    public static String getHierarchyString(int c) {
        switch (c) {
            case 0: {
                return "Non hierarchical";
            }
            case 1: {
                return "\u03b1 = 1";
            }
            case 2: {
                return "\u03b1 = 2";
            }
            case 3: {
                return "\u03b1 = 4";
            }
        }
        return "see annex F of ETSI EN 300 744";
    }

    public int getCodeRate() {
        return Utils.getInt(this.data, 12, 1, 7);
    }

    public static String getCodeRateString(int c) {
        switch (c) {
            case 0: {
                return "1/2";
            }
            case 1: {
                return "2/3";
            }
            case 2: {
                return "3/4";
            }
            case 3: {
                return "5/6";
            }
            case 4: {
                return "7/8";
            }
        }
        return "reserved";
    }

    public int getGuardInterval() {
        return Utils.getInt(this.data, 13, 1, 192) >> 6;
    }

    public static String getGuardIntervalString(int c) {
        switch (c) {
            case 0: {
                return "1/32";
            }
            case 1: {
                return "1/16";
            }
            case 2: {
                return "1/8";
            }
            case 3: {
                return "1/4";
            }
        }
        return "Illegal value";
    }

    public int getTransmissionMode() {
        return Utils.getInt(this.data, 13, 1, 48) >> 4;
    }

    public static String getTransmissionModeString(int c) {
        switch (c) {
            case 0: {
                return "2K mode";
            }
            case 1: {
                return "8K mode";
            }
            case 2: {
                return "see annex F of ETSI EN 300 744";
            }
            case 3: {
                return "reserved";
            }
        }
        return "Illegal value";
    }

    public int getBandwidthChannel() {
        return Utils.getInt(this.data, 13, 1, 12) >> 2;
    }

    public static String getBandwidthChannelString(int c) {
        switch (c) {
            case 0: {
                return "7 MHz";
            }
            case 1: {
                return "8 MHz";
            }
            case 2: {
                return "6 MHz";
            }
            case 3: {
                return "bandwidth optionally signalled via bandwidth_function, see clause 6.1.7 of ETSI EN 300 744";
            }
        }
        return "Illegal value";
    }

    public int getPriority() {
        return Utils.getInt(this.data, 13, 1, 2) >> 1;
    }

    public int getDVBHSignalling() {
        return Utils.getInt(this.data, 13, 2, 384) >> 7;
    }

    public static String getDVBHSignallingString(int c) {
        switch (c) {
            case 0: {
                return "Time Slicing is not used, MPE-FEC not used";
            }
            case 1: {
                return "Time Slicing is not used, At least one elementary stream uses MPE-FEC";
            }
            case 2: {
                return "At least one elementary stream uses Time Slicing, MPE-FEC not used";
            }
            case 3: {
                return "At least one elementary stream uses Time Slicing, At least one elementary stream uses MPE-FEC";
            }
        }
        return "Illegal value";
    }

    public int getReserved() {
        return Utils.getInt(this.data, 14, 2, Short.MAX_VALUE);
    }

    public int getIndividualAddressingLength() {
        return Utils.getInt(this.data, 16, 1, 255);
    }

    public class TxFunctions
    implements TreeNode {
        int tx_identifier;
        int function_loop_length;
        private List<Function> functionList = new ArrayList<Function>();

        public TxFunctions(byte[] d, int start) {
            Function txFunction;
            this.tx_identifier = Utils.getInt(d, 0 + start, 2, 65535);
            this.function_loop_length = Utils.getInt(d, 2 + start, 1, 255);
            for (int localStart = start + 3; localStart < start + 3 + this.function_loop_length; localStart += txFunction.getFunction_length()) {
                txFunction = new Function(d, localStart);
                this.functionList.add(txFunction);
            }
        }

        @Override
        public DefaultMutableTreeNode getJTreeNode(int modus) {
            DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("TxFunctions"));
            t.add(new DefaultMutableTreeNode(new KVP("tx_identifier", this.tx_identifier, null)));
            t.add(new DefaultMutableTreeNode(new KVP("function_loop_length", this.function_loop_length, null)));
            Utils.addListJTree(t, this.functionList, modus, "Functions");
            return t;
        }

        public int getTx_identifier() {
            return this.tx_identifier;
        }

        public int getFunction_loop_length() {
            return this.function_loop_length;
        }

        public class Function
        implements TreeNode {
            private int function_tag;
            private int function_length;
            private int cell_id;
            private int wait_for_enable_flag;
            private int reserved_future_use;
            private short time_offset;
            private byte[] function_data;

            public Function(byte[] d, int st) {
                this.function_tag = Utils.getInt(d, st, 1, 255);
                this.function_length = Utils.getInt(d, st + 1, 1, 255);
                this.function_data = Arrays.copyOfRange(d, st + 2, st + this.function_length);
                if (this.function_tag == 0) {
                    this.time_offset = ByteBuffer.wrap(this.function_data).getShort();
                } else if (this.function_tag == 4) {
                    this.cell_id = Utils.getInt(d, st + 2, 2, 65535);
                    this.wait_for_enable_flag = Utils.getInt(d, st + 4, 1, 128) >>> 7;
                    this.reserved_future_use = Utils.getInt(d, st + 4, 1, 127);
                }
            }

            @Override
            public DefaultMutableTreeNode getJTreeNode(int modus) {
                DefaultMutableTreeNode t = new DefaultMutableTreeNode(new KVP("Function"));
                t.add(new DefaultMutableTreeNode(new KVP("function_tag", this.function_tag, MegaFrameInitializationPacket.this.txFunctionType.get(this.function_tag))));
                t.add(new DefaultMutableTreeNode(new KVP("function_length", this.function_length, null)));
                if (this.function_tag == 0) {
                    t.add(new DefaultMutableTreeNode(new KVP("time_offset", this.function_data, this.time_offset + " * 100 ns")));
                } else if (this.function_tag == 4) {
                    t.add(new DefaultMutableTreeNode(new KVP("cell_id", this.cell_id, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("wait_for_enable_flag", this.wait_for_enable_flag, null)));
                    t.add(new DefaultMutableTreeNode(new KVP("reserved_future_use", this.reserved_future_use, null)));
                } else {
                    t.add(new DefaultMutableTreeNode(new KVP("function_data", this.function_data, null)));
                }
                return t;
            }

            public int getFunction_tag() {
                return this.function_tag;
            }

            public int getFunction_length() {
                return this.function_length;
            }
        }
    }
}

